package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.optional.Optional;

interface MetadataService {
    /**
     * Gets information about the current application being instrumented. This is sent with the
     * following events, as well as all sessions:
     * <ul>
     * <li>START</li>
     * <li>INFO_LOG</li>
     * <li>ERROR_LOG</li>
     * <li>WARNING_LOG</li>
     * <li>CRASH</li>
     * </ul>
     *
     * @return the application information
     */
    AppInfo getAppInfo();

    /**
     * Whether or not this is a debug build of the application.
     *
     * @return true if the build is a debug build, otherwise false
     */
    boolean isDebug();

    /**
     * Gets the app ID which is defined as part of the build.
     *
     * @return the app ID.
     */
    String getAppId();

    /**
     * Gets information and specifications of the current device. This is sent with the following
     * events, as well as all sessions:
     * <ul>
     * <li>START</li>
     * <li>INFO_LOG</li>
     * <li>ERROR_LOG</li>
     * <li>WARNING_LOG</li>
     * <li>CRASH</li>
     * </ul>
     *
     * @return the device information
     */
    DeviceInfo getDeviceInfo();

    /**
     * Retrieves telephony information from the device:
     * <ul>
     * <li>The name of the carrier</li>
     * <li>The ISO country-code of the carrier</li>
     * <li>The Mobile Country Code (MCC) identifying the country of the device</li>
     * <li>The Mobile Network Code (MNC) identifying the network the device is connected to</li>
     * </ul>
     * <p>
     * This is sent with the following events:
     * <ul>
     * <li>START</li>
     * <li>INFO_LOG</li>
     * <li>ERROR_LOG</li>
     * <li>WARNING_LOG</li>
     * </ul>
     *
     * @return the telephony information
     */
    TelephonyInfo getTelephonyInfo();

    /**
     * Gets the current device's disk usage and space available.
     *
     * @return the device's disk usage statistics
     */
    DiskUsage getDiskUsage();

    /**
     * Attempts to determine the formatted version code of the package expected by the Embrace SDK.
     *
     * @return optionally the formatted version code
     */
    Optional<String> getAppVersionCodeForRequest();

    /**
     * Gets the unique ID from the device. This is an MD5 hash of the Android Secure ID.
     *
     * @return the unique device ID
     */
    String getDeviceId();

    /**
     * @return the app version code.
     */
    String getAppVersionCode();

    /**
     * @return the app version name.
     */
    String getAppVersionName();

    /**
     * @return is the app was updated since last launch.
     */
    boolean isAppUpdated();

    /**
     * @return is the OS was updated since last launch.
     */
    boolean isOsUpdated();

    /**
     * Sets the currently active session ID;
     *
     * @param sessionId the session ID that is currently active
     */
    void setActiveSessionId(String sessionId);

    /**
     * Gets the currently active session ID, if present.
     *
     * @return an optional containing the currently active session ID
     */
    Optional<String> getActiveSessionId();


    /**
     * Returns 'active' if the application is in the foreground, or 'background' if the app is in
     * the background.
     *
     * @return the current state of the app
     */
    String getAppState();
}
