package io.embrace.android.embracesdk;

import java.io.Closeable;
import java.util.List;

/**
 * Provides access to information about the state of the device's memory usage.
 */
interface MemoryService extends Closeable {

    /**
     * Called when the memory is 'trimmed' by Android and records a low memory warning:
     * {@url https://developer.android.com/reference/android/content/ComponentCallbacks2}
     *
     * Android trims memory when it is running low.
     */
    void onMemoryWarning();

    /**
     * Gets free and used memory samples collected between the specified period.
     *
     * @param startTime the starting timestamp of the period
     * @param endTime the ending timestamp of the period
     * @return the list of memory samples within the specified period
     */
    List<MemorySample> getMemorySamples(long startTime, long endTime);

    /**
     * Gets a list of low memory warnings during the specified period.
     *
     * @param startTime the starting timestamp of the period
     * @param endTime the ending timestamp of the period
     * @return the list of memory warnings within the specified period
     */
    List<MemoryWarning> getMemoryWarnings(long startTime, long endTime);


}
