/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.PreferencesService;
import java.util.HashSet;
import java.util.Set;

final class EmbracePreferencesService
implements PreferencesService,
ActivityListener {
    static final String SDK_STARTUP_IN_PROGRESS = "startup_entered";
    static final String SDK_STARTUP_COMPLETED = "startup_completed";
    private static final String SDK_STARTUP_STATUS_KEY = "io.embrace.sdkstartup";
    private static final String DEVICE_IDENTIFIER_KEY = "io.embrace.deviceid";
    private static final String PREVIOUS_APP_VERSION_KEY = "io.embrace.lastappversion";
    private static final String PREVIOUS_OS_VERSION_KEY = "io.embrace.lastosversion";
    private static final String INSTALL_DATE_KEY = "io.embrace.installtimestamp";
    private static final String USER_IDENTIFIER_KEY = "io.embrace.userid";
    private static final String USER_EMAIL_ADDRESS_KEY = "io.embrace.useremail";
    private static final String USER_USERNAME_KEY = "io.embrace.username";
    private static final String USER_IS_PAYER_KEY = "io.embrace.userispayer";
    private static final String USER_PERSONAS_KEY = "io.embrace.userpersonas";
    private static final String CUSTOM_PERSONAS_KEY = "io.embrace.custompersonas";
    private static final String LAST_USER_MESSAGE_FAILED_KEY = "io.embrace.userupdatefailed";
    private static final String SDK_DISABLED_KEY = "io.embrace.disabled";
    private static final String SDK_CONFIG_FETCHED_TIMESTAMP = "io.embrace.sdkfetchedtimestamp";
    private final SharedPreferences preferences;

    @Override
    public void applicationStartupComplete() {
        EmbracePreferencesService.setStringPreference(this.preferences, SDK_STARTUP_STATUS_KEY, SDK_STARTUP_COMPLETED);
    }

    EmbracePreferencesService(Context context, ActivityService activityService) {
        Preconditions.checkNotNull((Object)context, (Object)"context must not be null");
        this.preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        ((ActivityService)Preconditions.checkNotNull((Object)activityService)).addListener(this);
        EmbracePreferencesService.setStringPreference(this.preferences, SDK_STARTUP_STATUS_KEY, SDK_STARTUP_IN_PROGRESS);
    }

    private static Optional<String> getStringPreference(SharedPreferences preferences, String key) {
        String value = null;
        if (preferences != null) {
            value = preferences.getString(key, null);
        }
        return Optional.fromNullable(value);
    }

    private static void setStringPreference(SharedPreferences preferences, String key, String value) {
        if (preferences != null && !TextUtils.isEmpty((CharSequence)key)) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(key, value);
            editor.apply();
        }
    }

    private static Optional<Long> getLongPreference(SharedPreferences preferences, String key) {
        long defaultValue;
        long value = defaultValue = -1L;
        if (preferences != null) {
            value = preferences.getLong(key, defaultValue);
        }
        if (value == -1L) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)value);
    }

    private static void setLongPreference(SharedPreferences preferences, String key, long value) {
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putLong(key, value);
            editor.apply();
        }
    }

    private static Optional<Float> getFloatPreference(SharedPreferences preferences, String key) {
        Float defaultValue = Float.valueOf(-1.0f);
        float value = defaultValue.floatValue();
        if (preferences != null) {
            value = preferences.getFloat(key, defaultValue.floatValue());
        }
        if (value == -1.0f) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)Float.valueOf(value));
    }

    private static void setFloatPreference(SharedPreferences preferences, String key, float value) {
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putFloat(key, value);
            editor.apply();
        }
    }

    private static Optional<Integer> getIntegerPreference(SharedPreferences preferences, String key) {
        int defaultValue;
        int value = defaultValue = -1;
        if (preferences != null) {
            value = preferences.getInt(key, defaultValue);
        }
        if (value == -1) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)value);
    }

    private static void setIntegerPreference(SharedPreferences preferences, String key, int value) {
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putInt(key, value);
            editor.apply();
        }
    }

    private static boolean getBooleanPreference(SharedPreferences preferences, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (preferences != null) {
            value = preferences.getBoolean(key, defaultValue);
        }
        return value;
    }

    private static void setBooleanPreference(SharedPreferences preferences, String key, boolean value) {
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putBoolean(key, value);
            editor.apply();
        }
    }

    private static void setArrayPreference(SharedPreferences preferences, String key, Set<String> value) {
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putStringSet(key, value);
            editor.apply();
        }
    }

    private static Optional<Set<String>> getArrayPreference(SharedPreferences preferences, String key) {
        Set defaultValue = null;
        Set value = new HashSet();
        if (preferences != null) {
            value = preferences.getStringSet(key, defaultValue);
        }
        return Optional.fromNullable(value);
    }

    @Override
    public Optional<String> getAppVersion() {
        return EmbracePreferencesService.getStringPreference(this.preferences, PREVIOUS_APP_VERSION_KEY);
    }

    @Override
    public void setAppVersion(String appVersion) {
        EmbracePreferencesService.setStringPreference(this.preferences, PREVIOUS_APP_VERSION_KEY, appVersion);
    }

    @Override
    public Optional<String> getOsVersion() {
        return EmbracePreferencesService.getStringPreference(this.preferences, PREVIOUS_OS_VERSION_KEY);
    }

    @Override
    public void setOsVersion(String osVersion) {
        EmbracePreferencesService.setStringPreference(this.preferences, PREVIOUS_OS_VERSION_KEY, osVersion);
    }

    @Override
    public Optional<Long> getInstallDate() {
        return EmbracePreferencesService.getLongPreference(this.preferences, INSTALL_DATE_KEY);
    }

    @Override
    public void setInstallDate(long installDate) {
        EmbracePreferencesService.setLongPreference(this.preferences, INSTALL_DATE_KEY, installDate);
    }

    @Override
    public Optional<String> getDeviceIdentifier() {
        return EmbracePreferencesService.getStringPreference(this.preferences, DEVICE_IDENTIFIER_KEY);
    }

    @Override
    public void setDeviceIdentifier(String deviceIdentifier) {
        EmbracePreferencesService.setStringPreference(this.preferences, DEVICE_IDENTIFIER_KEY, deviceIdentifier);
    }

    @Override
    public Optional<String> getSDKStartupStatus() {
        return EmbracePreferencesService.getStringPreference(this.preferences, SDK_STARTUP_STATUS_KEY);
    }

    @Override
    public boolean getSDKDisabled() {
        return EmbracePreferencesService.getBooleanPreference(this.preferences, SDK_DISABLED_KEY, false);
    }

    @Override
    public void setSDKDisabled(boolean disabled) {
        EmbracePreferencesService.setBooleanPreference(this.preferences, SDK_DISABLED_KEY, disabled);
    }

    @Override
    public boolean getUserPayer() {
        return EmbracePreferencesService.getBooleanPreference(this.preferences, USER_IS_PAYER_KEY, false);
    }

    @Override
    public void setUserPayer(boolean payer) {
        EmbracePreferencesService.setBooleanPreference(this.preferences, USER_IS_PAYER_KEY, payer);
    }

    @Override
    public Optional<String> getUserIdentifier() {
        return EmbracePreferencesService.getStringPreference(this.preferences, USER_IDENTIFIER_KEY);
    }

    @Override
    public void setUserIdentifier(String identifier) {
        EmbracePreferencesService.setStringPreference(this.preferences, USER_IDENTIFIER_KEY, identifier);
    }

    @Override
    public Optional<String> getUserEmailAddress() {
        return EmbracePreferencesService.getStringPreference(this.preferences, USER_EMAIL_ADDRESS_KEY);
    }

    @Override
    public void setUserEmailAddress(String emailAddress) {
        EmbracePreferencesService.setStringPreference(this.preferences, USER_EMAIL_ADDRESS_KEY, emailAddress);
    }

    @Override
    public Optional<Set<String>> getUserPersonas() {
        return EmbracePreferencesService.getArrayPreference(this.preferences, USER_PERSONAS_KEY);
    }

    @Override
    public void setUserPersonas(Set<String> personas) {
        EmbracePreferencesService.setArrayPreference(this.preferences, USER_PERSONAS_KEY, personas);
    }

    @Override
    public Optional<Set<String>> getCustomPersonas() {
        return EmbracePreferencesService.getArrayPreference(this.preferences, CUSTOM_PERSONAS_KEY);
    }

    @Override
    public void setCustomPersonas(Set<String> personas) {
        EmbracePreferencesService.setArrayPreference(this.preferences, CUSTOM_PERSONAS_KEY, personas);
    }

    @Override
    public Optional<String> getUsername() {
        return EmbracePreferencesService.getStringPreference(this.preferences, USER_USERNAME_KEY);
    }

    @Override
    public void setUsername(String username) {
        EmbracePreferencesService.setStringPreference(this.preferences, USER_USERNAME_KEY, username);
    }

    @Override
    public Optional<Long> getLastConfigFetchDate() {
        return EmbracePreferencesService.getLongPreference(this.preferences, SDK_CONFIG_FETCHED_TIMESTAMP);
    }

    @Override
    public void setLastConfigFetchDate(long fetchDate) {
        EmbracePreferencesService.setLongPreference(this.preferences, SDK_CONFIG_FETCHED_TIMESTAMP, fetchDate);
    }

    @Override
    public boolean userMessageNeedsRetry() {
        return EmbracePreferencesService.getBooleanPreference(this.preferences, LAST_USER_MESSAGE_FAILED_KEY, false);
    }

    @Override
    public void setUserMessageNeedsRetry(boolean needsRetry) {
        EmbracePreferencesService.setBooleanPreference(this.preferences, LAST_USER_MESSAGE_FAILED_KEY, needsRetry);
    }
}

