/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import android.util.Pair;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.Breadcrumb;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.Breadcrumbs;
import io.embrace.android.embracesdk.CustomBreadcrumb;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EvictingLinkedBlockingDeque;
import io.embrace.android.embracesdk.TapBreadcrumb;
import io.embrace.android.embracesdk.ViewBreadcrumb;
import java.util.List;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

class EmbraceBreadcrumbService
implements BreadcrumbService {
    static final int BREADCRUMB_VIEW_SIZE = 20;
    static final int BREADCRUMB_TAP_SIZE = 80;
    static final int CUSTOM_BREADCRUMB_SIZE = 40;
    private static final Integer BREADCRUMB_VIEW_LOG_MAX = 50;
    private static final Integer BREADCRUMB_TAP_LOG_MAX = 100;
    private static final Integer BREADCRUMB_CUSTOM_LOG_MAX = 100;
    private final EvictingLinkedBlockingDeque<ViewBreadcrumb> viewBreadcrumbs = new EvictingLinkedBlockingDeque(BREADCRUMB_VIEW_LOG_MAX);
    private final EvictingLinkedBlockingDeque<TapBreadcrumb> tapBreadcrumbs = new EvictingLinkedBlockingDeque(BREADCRUMB_TAP_LOG_MAX);
    private final EvictingLinkedBlockingDeque<CustomBreadcrumb> customBreadcrumbs = new EvictingLinkedBlockingDeque(BREADCRUMB_CUSTOM_LOG_MAX);

    EmbraceBreadcrumbService() {
    }

    @Override
    public void logView(String screen, long timestamp) {
        this.addToViewLogsQueue(screen, timestamp, false);
    }

    @Override
    public void forceLogView(String screen, long timestamp) {
        this.addToViewLogsQueue(screen, timestamp, true);
    }

    @Override
    public void logTap(Pair<Float, Float> point, String element, long timestamp, TapBreadcrumb.TapBreadcrumbType type) {
        try {
            this.tapBreadcrumbs.forcePutLast(new TapBreadcrumb(point, element, timestamp, type));
        }
        catch (InterruptedException ex) {
            EmbraceLogger.logError("Thread was interrupted while attempting to register tap breadcrumb.", ex);
        }
    }

    @Override
    public void logCustom(String message, long timestamp) {
        try {
            if (TextUtils.isEmpty((CharSequence)message)) {
                EmbraceLogger.logWarning("Breadcrumb message must not be blank");
                return;
            }
            this.customBreadcrumbs.forcePutLast(new CustomBreadcrumb(message, timestamp));
        }
        catch (InterruptedException ex) {
            EmbraceLogger.logError("Thread was interrupted while attempting to register a custom breadcrumb.", ex);
        }
    }

    @Override
    public List<ViewBreadcrumb> getViewBreadcrumbsForSession(long startTime, long endTime, int limit) {
        return this.filterBreadcrumbsForTimeWindow(this.viewBreadcrumbs, startTime, endTime, limit);
    }

    @Override
    public List<TapBreadcrumb> getTapBreadcrumbsForSession(long startTime, long endTime, int limit) {
        return this.filterBreadcrumbsForTimeWindow(this.tapBreadcrumbs, startTime, endTime, limit);
    }

    @Override
    public List<CustomBreadcrumb> getCustomBreadcrumbsForSession(long startTime, long endTime, int limit) {
        return this.filterBreadcrumbsForTimeWindow(this.customBreadcrumbs, startTime, endTime, limit);
    }

    @Override
    public Breadcrumbs getBreadcrumbs(long start, long end, int limit) {
        return Breadcrumbs.newBuilder().withCustomBreadcrumbs(this.getCustomBreadcrumbsForSession(start, end, limit)).withTapBreadcrumbs(this.getTapBreadcrumbsForSession(start, end, limit)).withViewBreadcrumbs(this.getViewBreadcrumbsForSession(start, end, limit)).build();
    }

    @Override
    public Optional<String> getLastViewBreadcrumbScreenName() {
        if (this.viewBreadcrumbs.isEmpty()) {
            return Optional.absent();
        }
        return ((ViewBreadcrumb)this.viewBreadcrumbs.peekLast()).getScreen();
    }

    private synchronized void addToViewLogsQueue(String screen, long timestamp, boolean force) {
        ViewBreadcrumb lastViewBreadcrumb = (ViewBreadcrumb)this.viewBreadcrumbs.peekLast();
        if (force || lastViewBreadcrumb == null || !((String)lastViewBreadcrumb.getScreen().or((Object)"")).equalsIgnoreCase(String.valueOf(screen))) {
            try {
                this.viewBreadcrumbs.forcePutLast(new ViewBreadcrumb(screen, timestamp));
            }
            catch (InterruptedException ex) {
                EmbraceLogger.logError("Thread was interrupted while attempting to register view breadcrumb.", ex);
            }
        }
    }

    private <T extends Breadcrumb> List<T> filterBreadcrumbsForTimeWindow(EvictingLinkedBlockingDeque<T> breadcrumbs, long startTime, long endTime, int limit) {
        List filteredBreadcrumbs = (List)StreamSupport.stream(breadcrumbs).filter(breadcrumb -> breadcrumb.getTimestamp() >= startTime).filter(breadcrumb -> endTime <= 0L || breadcrumb.getTimestamp() <= endTime).collect(Collectors.toList());
        return filteredBreadcrumbs.subList(Math.max(filteredBreadcrumbs.size() - limit, 0), filteredBreadcrumbs.size());
    }
}

