/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.res.AssetManager;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

final class BuildInfo {
    private static final String FILE_BUILD_INFO = "build-info.json";
    @SerializedName(value="app-id")
    private final String appId;
    @SerializedName(value="build-id")
    private final String buildId;

    BuildInfo(String appId, String buildId) {
        this.appId = appId;
        this.buildId = buildId;
    }

    static BuildInfo fromFile(Context context) {
        InputStream buildInfoStream = null;
        InputStreamReader inputStreamReader = null;
        JsonReader reader = null;
        try {
            AssetManager assets = context.getApplicationContext().getAssets();
            buildInfoStream = assets.open(FILE_BUILD_INFO);
            inputStreamReader = new InputStreamReader(buildInfoStream);
            reader = new JsonReader((Reader)inputStreamReader);
            BuildInfo buildInfo = (BuildInfo)new Gson().fromJson(reader, BuildInfo.class);
            return buildInfo;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read build-info.json", ex);
        }
        finally {
            try {
                if (buildInfoStream != null) {
                    buildInfoStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logWarning("Failed to close build-info.json", ex);
            }
        }
    }

    String getAppId() {
        return this.appId;
    }

    String getBuildId() {
        return this.buildId;
    }
}

