/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.CustomFlow;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.Uuid;
import java.util.Map;

public final class RegistrationFlow
extends CustomFlow {
    public static final long FLAG_SET_USER_PAYER = 1L;
    static final String MOMENT_INTERNAL_REGISTRATION = "_internal-registration";
    static final String MOMENT_EXTERNAL_REGISTRATION = "_external-registration";
    static final String PROP_EMAIL = "email";
    static final String PROP_REGISTRATION_SOURCE = "registration-source";
    static final String PROP_USERNAME = "username";
    static final String PROP_USER_ID = "user-id";
    private Map<String, Object> registrationProps;
    private volatile String registrationMomentName;
    private volatile String registrationMomentId;

    public boolean registrationStart(String userId, String username, String email, Map<String, Object> properties) {
        Map<String, Object> normalizedProperties = PropertyUtils.sanitizeProperties(properties);
        if (userId != null) {
            normalizedProperties.put(PROP_USER_ID, userId);
        }
        if (username != null) {
            normalizedProperties.put(PROP_USERNAME, username);
        }
        if (email != null) {
            normalizedProperties.put(PROP_EMAIL, email);
        }
        return this.sendRegistrationStartMoment(MOMENT_INTERNAL_REGISTRATION, normalizedProperties);
    }

    public boolean registrationStart(String source, Map<String, Object> properties) {
        Map<String, Object> normalizedProperties = PropertyUtils.sanitizeProperties(properties);
        if (source != null) {
            normalizedProperties.put(PROP_REGISTRATION_SOURCE, source);
        }
        return this.sendRegistrationStartMoment(MOMENT_EXTERNAL_REGISTRATION, normalizedProperties);
    }

    boolean sendRegistrationStartMoment(String momentName, Map<String, Object> properties) {
        this.registrationMomentName = momentName;
        this.registrationMomentId = Uuid.getEmbUuid();
        this.registrationProps = PropertyUtils.sanitizeProperties(properties);
        this.sendMomentStartEvent(this.registrationMomentName, this.registrationMomentId, false, this.registrationProps);
        return true;
    }

    public boolean registrationComplete() {
        return this.registrationComplete(null);
    }

    public boolean registrationComplete(Boolean isPayer) {
        if (this.registrationMomentId == null) {
            EmbraceLogger.logError("Registration wasn't started.");
            return false;
        }
        this.sendMomentEndEvent(this.registrationMomentName, this.registrationMomentId);
        this.sendLogInfo("Registration was completed.", this.registrationProps);
        Embrace embrace = Embrace.getInstance();
        if (isPayer != null) {
            if (isPayer.booleanValue()) {
                embrace.setUserAsPayer();
            } else {
                embrace.clearUserAsPayer();
            }
        }
        String email = (String)this.registrationProps.get(PROP_EMAIL);
        String username = (String)this.registrationProps.get(PROP_USERNAME);
        String userId = (String)this.registrationProps.get(PROP_USER_ID);
        if (!TextUtils.isEmpty((CharSequence)email)) {
            embrace.setUserEmail(email);
        }
        if (!TextUtils.isEmpty((CharSequence)username)) {
            embrace.setUsername(username);
        }
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            embrace.setUserIdentifier(userId);
        }
        this.registrationMomentId = null;
        return true;
    }

    public boolean registrationFail(String msg) {
        if (this.registrationMomentId == null) {
            EmbraceLogger.logError("Registration wasn't started.");
            return false;
        }
        if (msg != null) {
            this.registrationProps.put("message", msg);
        }
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? "A failure occurred during registration." : "A failure occurred during registration: " + msg;
        this.sendMomentEndEvent(this.registrationMomentName, this.registrationMomentId);
        this.sendLogError(errorLogMsg, false, this.registrationProps);
        this.registrationMomentId = null;
        return true;
    }
}

