/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Interval;
import io.embrace.android.embracesdk.NetworkCall;
import io.embrace.android.embracesdk.NetworkService;
import io.embrace.android.embracesdk.NetworkSession;
import io.embrace.android.embracesdk.NetworkTimeline;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java9.util.Maps;

class EmbraceNetworkService
extends BroadcastReceiver
implements NetworkService {
    private static final int SLOW_REQUEST_THRESHOLD = 500;
    private final IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    private final NavigableMap<Long, NetworkStatus> networkReachable;
    private final NavigableMap<Long, NetworkCall> networkCalls;
    private final ConnectivityManager connectivityManager;
    private final Context context;

    public EmbraceNetworkService(Context context) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context must not be null");
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.networkReachable = new TreeMap<Long, NetworkStatus>();
        this.networkCalls = new ConcurrentSkipListMap<Long, NetworkCall>();
        try {
            context.registerReceiver((BroadcastReceiver)this, this.intentFilter);
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Failed to register EmbraceNetworkService broadcast receiver. Connectivity status will be unavailable.", ex);
        }
    }

    public void onReceive(Context context, Intent intent) {
        try {
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                if (networkInfo.getType() == 1) {
                    this.saveStatus(NetworkStatus.WIFI);
                } else if (networkInfo.getType() == 0) {
                    this.saveStatus(NetworkStatus.WAN);
                }
            } else {
                this.saveStatus(NetworkStatus.NOT_REACHABLE);
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Failed to handle CONNECTIVITY_ACTION broadcast", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Interval> getNetworkInterfaceIntervals(long startTime, long endTime) {
        EmbraceNetworkService embraceNetworkService = this;
        synchronized (embraceNetworkService) {
            ArrayList<Interval> results = new ArrayList<Interval>();
            for (Map.Entry<Long, NetworkStatus> entry : this.networkReachable.subMap(startTime, endTime).entrySet()) {
                long currentTime;
                NetworkStatus value = entry.getValue();
                if (value.equals((Object)NetworkStatus.NOT_REACHABLE)) continue;
                Long next = this.networkReachable.higherKey(currentTime = entry.getKey().longValue());
                results.add(new Interval(currentTime, next != null ? next : currentTime, value.getName()));
            }
            return results;
        }
    }

    @Override
    public List<NetworkCall> getNetworkCalls(long startTime, long endTime) {
        return new ArrayList<NetworkCall>(this.networkCalls.subMap(startTime, endTime).values());
    }

    @Override
    public NetworkSession getNetworkSession(long startTime, long lastKnownTime) {
        HashMap<String, NetworkTimeline> timelines = new HashMap<String, NetworkTimeline>();
        HashMap results = new HashMap();
        ArrayList<NetworkCall> problematicCalls = new ArrayList<NetworkCall>();
        List<NetworkCall> calls = this.getNetworkCalls(startTime, lastKnownTime);
        for (NetworkCall networkCall : calls) {
            String method = networkCall.getHttpMethod();
            String url = networkCall.getUrl();
            Integer statusCode = networkCall.getStatusCode();
            if (networkCall.isDidClientError() || networkCall.getStatusCode() >= 300 || networkCall.getEndTime() - networkCall.getStartTime() >= 500L) {
                problematicCalls.add(networkCall);
            }
            if (TextUtils.isEmpty((CharSequence)method) || TextUtils.isEmpty((CharSequence)url) || statusCode == null) continue;
            String methodUrl = String.format("%s_%s", method, url);
            Maps.putIfAbsent(results, (Object)methodUrl, new ArrayList());
            ((List)results.get(methodUrl)).add(new NetworkTimeline.NetworkRequest(networkCall.getStatusCode(), networkCall.getStartTime(), networkCall.getDuration()));
        }
        for (Map.Entry entry : results.entrySet()) {
            timelines.put((String)entry.getKey(), new NetworkTimeline((List)entry.getValue(), ((List)entry.getValue()).size()));
        }
        return new NetworkSession(timelines, problematicCalls);
    }

    @Override
    public void logNetworkCall(String url, String httpMethod, Integer statusCode, long startTime, long endTime, Long bytesSent, Long bytesReceived) {
        NetworkCall networkCall = NetworkCall.newBuilder().withUrl(url).withHttpMethod(httpMethod).withStatusCode(statusCode).withStartTime(startTime).withDuration(Math.max(endTime - startTime, 0L)).withEndTime(endTime).withBytesSent(bytesSent).withBytesReceived(bytesReceived).build();
        if (networkCall.isValidNetworkCall()) {
            this.networkCalls.put(startTime, networkCall);
        }
    }

    @Override
    public void logNetworkError(String url, String httpMethod, long startTime, long endTime, String errorType, String errorMessage) {
        NetworkCall networkCall = NetworkCall.newBuilder().withUrl(url).withHttpMethod(httpMethod).withStartTime(startTime).withEndTime(endTime).withDuration(Math.max(endTime - startTime, 0L)).withErrorType(errorType).withErrorMessage(errorMessage).build();
        if (networkCall.isValidNetworkCall()) {
            this.networkCalls.put(startTime, networkCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStatus(NetworkStatus networkStatus) {
        EmbraceNetworkService embraceNetworkService = this;
        synchronized (embraceNetworkService) {
            if (this.networkReachable.isEmpty() || !this.networkReachable.lastEntry().getValue().equals((Object)networkStatus)) {
                this.networkReachable.put(System.currentTimeMillis(), networkStatus);
            }
        }
    }

    @Override
    public void close() {
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    private static enum NetworkStatus {
        NOT_REACHABLE("none"),
        WIFI("wifi"),
        WAN("wan");

        private String name;

        private NetworkStatus(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

