/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Base64;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.util.UUID;

final class NetworkCall {
    @SerializedName(value="rid")
    private final String requestId;
    @SerializedName(value="x")
    private final String httpMethod;
    @SerializedName(value="dur")
    private final long duration;
    @SerializedName(value="bi")
    private final long bytesReceived;
    @SerializedName(value="bo")
    private final long bytesSent;
    @SerializedName(value="url")
    private final String url;
    @SerializedName(value="st")
    private final long startTime;
    @SerializedName(value="et")
    private final long endTime;
    @SerializedName(value="rc")
    private final Integer statusCode;
    @SerializedName(value="er")
    private final boolean didClientError;
    @SerializedName(value="ed")
    private final String errorType;
    @SerializedName(value="de")
    private final String errorMessage;

    public String getRequestId() {
        return this.requestId;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public String getUrl() {
        return this.url;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public boolean isDidClientError() {
        return this.didClientError;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private NetworkCall(Builder builder) {
        this.requestId = builder.requestId;
        this.httpMethod = builder.httpMethod;
        this.duration = builder.duration;
        this.bytesReceived = builder.bytesReceived;
        this.bytesSent = builder.bytesSent;
        this.url = builder.url;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusCode = builder.statusCode;
        this.didClientError = builder.didClientError;
        this.errorType = builder.errorType;
        this.errorMessage = builder.errorMessage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static String createRequestId() {
        return String.format("%.6s", Base64.encodeToString((byte[])UUID.randomUUID().toString().getBytes(), (int)2).replace('+', '0').replace(' ', '0'));
    }

    public boolean isValidNetworkCall() {
        if (this.statusCode != null && (this.statusCode < 100 || this.statusCode > 599)) {
            EmbraceLogger.logError("Failed to log network call: Invalid status code (valid ranges: 100 ~ 599 inclusive).");
            return false;
        }
        if (this.startTime < 0L) {
            EmbraceLogger.logError("Failed to log network call: Start time is a negative value.");
            return false;
        }
        if (this.endTime < 0L) {
            EmbraceLogger.logError("Failed to log network call: End time is a negative value.");
            return false;
        }
        return true;
    }

    static /* synthetic */ String access$1300() {
        return NetworkCall.createRequestId();
    }

    public static final class Builder {
        private String requestId = NetworkCall.access$1300();
        private String httpMethod;
        private long duration;
        private long bytesReceived;
        private long bytesSent;
        private String url;
        private long startTime;
        private long endTime;
        private Integer statusCode;
        private boolean didClientError;
        private String errorType;
        private String errorMessage;

        private Builder() {
        }

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder withHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder withBytesReceived(long bytesReceived) {
            this.bytesReceived = bytesReceived;
            return this;
        }

        public Builder withBytesSent(long bytesSent) {
            this.bytesSent = bytesSent;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder withStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder withDidClientError(boolean didClientError) {
            this.didClientError = didClientError;
            return this;
        }

        public Builder withErrorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder withErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public NetworkCall build() {
            return new NetworkCall(this);
        }
    }
}

