/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.Config;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MessageType;
import java.util.Set;
import java.util.regex.Pattern;
import java9.util.stream.StreamSupport;

final class EmbraceConfigService
implements ConfigService,
ActivityListener {
    private static final long CONFIG_TTL = 3600000L;
    private static final String CONFIG_FILE_NAME = "config.json";
    private final BackgroundWorker worker = BackgroundWorker.ofSingleThread("SDK Configuration");
    private final ApiClient apiClient;
    private final CacheService cacheService;
    private final Object lock = new Object();
    private volatile Config config = Config.ofDefault();
    private volatile long lastUpdated;

    public EmbraceConfigService(ApiClient apiClient, EmbraceActivityService activityService, CacheService cacheService) {
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient, (Object)"apiClient must not be null");
        this.cacheService = (CacheService)Preconditions.checkNotNull((Object)cacheService, (Object)"cacheService must not be null");
        ((EmbraceActivityService)Preconditions.checkNotNull((Object)activityService)).addListener(this);
        Optional<Config> optionalConfig = cacheService.loadObject(CONFIG_FILE_NAME, Config.class);
        if (optionalConfig.isPresent()) {
            this.config = (Config)optionalConfig.get();
        }
    }

    @Override
    public Config getConfig() {
        if (this.configRequiresRefresh()) {
            this.worker.submit(() -> {
                Object object = this.lock;
                synchronized (object) {
                    if (this.configRequiresRefresh()) {
                        try {
                            this.config = this.apiClient.getConfig().get();
                            this.cacheService.cacheObject(CONFIG_FILE_NAME, this.config);
                            this.lastUpdated = System.currentTimeMillis();
                        }
                        catch (Exception ex) {
                            EmbraceLogger.logWarning("Failed to load SDK config from the server", ex);
                        }
                    }
                    return this.config;
                }
            });
        }
        return this.config;
    }

    @Override
    public boolean isScreenshotDisabledForEvent(String eventName) {
        return this.doesStringMatchesPatternInSet(eventName, this.config.getDisabledScreenshotPatterns());
    }

    @Override
    public boolean isEventDisabled(String eventName) {
        return this.doesStringMatchesPatternInSet(eventName, this.config.getDisabledEventAndLogPatterns());
    }

    @Override
    public boolean isLogMessageDisabled(String logMessage) {
        return this.doesStringMatchesPatternInSet(logMessage, this.config.getDisabledEventAndLogPatterns());
    }

    @Override
    public boolean isMessageTypeDisabled(MessageType type) {
        return this.doesStringMatchesPatternInSet(type.name().toLowerCase(), this.config.getDisabledEventAndLogPatterns());
    }

    @Override
    public void onResume(boolean coldStart, boolean appInForeground, long startupTime) {
        this.getConfig();
    }

    private boolean doesStringMatchesPatternInSet(String string, Set<String> patternSet) {
        return StreamSupport.stream(patternSet).map(Pattern::compile).anyMatch(p -> p.matcher(string).matches());
    }

    private boolean configRequiresRefresh() {
        return System.currentTimeMillis() - this.lastUpdated > 3600000L;
    }

    @Override
    public void close() {
        EmbraceLogger.logInfo("Shutting down EmbraceConfigService");
        this.worker.close();
    }
}

