/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.SystemClock;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.annotation.StartupActivity;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java9.util.stream.StreamSupport;

final class EmbraceActivityService
implements ActivityService {
    private static final int MAX_STARTUP_DELAY_IN_MILLIS = 2000;
    private static final long APP_STATE_BACKGROUND_DELAY_MS = 1500L;
    private final ScheduledWorker appStateWorker = ScheduledWorker.ofSingleThread("App state service");
    private final MemoryService memoryService;
    private final BreadcrumbService breadcrumbService;
    private final List<ActivityListener> listeners = new CopyOnWriteArrayList<ActivityListener>();
    private volatile WeakReference<Activity> currentActivity = new WeakReference<Object>(null);
    private volatile long stateLastUpdatedTime = 0L;
    private volatile boolean coldStart = true;
    private volatile long startTime;

    private EmbraceActivityService(MemoryService memoryService, BreadcrumbService breadcrumbService) {
        this.memoryService = (MemoryService)Preconditions.checkNotNull((Object)memoryService);
        this.breadcrumbService = (BreadcrumbService)Preconditions.checkNotNull((Object)breadcrumbService);
        this.startTime = System.currentTimeMillis();
    }

    static EmbraceActivityService ofApplication(Application application, MemoryService memoryService, BreadcrumbService breadcrumbService) {
        EmbraceActivityService service = new EmbraceActivityService(memoryService, breadcrumbService);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)service);
        application.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)service);
        return service;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.onForegroundPhase(activity);
    }

    public void onActivityStarted(Activity activity) {
        this.breadcrumbService.logView(activity.getClass().getName(), System.currentTimeMillis());
        this.onForegroundPhase(activity);
    }

    public void onActivityResumed(Activity activity) {
        if (!activity.getClass().isAnnotationPresent(StartupActivity.class)) {
            StreamSupport.stream(this.listeners).forEach(ActivityListener::applicationStartupComplete);
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        this.onBackgroundPhase(activity);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.onBackgroundPhase(activity);
    }

    private synchronized void updateStateWithActivity(Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
        this.stateLastUpdatedTime = SystemClock.elapsedRealtime();
    }

    private synchronized void onForegroundPhase(Activity activity) {
        if (this.isInBackground()) {
            EmbraceLogger.logDebug("App entered foreground.");
            boolean foregroundSession = System.currentTimeMillis() - this.startTime <= 2000L;
            StreamSupport.stream(this.listeners).forEach(listener -> listener.onResume(this.coldStart, foregroundSession, this.startTime));
            this.coldStart = false;
        }
        this.updateStateWithActivity(activity);
    }

    private synchronized void onBackgroundPhase(Activity activity) {
        if (activity == this.currentActivity.get()) {
            this.updateStateWithActivity(null);
            this.appStateWorker.scheduleWithDelay(() -> {
                if (this.isInBackground()) {
                    EmbraceLogger.logDebug("App entered background");
                    StreamSupport.stream(this.listeners).forEach(ActivityListener::onBackground);
                }
            }, 1500L, TimeUnit.MILLISECONDS);
        }
    }

    public void onTrimMemory(int trimLevel) {
        if (trimLevel == 10) {
            try {
                this.memoryService.onMemoryWarning();
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to handle onTrimMemory (low memory) event", ex);
            }
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
    }

    @Override
    public boolean isInBackground() {
        return this.currentActivity.get() == null && SystemClock.elapsedRealtime() - this.stateLastUpdatedTime >= 1500L;
    }

    @Override
    public Optional<Activity> getForegroundActivity() {
        return Optional.fromNullable(this.currentActivity.get());
    }

    @Override
    public void addListener(ActivityListener listener, boolean priority) {
        if (priority) {
            this.listeners.add(0, listener);
        } else {
            this.listeners.add(listener);
        }
    }

    @Override
    public void addListener(ActivityListener listener) {
        this.addListener(listener, false);
    }

    @Override
    public void removeListener(ActivityListener listener) {
        this.listeners.remove(listener);
    }
}

