/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Application;
import android.content.Context;
import android.util.Pair;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.AnrService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.BuildInfo;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.CpuService;
import io.embrace.android.embracesdk.CrashService;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceAnrService;
import io.embrace.android.embracesdk.EmbraceBreadcrumbService;
import io.embrace.android.embracesdk.EmbraceCacheService;
import io.embrace.android.embracesdk.EmbraceConfigService;
import io.embrace.android.embracesdk.EmbraceCpuService;
import io.embrace.android.embracesdk.EmbraceCrashService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceEventService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceMemoryService;
import io.embrace.android.embracesdk.EmbraceMetadataService;
import io.embrace.android.embracesdk.EmbraceNetworkService;
import io.embrace.android.embracesdk.EmbracePowerService;
import io.embrace.android.embracesdk.EmbracePreferencesService;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EmbraceScreenshotService;
import io.embrace.android.embracesdk.EmbraceSessionService;
import io.embrace.android.embracesdk.EmbraceUserService;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NetworkService;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.ScreenshotService;
import io.embrace.android.embracesdk.StreamHandlerFactoryInstaller;
import io.embrace.android.embracesdk.TapBreadcrumb;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.util.HashMap;
import java.util.Map;

public final class Embrace {
    private static final Embrace embrace = new Embrace();
    private volatile Application application;
    private CacheService cacheService;
    private CrashService crashService;
    private BreadcrumbService breadcrumbService;
    private EmbraceSessionService sessionService;
    private MetadataService metadataService;
    private PowerService powerService;
    private MemoryService memoryService;
    private EmbraceActivityService activityService;
    private NetworkService networkService;
    private CpuService cpuService;
    private BuildInfo buildInfo;
    private AnrService anrService;
    private EmbraceRemoteLogger remoteLogger;
    private ConfigService configService;
    private ApiClient apiClient;
    private PreferencesService preferencesService;
    private ScreenshotService screenshotService;
    private EventService eventService;
    private UserService userService;

    public static Embrace getInstance() {
        return embrace;
    }

    public void start(Application application) {
        Preconditions.checkState((this.application == null ? 1 : 0) != 0, (Object)"Embrace SDK has already been initialized");
        this.application = (Application)Preconditions.checkNotNull((Object)application, (Object)"application must not be null");
        Context context = this.application.getApplicationContext();
        try {
            this.powerService = new EmbracePowerService(context);
            this.memoryService = EmbraceMemoryService.ofContext(context);
            this.breadcrumbService = new EmbraceBreadcrumbService();
            this.activityService = EmbraceActivityService.ofApplication(application, this.memoryService, this.breadcrumbService);
            this.preferencesService = new EmbracePreferencesService(context, this.activityService);
            this.networkService = new EmbraceNetworkService(context);
            this.cpuService = new EmbraceCpuService();
            this.anrService = new EmbraceAnrService();
            this.buildInfo = BuildInfo.fromFile(context);
            this.metadataService = EmbraceMetadataService.ofContext(context, this.powerService, this.memoryService, this.cpuService, this.networkService, this.anrService, this.buildInfo, this.preferencesService, this.activityService);
            this.cacheService = new EmbraceCacheService(context);
            this.apiClient = new ApiClient(this.metadataService, this.cacheService);
            this.configService = new EmbraceConfigService(this.apiClient, this.activityService, this.cacheService);
            this.userService = new EmbraceUserService(this.activityService, this.configService, this.preferencesService, this.apiClient);
            this.screenshotService = new EmbraceScreenshotService(this.activityService, this.configService, this.apiClient);
            this.eventService = new EmbraceEventService(this.apiClient, this.configService, this.metadataService, this.userService, this.screenshotService, this.activityService);
            this.remoteLogger = new EmbraceRemoteLogger(this.metadataService, this.screenshotService, this.apiClient, this.userService, this.configService);
            this.sessionService = new EmbraceSessionService(this.preferencesService, this.metadataService, this.breadcrumbService, this.powerService, this.activityService, this.apiClient, this.eventService, this.remoteLogger, this.userService, this.configService, this.cacheService);
            this.crashService = new EmbraceCrashService(this.sessionService, this.metadataService, this.apiClient, this.userService);
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Exception occurred whilst initializing the Embrace SDK. Instrumentation may be disabled.", ex);
        }
        StreamHandlerFactoryInstaller.registerFactory();
    }

    public boolean isStarted() {
        return this.application != null;
    }

    @Deprecated
    public void setLogLevel(EmbraceLogger.Severity severity) {
    }

    public void setUserIdentifier(String userId) {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
            return;
        }
        if (this.userService != null) {
            this.userService.setUserIdentifier(userId);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user identifier");
        }
    }

    public void clearUserIdentifier() {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
            return;
        }
        if (this.userService != null) {
            this.userService.clearUserIdentifier();
        }
    }

    public void setUserEmail(String email) {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
            return;
        }
        if (this.userService != null) {
            this.userService.setUserEmail(email);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user identifier");
        }
    }

    public void clearUserEmail() {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
            return;
        }
        if (this.userService != null) {
            this.userService.clearUserEmail();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user email");
        }
    }

    public void setUserAsPayer() {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
            return;
        }
        if (this.userService != null) {
            this.userService.setUserAsPayer();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user as payer");
        }
    }

    public void clearUserAsPayer() {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
            return;
        }
        if (this.userService != null) {
            this.userService.clearUserAsPayer();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user as payer");
        }
    }

    public void setUserPersona(String persona) {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring user persona update.");
            return;
        }
        if (this.userService != null) {
            this.userService.setUserPersona(persona);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user persona");
        }
    }

    public void clearUserPersona(String persona) {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring user persona update.");
            return;
        }
        if (this.userService != null) {
            this.userService.clearUserPersona(persona);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user persona");
        }
    }

    public void setUsername(String username) {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
            return;
        }
        if (this.userService != null) {
            this.userService.setUsername(username);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set username");
        }
    }

    public void clearUsername() {
        if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
            EmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
            return;
        }
        if (this.userService != null) {
            this.userService.clearUsername();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear username");
        }
    }

    public void startEvent(String name) {
        if (this.eventService != null) {
            this.eventService.startEvent(name);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log event");
        }
    }

    public void startEvent(String name, String identifier) {
        if (this.eventService != null) {
            this.eventService.startEvent(name, identifier);
        }
    }

    public void startEvent(String name, String identifier, boolean allowScreenshot) {
        if (this.eventService != null) {
            this.eventService.startEvent(name, identifier, allowScreenshot);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log event");
        }
    }

    public void startEvent(String name, String identifier, boolean allowScreenshot, Map<String, Object> properties) {
        if (this.eventService != null) {
            HashMap<String, Object> normalizedProperties = new HashMap();
            if (properties != null) {
                normalizedProperties = PropertyUtils.sanitizeProperties(properties);
            }
            this.eventService.startEvent(name, identifier, allowScreenshot, normalizedProperties);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log event");
        }
    }

    public void endEvent(String name) {
        if (this.eventService != null) {
            this.eventService.endEvent(name);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log event");
        }
    }

    public void endEvent(String name, String identifier) {
        if (this.eventService != null) {
            this.eventService.endEvent(name, identifier);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log event");
        }
    }

    public void endAppStartup() {
    }

    public void logNetworkCall(String url, HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        if (this.networkService != null) {
            this.networkService.logNetworkCall(url, httpMethod.name(), statusCode, startTime, endTime, bytesSent, bytesReceived);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log network call");
        }
    }

    public void logNetworkClientError(String url, HttpMethod httpMethod, long startTime, long endTime, String errorType, String errorMessage) {
        if (this.networkService != null) {
            this.networkService.logNetworkError(url, httpMethod.name(), startTime, endTime, errorType, errorMessage);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log network error");
        }
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Map<String, Object> properties) {
        this.logMessage(EmbraceEvent.Type.INFO_LOG, message, properties, false);
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void logWarning(String message, Map<String, Object> properties) {
        this.logMessage(EmbraceEvent.Type.WARNING_LOG, message, properties, false);
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Map<String, Object> properties) {
        this.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, true);
    }

    public void logError(String message, Map<String, Object> properties, boolean allowScreenshot) {
        this.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, allowScreenshot);
    }

    void logMessage(EmbraceEvent.Type type, String message, Map<String, Object> properties, boolean allowScreenshot) {
        if (this.remoteLogger != null) {
            try {
                this.remoteLogger.log(message, type, allowScreenshot, properties);
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to log message using Embrace SDK.", ex);
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log message.");
        }
    }

    public void logBreadcrumb(String message) {
        if (this.breadcrumbService != null) {
            this.breadcrumbService.logCustom(message, System.currentTimeMillis());
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log breadcrumb.");
        }
    }

    void logView(String screen) {
        if (this.breadcrumbService != null) {
            this.breadcrumbService.logView(screen, System.currentTimeMillis());
        }
    }

    void forceLogView(String screen) {
        if (this.breadcrumbService != null) {
            this.breadcrumbService.forceLogView(screen, System.currentTimeMillis());
        }
    }

    void logTap(Pair<Float, Float> point, String elementName, TapBreadcrumb.TapBreadcrumbType type) {
        if (this.breadcrumbService != null) {
            this.breadcrumbService.logTap(point, elementName, System.currentTimeMillis(), type);
        }
    }

    EventService getEventService() {
        return this.eventService;
    }

    EmbraceRemoteLogger getRemoteLogger() {
        return this.remoteLogger;
    }
}

