/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Process;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class WorkerUtils {
    static ThreadFactory createTheadFactory(String name) {
        return runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable::run);
            thread.setName("Embrace Background Worker " + name);
            return thread;
        };
    }

    static void shutdownHook(final ExecutorService service, String name) {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new PriorityRunnable(){

            @Override
            public void runWithPriority() {
                try {
                    EmbraceLogger.logDebug("Shutdown hook for executor called");
                    service.shutdown();
                    if (!service.awaitTermination(4L, TimeUnit.SECONDS)) {
                        EmbraceLogger.logDebug("Executor did not shut down in time, shutting down immediately");
                        service.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    EmbraceLogger.logDebug("Interrupted whilst attempting to shut down.");
                    service.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
        }, "Embrace Shutdown Hook for Worker: " + name));
    }

    private WorkerUtils() {
    }

    private static abstract class PriorityRunnable
    implements Runnable {
        private PriorityRunnable() {
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
        }

        abstract void runWithPriority();
    }
}

