/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.CustomFlow;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.Uuid;
import java.util.HashMap;
import java.util.Map;

public final class PurchaseFlow
extends CustomFlow {
    static final String MOMENT_ADD_TO_CART = "_add-to-cart";
    static final String MOMENT_PURCHASE = "_purchase";
    static final String PROP_AMOUNT = "amount";
    static final String PROP_ITEM_ID = "item-id";
    static final String PROP_NUM_ITEMS = "num-items";
    static final String PROP_ORDER_ID = "order-id";
    static final String PROP_PAYMENT_TYPE = "payment-type";
    static final String PROP_PRICE = "price";
    static final String PROP_QUANTITY = "quantity";
    private final Map<String, Map<String, Object>> addToCartPropsMap = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> purchaseProps = new HashMap<String, Object>();
    private volatile String purchaseMomentId;

    public String addToCartStart(String itemId, Number quantity, Number price, Map<String, Object> properties) {
        String momentId = Uuid.getEmbUuid();
        Map<String, Object> normalizedProperties = PropertyUtils.sanitizeProperties(properties);
        if (itemId != null) {
            normalizedProperties.put(PROP_ITEM_ID, itemId);
        }
        if (quantity != null) {
            normalizedProperties.put(PROP_QUANTITY, quantity.toString());
        }
        if (price != null) {
            normalizedProperties.put(PROP_PRICE, price.toString());
        }
        this.sendMomentStartEvent(MOMENT_ADD_TO_CART, momentId, true, normalizedProperties);
        this.addToCartPropsMap.put(momentId, normalizedProperties);
        return momentId;
    }

    public boolean addToCartComplete(String momentId) {
        if (TextUtils.isEmpty((CharSequence)momentId) || !this.addToCartPropsMap.containsKey(momentId)) {
            EmbraceLogger.logError("Purchase flow does not recognize add-to-cart moment identifier.");
            return false;
        }
        this.sendMomentEndEvent(MOMENT_ADD_TO_CART, momentId);
        this.addToCartPropsMap.remove(momentId);
        return true;
    }

    public boolean addToCartFail(String momentId, String msg) {
        if (TextUtils.isEmpty((CharSequence)momentId) || !this.addToCartPropsMap.containsKey(momentId)) {
            EmbraceLogger.logError("Purchase flow does not recognize add-to-cart moment identifier.");
            return false;
        }
        Map<String, Object> properties = this.addToCartPropsMap.get(momentId);
        if (msg != null) {
            properties.put("message", msg);
        }
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? "A failure occurred while adding an item to the cart." : "A failure occurred while adding an item to the cart: " + msg;
        this.sendLogError(errorLogMsg, true, properties);
        this.sendMomentEndEvent(MOMENT_ADD_TO_CART, momentId);
        this.addToCartPropsMap.remove(momentId);
        return true;
    }

    public boolean purchaseStart(String orderId, Number numItems, Number amount, String paymentType, Map<String, Object> properties) {
        Map<String, Object> normalizedProperties = PropertyUtils.sanitizeProperties(properties);
        if (orderId != null) {
            normalizedProperties.put(PROP_ORDER_ID, orderId);
        }
        if (numItems != null) {
            normalizedProperties.put(PROP_NUM_ITEMS, numItems.toString());
        }
        if (amount != null) {
            normalizedProperties.put(PROP_AMOUNT, amount.toString());
        }
        if (paymentType != null) {
            normalizedProperties.put(PROP_PAYMENT_TYPE, paymentType);
        }
        this.purchaseMomentId = Uuid.getEmbUuid();
        this.purchaseProps = normalizedProperties;
        this.sendMomentStartEvent(MOMENT_PURCHASE, this.purchaseMomentId, false, normalizedProperties);
        return true;
    }

    public boolean purchaseComplete() {
        if (this.purchaseMomentId == null) {
            EmbraceLogger.logError("Purchase wasn't started.");
            return false;
        }
        this.sendMomentEndEvent(MOMENT_PURCHASE, this.purchaseMomentId);
        this.sendLogInfo("Purchase was completed.", this.purchaseProps);
        Embrace.getInstance().setUserAsPayer();
        this.purchaseMomentId = null;
        return true;
    }

    public boolean purchaseFail(String msg) {
        if (this.purchaseMomentId == null) {
            EmbraceLogger.logError("Purchase wasn't started.");
            return false;
        }
        if (msg != null) {
            this.purchaseProps.put("message", msg);
        }
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? "A failure occurred during purchase." : "A failure occurred during purchase: " + msg;
        this.sendMomentEndEvent(MOMENT_PURCHASE, this.purchaseMomentId);
        this.sendLogError(errorLogMsg, false, this.purchaseProps);
        this.purchaseMomentId = null;
        return true;
    }
}

