/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.BatteryMeasurement;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Interval;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.ScheduledWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;

final class EmbracePowerService
extends BroadcastReceiver
implements PowerService {
    private final ScheduledWorker batteryWorker;
    private final IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
    private final NavigableMap<Long, BatteryMeasurement> measurements;
    private final NavigableMap<Long, Boolean> batteryCharging;

    EmbracePowerService(Context context) {
        Preconditions.checkNotNull((Object)context, (Object)"context must not be null");
        this.measurements = new ConcurrentSkipListMap<Long, BatteryMeasurement>();
        this.batteryCharging = new TreeMap<Long, Boolean>();
        this.batteryWorker = ScheduledWorker.ofSingleThread("Power Service");
        this.batteryWorker.scheduleAtFixedRate(() -> this.queryBatteryLevel(context), 0L, 60L, TimeUnit.SECONDS);
        try {
            context.registerReceiver((BroadcastReceiver)this, this.intentFilter);
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Failed to register EmbracePowerService broadcast receiver. Battery charging status will be unavailable.", ex);
        }
    }

    public void onReceive(Context context, Intent intent) {
        try {
            long timestamp = System.currentTimeMillis();
            this.addBatteryMeasurement(intent, timestamp);
            this.updateBatteryChargingStatus(intent, timestamp);
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Failed to handle ACTION_BATTERY_CHANGED broadcast", ex);
        }
    }

    @Override
    public void close() {
        EmbraceLogger.logInfo("Stopping EmbracePowerService");
        this.batteryWorker.close();
    }

    private void addBatteryMeasurement(Intent intent, long timestamp) {
        float batteryLevel = intent.getIntExtra("level", -1);
        float batteryMax = intent.getIntExtra("scale", -1);
        if (batteryMax > 0.0f && batteryLevel >= 0.0f) {
            float batteryPercentage = batteryLevel / batteryMax;
            this.measurements.put(timestamp, new BatteryMeasurement(timestamp, batteryPercentage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBatteryChargingStatus(Intent intent, long timestamp) {
        EmbracePowerService embracePowerService = this;
        synchronized (embracePowerService) {
            int status = intent.getIntExtra("status", -1);
            if (status > -1) {
                boolean batteryCharging;
                boolean bl = batteryCharging = status == 2 || status == 5;
                if (this.batteryCharging.isEmpty() || batteryCharging != this.batteryCharging.lastEntry().getValue()) {
                    this.batteryCharging.put(timestamp, batteryCharging);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Interval> getChargingIntervals(long startTime, long endTime) {
        EmbracePowerService embracePowerService = this;
        synchronized (embracePowerService) {
            ArrayList<Interval> results = new ArrayList<Interval>();
            for (Map.Entry<Long, Boolean> entry : this.batteryCharging.subMap(startTime, endTime).entrySet()) {
                long currentTime;
                if (!entry.getValue().booleanValue()) continue;
                Long next = this.batteryCharging.higherKey(currentTime = entry.getKey().longValue());
                results.add(new Interval(currentTime, next != null ? next : currentTime));
            }
            return results;
        }
    }

    @Override
    public List<BatteryMeasurement> getBatteryMeasurements(long startTime, long endTime) {
        return new ArrayList<BatteryMeasurement>(this.measurements.subMap(startTime, endTime).values());
    }

    @Override
    public Optional<Float> getLatestBatteryLevel() {
        if (this.measurements.isEmpty()) {
            return Optional.absent();
        }
        BatteryMeasurement latest = this.measurements.lastEntry().getValue();
        return Optional.of((Object)Float.valueOf(latest.getValue()));
    }

    private void queryBatteryLevel(Context context) {
        try {
            this.onReceive(context, context.registerReceiver(null, this.intentFilter));
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Failed to query battery level", ex);
        }
    }
}

