/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java9.util.Maps;
import java9.util.Sets;

class Config {
    private static final int DEFAULT_THRESHOLD = 100;
    private static final int DEFAULT_OFFSET = 0;
    @SerializedName(value="threshold")
    private final Integer threshold;
    @SerializedName(value="offset")
    private final Integer offset;
    @SerializedName(value="screenshots_enabled")
    private final Boolean screenshotsEnabled;
    @SerializedName(value="personas")
    private final Set<String> appPersonas;
    @SerializedName(value="event_limits")
    private final Map<String, Long> eventLimits;
    @SerializedName(value="disabled_message_types")
    private final Set<String> disabledMessageTypes;
    @SerializedName(value="disabled_event_and_log_patterns")
    private final Set<String> disabledEventAndLogPatterns;
    @SerializedName(value="disabled_url_patterns")
    private final Set<String> disabledUrlPatterns;
    @SerializedName(value="disabled_screenshot_patterns")
    private final Set<String> disabledScreenshotPatterns;

    public Config(Integer threshold, Integer offset, Boolean screenshotsEnabled, Set<String> appPersonas, Map<String, Long> eventLimits, Set<String> disabledMessageTypes, Set<String> disabledEventAndLogPatterns, Set<String> disabledUrlPatterns, Set<String> disabledScreenshotPatterns) {
        this.threshold = threshold;
        this.offset = offset;
        this.screenshotsEnabled = screenshotsEnabled;
        this.appPersonas = appPersonas;
        this.eventLimits = eventLimits;
        this.disabledMessageTypes = disabledMessageTypes;
        this.disabledEventAndLogPatterns = disabledEventAndLogPatterns;
        this.disabledUrlPatterns = disabledUrlPatterns;
        this.disabledScreenshotPatterns = disabledScreenshotPatterns;
    }

    static Config ofDefault() {
        return new Config(100, 0, true, Sets.of(), Maps.of(), Sets.of(), Sets.of(), Sets.of(), Sets.of());
    }

    public Integer getThreshold() {
        return this.threshold != null ? this.threshold : 100;
    }

    public Integer getOffset() {
        return this.offset != null ? this.offset : 0;
    }

    public Boolean getScreenshotsEnabled() {
        return this.screenshotsEnabled != null ? this.screenshotsEnabled : true;
    }

    public Set<String> getAppPersonas() {
        return this.appPersonas != null ? this.appPersonas : new HashSet<String>();
    }

    public Map<String, Long> getEventLimits() {
        return this.eventLimits != null ? this.eventLimits : new HashMap<String, Long>();
    }

    public Set<String> getDisabledMessageTypes() {
        return this.disabledMessageTypes != null ? this.disabledMessageTypes : new HashSet<String>();
    }

    public Set<String> getDisabledEventAndLogPatterns() {
        return this.disabledEventAndLogPatterns != null ? this.disabledEventAndLogPatterns : new HashSet<String>();
    }

    public Set<String> getDisabledUrlPatterns() {
        return this.disabledUrlPatterns != null ? this.disabledUrlPatterns : new HashSet<String>();
    }

    public Set<String> getDisabledScreenshotPatterns() {
        return this.disabledScreenshotPatterns != null ? this.disabledScreenshotPatterns : new HashSet<String>();
    }

    public String toString() {
        return "Config{threshold=" + this.threshold + ", offset=" + this.offset + ", screenshotsEnabled=" + this.screenshotsEnabled + ", appPersonas=" + this.appPersonas + ", eventLimits=" + this.eventLimits + ", disabledMessageTypes=" + this.disabledMessageTypes + ", disabledEventAndLogPatterns=" + this.disabledEventAndLogPatterns + ", disabledUrlPatterns=" + this.disabledUrlPatterns + ", disabledScreenshotPatterns=" + this.disabledScreenshotPatterns + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        if (this.threshold != null ? !this.threshold.equals(config.threshold) : config.threshold != null) {
            return false;
        }
        if (this.offset != null ? !this.offset.equals(config.offset) : config.offset != null) {
            return false;
        }
        if (this.screenshotsEnabled != null ? !this.screenshotsEnabled.equals(config.screenshotsEnabled) : config.screenshotsEnabled != null) {
            return false;
        }
        if (this.appPersonas != null ? !this.appPersonas.equals(config.appPersonas) : config.appPersonas != null) {
            return false;
        }
        if (this.eventLimits != null ? !this.eventLimits.equals(config.eventLimits) : config.eventLimits != null) {
            return false;
        }
        if (this.disabledMessageTypes != null ? !this.disabledMessageTypes.equals(config.disabledMessageTypes) : config.disabledMessageTypes != null) {
            return false;
        }
        if (this.disabledEventAndLogPatterns != null ? !this.disabledEventAndLogPatterns.equals(config.disabledEventAndLogPatterns) : config.disabledEventAndLogPatterns != null) {
            return false;
        }
        if (this.disabledUrlPatterns != null ? !this.disabledUrlPatterns.equals(config.disabledUrlPatterns) : config.disabledUrlPatterns != null) {
            return false;
        }
        return this.disabledScreenshotPatterns != null ? this.disabledScreenshotPatterns.equals(config.disabledScreenshotPatterns) : config.disabledScreenshotPatterns == null;
    }

    public int hashCode() {
        int result = this.threshold != null ? this.threshold.hashCode() : 0;
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        result = 31 * result + (this.screenshotsEnabled != null ? this.screenshotsEnabled.hashCode() : 0);
        result = 31 * result + (this.appPersonas != null ? this.appPersonas.hashCode() : 0);
        result = 31 * result + (this.eventLimits != null ? this.eventLimits.hashCode() : 0);
        result = 31 * result + (this.disabledMessageTypes != null ? this.disabledMessageTypes.hashCode() : 0);
        result = 31 * result + (this.disabledEventAndLogPatterns != null ? this.disabledEventAndLogPatterns.hashCode() : 0);
        result = 31 * result + (this.disabledUrlPatterns != null ? this.disabledUrlPatterns.hashCode() : 0);
        result = 31 * result + (this.disabledScreenshotPatterns != null ? this.disabledScreenshotPatterns.hashCode() : 0);
        return result;
    }
}

