/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Looper;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.WorkerUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class BackgroundWorker {
    private final ExecutorService executorService;

    BackgroundWorker(ExecutorService executorService) {
        this.executorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService, (Object)"executorService must not be null");
    }

    <T> T submitAndGet(Callable<T> task) {
        try {
            Future<T> future = this.executorService.submit(task);
            if (Looper.getMainLooper() == Looper.myLooper()) {
                return future.get(4L, TimeUnit.SECONDS);
            }
            return future.get();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to execute task", ex);
        }
    }

    <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    public static BackgroundWorker ofSingleThread(String workerName) {
        return new BackgroundWorker(BackgroundWorker.createSingleThreadExecutor(workerName));
    }

    private static ExecutorService createSingleThreadExecutor(String name) {
        ExecutorService executor = Executors.newSingleThreadExecutor(WorkerUtils.createTheadFactory(name));
        WorkerUtils.shutdownHook(executor, name);
        return executor;
    }
}

