/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

final class AppInfo {
    @SerializedName(value="v")
    private final String appVersion;
    @SerializedName(value="bi")
    private final String buildId;
    @SerializedName(value="e")
    private final String environment;
    @SerializedName(value="vu")
    private final boolean appUpdated;
    @SerializedName(value="vul")
    private final boolean appUpdatedThisLaunch;
    @SerializedName(value="bv")
    private final String bundleVersion;
    @SerializedName(value="ou")
    private final boolean osUpdated;
    @SerializedName(value="oul")
    private final boolean osUpdatedThisLaunch;
    @SerializedName(value="sdk")
    private final String sdkVersion;
    @SerializedName(value="sdc")
    private final String sdkSimpleVersion;

    private AppInfo(Builder builder) {
        this.appVersion = builder.appVersion;
        this.buildId = builder.buildId;
        this.environment = builder.environment;
        this.appUpdated = builder.appUpdated;
        this.appUpdatedThisLaunch = builder.appUpdatedThisLaunch;
        this.bundleVersion = builder.bundleVersion;
        this.osUpdated = builder.osUpdated;
        this.osUpdatedThisLaunch = builder.osUpdatedThisLaunch;
        this.sdkVersion = builder.sdkVersion;
        this.sdkSimpleVersion = builder.sdkSimpleVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String appVersion;
        private String buildId;
        private String environment;
        private boolean appUpdated;
        private boolean appUpdatedThisLaunch;
        private String bundleVersion;
        private boolean osUpdated;
        private boolean osUpdatedThisLaunch;
        private String sdkVersion;
        private String sdkSimpleVersion;

        private Builder() {
        }

        public Builder withAppVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public Builder withBuildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public Builder withEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder withAppUpdated(boolean appUpdated) {
            this.appUpdated = appUpdated;
            return this;
        }

        public Builder withAppUpdatedThisLaunch(boolean appUpdatedThisLaunch) {
            this.appUpdatedThisLaunch = appUpdatedThisLaunch;
            return this;
        }

        public Builder withBundleVersion(String bundleVersion) {
            this.bundleVersion = bundleVersion;
            return this;
        }

        public Builder withOsUpdated(boolean osUpdated) {
            this.osUpdated = osUpdated;
            return this;
        }

        public Builder withOsUpdatedThisLaunch(boolean osUpdatedThisLaunch) {
            this.osUpdatedThisLaunch = osUpdatedThisLaunch;
            return this;
        }

        public Builder withSdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this;
        }

        public Builder withSdkSimpleVersion(String sdkSimpleVersion) {
            this.sdkSimpleVersion = sdkSimpleVersion;
            return this;
        }

        public AppInfo build() {
            return new AppInfo(this);
        }
    }
}

