/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.ActivityManager;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.FixedSizeDeque;
import io.embrace.android.embracesdk.ITimestamp;
import io.embrace.android.embracesdk.MemorySample;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SystemEvent;
import io.embrace.android.embracesdk.TimestampUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class MemoryManager {
    private static final int MEMORY_LOG_MAX = 600;
    private static final long SHUTDOWN_TIMEOUT_MS = 2000L;
    private static final int BYTES_IN_MB = 0x100000;
    private static final MemoryManager manager = new MemoryManager();
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private Future memoryInfoFuture;
    private Runnable memoryInfoRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                MemoryManager.this.recordSample();
            }
            catch (InterruptedException exception) {
                EmbraceLogger.logError("Error while adding memory sample", exception);
                Thread.currentThread().interrupt();
            }
        }
    };
    private final FixedSizeDeque<ITimestamp> samples = new FixedSizeDeque(600);
    private final List<ITimestamp> memoryWarnings = new ArrayList<ITimestamp>();
    private boolean status = false;

    static MemoryManager getManager() {
        return manager;
    }

    private MemoryManager() {
    }

    private void startObservingMemoryInfo() {
        this.memoryInfoFuture = this.executorService.scheduleAtFixedRate(this.memoryInfoRunnable, 0L, 2L, TimeUnit.SECONDS);
    }

    List<MemorySample> getMemorySamplesWithinInterval(long startTime, long endTime) {
        return TimestampUtils.getWithinInterval(new ArrayList<ITimestamp>(this.samples), startTime, endTime);
    }

    List<MemorySample> getMemorySamplesDuringSession(Session session) {
        return this.getMemorySamplesWithinInterval(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    List<SystemEvent> getMemoryWarningsWithinInterval(long startTime, long endTime) {
        return TimestampUtils.getWithinInterval(this.memoryWarnings, startTime, endTime);
    }

    List<SystemEvent> getMemoryWarningsDuringSession(Session session) {
        return this.getMemoryWarningsWithinInterval(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    private void recordSample() throws InterruptedException {
        this.samples.forcePutLast(new MemorySample(this.getAppHeapMemoryUsed() / 0x100000L, this.getSystemMemoryAvailable() / 0x100000L));
    }

    private long getAppHeapMemoryUsed() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private long getSystemMemoryAvailable() {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ((ActivityManager)Embrace.getContext().getSystemService("activity")).getMemoryInfo(memoryInfo);
        return memoryInfo.availMem;
    }

    void handleMemoryWarning() {
        SystemEvent event = new SystemEvent();
        this.memoryWarnings.add(event);
    }

    private Status didManagerStatusChanged(boolean newStatus) {
        if (this.status == newStatus) {
            return Status.NO_CHANGE;
        }
        if (!newStatus && this.status) {
            return Status.MEMORY_MANAGER_DISABLED;
        }
        return Status.MEMORY_MANAGER_ENABLED;
    }

    void onManagerStatusChanged(boolean newStatus) {
        switch (this.didManagerStatusChanged(newStatus)) {
            case MEMORY_MANAGER_DISABLED: {
                this.memoryInfoFuture.cancel(true);
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                        EmbraceLogger.logWarning("Executor service was not safely terminated.");
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    EmbraceLogger.logWarning("Error while shutting down executor", e);
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                this.samples.clear();
                this.memoryWarnings.clear();
                break;
            }
            case MEMORY_MANAGER_ENABLED: {
                if (this.executorService.isShutdown()) {
                    this.executorService = Executors.newSingleThreadScheduledExecutor();
                }
                this.startObservingMemoryInfo();
                break;
            }
        }
        this.status = newStatus;
    }

    private static enum Status {
        NO_CHANGE,
        MEMORY_MANAGER_ENABLED,
        MEMORY_MANAGER_DISABLED;

    }
}

