/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSdkException;

class EmbraceExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler originalHandler;

    static void enable() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new EmbraceExceptionHandler(currentHandler));
    }

    EmbraceExceptionHandler(Thread.UncaughtExceptionHandler originalHandler) {
        this.originalHandler = originalHandler;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (EmbraceManager.getInstance().shouldRecordEvents()) {
            try {
                EmbraceManager.getInstance().processAndSendCrash(e);
            }
            catch (EmbraceSdkException e1) {
                EmbraceLogger.logError("Error sending crash event", e1);
            }
        }
        if (this.originalHandler != null) {
            this.originalHandler.uncaughtException(t, e);
        } else {
            EmbraceLogger.logError(String.format("Exception in thread \"%s\" ", t.getName()));
        }
    }
}

