/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import android.util.Pair;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.ITimestamp;
import io.embrace.android.embracesdk.StringUtils;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class Breadcrumb
implements ITimestamp {
    private final String message;
    private final String screen;
    private final Long timestamp;
    private final String element;
    private final String location;
    private final BreadcrumbType type;

    Breadcrumb(String message) {
        this(message, null, null, null, System.currentTimeMillis(), BreadcrumbType.VIEW);
    }

    Breadcrumb(String screen, long timestamp) {
        this(null, screen, null, null, timestamp, BreadcrumbType.VIEW);
    }

    Breadcrumb(Pair<Float, Float> point, String element, long timestamp, BreadcrumbType type) {
        this(null, null, point, element, timestamp, type);
    }

    private Breadcrumb(String message, String screen, Pair<Float, Float> point, String element, long timestamp, BreadcrumbType type) {
        this.type = type;
        this.message = StringUtils.ellipsize(message, 64);
        this.screen = screen;
        this.element = element;
        this.timestamp = timestamp;
        this.location = this.getStringForPoint(point);
    }

    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.timestamp != null) {
                jsonObject.put("ts", (Object)this.timestamp);
            }
            if (this.screen != null) {
                jsonObject.put("vn", (Object)this.screen);
            }
            if (this.message != null) {
                jsonObject.put("m", (Object)this.message);
            }
            if (this.element != null) {
                jsonObject.put("tt", (Object)this.element);
            }
            if (this.location != null && this.type != BreadcrumbType.VIEW) {
                jsonObject.put("tl", (Object)this.location);
                if (this.getStringForTapType(this.type) != null) {
                    jsonObject.put("t", (Object)this.getStringForTapType(this.type));
                }
            }
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    String getScreen() {
        return this.screen;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    private String getStringForPoint(Pair<Float, Float> point) {
        return String.format(Locale.US, "%d,%d", point != null ? ((Float)point.first).intValue() : 0, point != null ? ((Float)point.second).intValue() : 0);
    }

    private String getStringForTapType(BreadcrumbType type) {
        switch (type) {
            case TAP: {
                return "s";
            }
            case DOUBLE_TAP: {
                return "d";
            }
            case LONG_PRESS: {
                return "l";
            }
        }
        return null;
    }

    static boolean validateBreadcrumbMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            EmbraceLogger.logWarning("Breadcrumb message must not be blank");
            return false;
        }
        if (message.length() > 64) {
            EmbraceLogger.logWarning(String.format("Breadcrumb message maximum allowed length is %d; it will be truncated to %s", 64, StringUtils.ellipsize(message, 64)));
        }
        return true;
    }

    public static enum BreadcrumbType {
        VIEW,
        TAP,
        DOUBLE_TAP,
        LONG_PRESS;

    }
}

