/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.cache.file;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.FileUtils;
import io.embrace.android.embracesdk.cache.file.FileCacheReader;
import io.embrace.android.embracesdk.helpers.FileCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public abstract class CollectionFileCacheReader<S extends Serializable, T>
extends FileCacheReader<Collection<T>> {
    protected abstract T parseElement(S var1) throws Exception;

    @Override
    public Collection<T> parse(FileCache fileCache) {
        ArrayList<T> collection = new ArrayList<T>();
        try {
            for (Serializable element : FileUtils.readCollectionFromFile(fileCache)) {
                try {
                    T parsedElement = this.parseElement(element);
                    if (parsedElement == null) continue;
                    collection.add(parsedElement);
                }
                catch (Exception e) {
                    EmbraceLogger.logError(String.format("Failed to parse a registry from cache: %s", fileCache.name()), e);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return collection;
    }
}

