/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Handler;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSharedPreferences;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

class EmbraceApiRequest {
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String USER_AGENT_FORMAT = "Embrace/a/%s";
    private static final String APP_ID_HEADER = "X-EM-AID";
    private static final String DEVICE_ID_HEADER = "X-EM-DID";
    private static final String STORY_ID_HEADER = "X-EM-SID";
    private static final String LOG_ID_HEADER = "X-EM-LID";
    private Handler callbackHandler;
    private final URL url;
    private final byte[] payload;
    private final Map<String, String> headers;
    private final String userAgent;

    URL getUrl() {
        return this.url;
    }

    byte[] getPayload() {
        return this.payload;
    }

    Map<String, String> getHeaders() {
        return this.headers;
    }

    EmbraceApiRequest(URL url) {
        this(url, null, null);
    }

    EmbraceApiRequest(URL url, Map<String, String> headers) {
        this(url, headers, null);
    }

    EmbraceApiRequest(URL url, Map<String, String> headers, byte[] payload) {
        this.url = url;
        this.headers = headers;
        this.payload = payload;
        this.userAgent = String.format(USER_AGENT_FORMAT, EmbraceManager.getInstance().getEmbraceVersionString());
    }

    synchronized Handler getCallbackHandler() {
        return this.callbackHandler;
    }

    synchronized void setCallbackHandler(Handler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    HttpURLConnection createConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("User-Agent", this.userAgent);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Content-Encoding", CONTENT_ENCODING_GZIP);
        connection.setRequestProperty("Accept-Encoding", CONTENT_ENCODING_GZIP);
        connection.setRequestProperty(APP_ID_HEADER, EmbraceManager.getInstance().getBuildInfo().getAppId());
        connection.setRequestProperty(DEVICE_ID_HEADER, EmbraceSharedPreferences.getInstance().getDeviceId());
        if (this.headers != null) {
            if (this.headers.containsKey("internal_content_type")) {
                connection.setRequestProperty("Content-Type", this.headers.get("internal_content_type"));
            }
            if (this.headers.containsKey("story_id_header")) {
                connection.setRequestProperty(STORY_ID_HEADER, this.headers.get("story_id_header"));
            }
            if (this.headers.containsKey("log_id_header")) {
                connection.setRequestProperty(LOG_ID_HEADER, this.headers.get("log_id_header"));
            }
        }
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        return connection;
    }

    HttpURLConnection createRemoteConfigConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("User-Agent", this.userAgent);
        connection.setRequestMethod("GET");
        return connection;
    }
}

