/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Pair;
import io.embrace.android.embracesdk.Breadcrumb;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.FixedSizeDeque;
import io.embrace.android.embracesdk.ITimestamp;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.TimestampUtils;
import java.util.ArrayList;
import java.util.List;

public class BreadcrumbManager {
    private static final Integer BREADCRUMB_VIEW_LOG_MAX = 50;
    private static final Integer BREADCRUMB_TAP_LOG_MAX = 100;
    private static final Integer BREADCRUMB_CUSTOM_LOG_MAX = 100;
    private static final BreadcrumbManager manager = new BreadcrumbManager();
    private final FixedSizeDeque<Breadcrumb> viewLogsDeque = new FixedSizeDeque(BREADCRUMB_VIEW_LOG_MAX);
    private final FixedSizeDeque<Breadcrumb> tapLogsDeque = new FixedSizeDeque(BREADCRUMB_TAP_LOG_MAX);
    private final FixedSizeDeque<Breadcrumb> customLogsDeque = new FixedSizeDeque(BREADCRUMB_CUSTOM_LOG_MAX);

    private BreadcrumbManager() {
    }

    static BreadcrumbManager getManager() {
        return manager;
    }

    public String getLastBreadcrumbScreenName() {
        return this.viewLogsDeque.peekLast() != null ? ((Breadcrumb)this.viewLogsDeque.peekLast()).getScreen() : null;
    }

    public void forceLogView(String screen, long timestamp) {
        screen = screen != null ? screen : "unknown";
        this.addToViewLogsQueue(screen, timestamp);
    }

    public void logView(String screen, long timestamp) {
        Breadcrumb breadcrumb = (Breadcrumb)this.viewLogsDeque.peekLast();
        String string = screen = screen != null ? screen : "unknown";
        if (breadcrumb == null || !breadcrumb.getScreen().equals(screen)) {
            this.addToViewLogsQueue(screen, timestamp);
        }
    }

    private void addToViewLogsQueue(String screen, long timestamp) {
        try {
            this.viewLogsDeque.forcePutLast(new Breadcrumb(screen, timestamp));
        }
        catch (InterruptedException e) {
            EmbraceLogger.logError("Thread was interrupted while attempting to register view breadcrumb.", e);
            Thread.currentThread().interrupt();
        }
    }

    public void log(Pair<Float, Float> point, String element, long timestamp, Breadcrumb.BreadcrumbType type) {
        try {
            this.tapLogsDeque.forcePutLast(new Breadcrumb(point, element, timestamp, type));
        }
        catch (InterruptedException e) {
            EmbraceLogger.logError("Thread was interrupted while attempting to register tap breadcrumb.", e);
            Thread.currentThread().interrupt();
        }
    }

    void logCustomBreadcrumb(String message) throws InterruptedException {
        this.customLogsDeque.forcePutLast(new Breadcrumb(message));
    }

    List<Breadcrumb> getViewBreadcrumbsForSession(Session session, int limit) {
        return this.getBreadcrumbsBetween(this.viewLogsDeque, session.getStartTime().getTime(), session.getLastKnownTime(), limit);
    }

    List<Breadcrumb> getTapBreadcrumbsForSession(Session session, int limit) {
        return this.getBreadcrumbsBetween(this.tapLogsDeque, session.getStartTime().getTime(), session.getLastKnownTime(), limit);
    }

    List<Breadcrumb> getCustomBreadcrumbsForSession(Session session, int limit) {
        return this.getBreadcrumbsBetween(this.customLogsDeque, session.getStartTime().getTime(), session.getLastKnownTime(), limit);
    }

    private List<? extends ITimestamp> getBreadcrumbsBetween(FixedSizeDeque<Breadcrumb> breadcrumbs, long startTime, long endTime, int limit) {
        List<? extends ITimestamp> filteredElements = TimestampUtils.getWithinInterval(new ArrayList<Breadcrumb>(breadcrumbs), startTime, endTime);
        if (limit != 0) {
            return filteredElements.subList(Math.max(filteredElements.size() - limit, 0), filteredElements.size());
        }
        return filteredElements;
    }
}

