/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.health;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import io.embrace.android.embracesdk.AnrInterval;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.util.ArrayList;
import java.util.List;

class HealthCheckHandlerThread
extends HandlerThread {
    public static final String NAME = "HealthCheckHandlerThread";
    private final Looper monitoredLooper;
    private volatile HealthCheckHandler healthCheckHandler;

    public HealthCheckHandlerThread(String name, Looper monitoredLooper) {
        super(name);
        this.monitoredLooper = monitoredLooper;
    }

    public synchronized List<AnrInterval> getAnrIntervals() {
        return this.healthCheckHandler != null ? this.healthCheckHandler.getAnrIntervals() : new ArrayList();
    }

    public synchronized void clearAnrIntervals() {
        if (this.healthCheckHandler != null) {
            this.healthCheckHandler.clearAnrIntervals();
        }
    }

    public synchronized void start() {
        super.start();
        this.healthCheckHandler = new HealthCheckHandler(this.monitoredLooper);
        this.healthCheckHandler.sendMessage(this.healthCheckHandler.obtainMessage(1));
    }

    class HealthCheckHandler
    extends Handler {
        private final LooperHealthHandler monitoredLooperHeartbeatHandler;
        private final List<AnrInterval> anrIntervals;
        private volatile Long heartbeatSentTimestamp;
        private volatile Long heartbeatReceivedTimestamp;

        HealthCheckHandler(Looper monitoredLooper) {
            super(HealthCheckHandlerThread.this.getLooper());
            this.anrIntervals = new ArrayList<AnrInterval>();
            this.heartbeatSentTimestamp = null;
            this.heartbeatReceivedTimestamp = null;
            this.monitoredLooperHeartbeatHandler = new LooperHealthHandler(monitoredLooper, this);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.runHealthCheck();
                    break;
                }
                case 2: {
                    this.heartbeatSentTimestamp = System.currentTimeMillis();
                    this.heartbeatReceivedTimestamp = null;
                    this.monitoredLooperHeartbeatHandler.sendMessage(this.obtainMessage(2));
                    break;
                }
                case 3: {
                    this.heartbeatReceivedTimestamp = System.currentTimeMillis();
                }
            }
        }

        synchronized void upsertAnr(AnrInterval.Type type, Long startTimeInMillis, Long lastKnownTimeInMillis, Long endTimeInMillis) {
            if (this.anrIntervals.isEmpty()) {
                this.anrIntervals.add(new AnrInterval(type, startTimeInMillis, lastKnownTimeInMillis, endTimeInMillis));
            } else {
                int lastIndex = this.anrIntervals.size() - 1;
                AnrInterval lastInterval = this.anrIntervals.get(lastIndex);
                if (lastInterval != null && lastInterval.getStartTime() == startTimeInMillis.longValue()) {
                    this.anrIntervals.set(lastIndex, new AnrInterval(type, lastInterval.getStartTime(), lastKnownTimeInMillis, endTimeInMillis));
                } else {
                    this.anrIntervals.add(new AnrInterval(type, startTimeInMillis, lastKnownTimeInMillis, endTimeInMillis));
                }
            }
        }

        void runHealthCheck() {
            if (this.isAnr()) {
                long anrEndTime = this.heartbeatReceivedTimestamp != null ? this.heartbeatReceivedTimestamp : 0L;
                long anrLastKnownTime = anrEndTime == 0L ? System.currentTimeMillis() : 0L;
                this.upsertAnr(AnrInterval.Type.UI, this.heartbeatSentTimestamp, anrLastKnownTime, anrEndTime);
            }
            if (this.isPendingHeartbeat()) {
                this.sendMessage(this.obtainMessage(2));
            }
            this.sendMessageDelayed(this.obtainMessage(1), 200L);
        }

        boolean isPendingHeartbeat() {
            return this.heartbeatReceivedTimestamp != null || this.heartbeatSentTimestamp == null;
        }

        boolean isAnr() {
            if (this.heartbeatSentTimestamp == null) {
                return false;
            }
            long heartbeatReceivedTime = this.heartbeatReceivedTimestamp != null ? this.heartbeatReceivedTimestamp : System.currentTimeMillis();
            return heartbeatReceivedTime - this.heartbeatSentTimestamp > 1000L;
        }

        synchronized List<AnrInterval> getAnrIntervals() {
            return this.anrIntervals;
        }

        synchronized void clearAnrIntervals() {
            this.anrIntervals.clear();
        }

        class LooperHealthHandler
        extends Handler {
            final HealthCheckHandler healthCheckHandler;

            LooperHealthHandler(Looper looper, HealthCheckHandler healthCheckHandler) {
                super(looper);
                if (healthCheckHandler == null) {
                    EmbraceLogger.logError("Health check handler is null.");
                }
                this.healthCheckHandler = healthCheckHandler;
            }

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 2: {
                        this.healthCheckHandler.sendMessage(this.obtainMessage(3));
                        break;
                    }
                }
            }
        }
    }
}

