/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.CustomFlow;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Properties;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.util.Map;

public final class RegistrationFlow
extends CustomFlow {
    public static final long FLAG_SET_USER_PAYER = 1L;
    static final String MOMENT_INTERNAL_REGISTRATION = "_internal-registration";
    static final String MOMENT_EXTERNAL_REGISTRATION = "_external-registration";
    static final String PROP_EMAIL = "email";
    static final String PROP_REGISTRATION_SOURCE = "registration-source";
    static final String PROP_USERNAME = "username";
    static final String PROP_USER_ID = "user-id";
    Map<String, Object> registrationProps;
    String registrationMomentName;
    String registrationMomentId;

    public synchronized boolean registrationStart(String userId, String username, String email, Map<String, Object> properties) {
        if (this.embraceMgr == null) {
            return false;
        }
        properties = Properties.normalizeProperties(properties);
        if (userId != null) {
            properties.put(PROP_USER_ID, userId);
        }
        if (username != null) {
            properties.put(PROP_USERNAME, username);
        }
        if (email != null) {
            properties.put(PROP_EMAIL, email);
        }
        return this.sendRegistrationStartMoment(MOMENT_INTERNAL_REGISTRATION, properties);
    }

    public synchronized boolean registrationStart(String source, Map<String, Object> properties) {
        if (this.embraceMgr == null) {
            return false;
        }
        properties = Properties.normalizeProperties(properties);
        if (source != null) {
            properties.put(PROP_REGISTRATION_SOURCE, source);
        }
        return this.sendRegistrationStartMoment(MOMENT_EXTERNAL_REGISTRATION, properties);
    }

    boolean sendRegistrationStartMoment(String momentName, Map<String, Object> properties) {
        this.registrationMomentName = momentName;
        this.registrationProps = properties;
        this.registrationMomentId = Uuid.getEmbUuid();
        this.sendMomentStartEvent(momentName, this.registrationMomentId, false, properties);
        return true;
    }

    public synchronized boolean registrationComplete() {
        return this.registrationComplete(null);
    }

    public synchronized boolean registrationComplete(Boolean isPayer) {
        if (this.embraceMgr == null) {
            return false;
        }
        if (this.registrationMomentId == null) {
            EmbraceLogger.logError("Registration wasn't started.");
            return false;
        }
        this.sendMomentEndEvent(this.registrationMomentName, this.registrationMomentId);
        this.sendLogInfo("Registration was completed.", this.registrationProps);
        Embrace embrace = Embrace.getInstance();
        if (isPayer != null) {
            if (isPayer.booleanValue()) {
                embrace.setUserAsPayer();
            } else {
                embrace.clearUserAsPayer();
            }
        }
        String email = (String)this.registrationProps.get(PROP_EMAIL);
        String username = (String)this.registrationProps.get(PROP_USERNAME);
        String userId = (String)this.registrationProps.get(PROP_USER_ID);
        if (!TextUtils.isEmpty((CharSequence)email)) {
            embrace.setUserEmail(email);
        }
        if (!TextUtils.isEmpty((CharSequence)username)) {
            embrace.setUsername(username);
        }
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            embrace.setUserIdentifier(userId);
        }
        this.registrationMomentId = null;
        return true;
    }

    public synchronized boolean registrationFail(String msg) {
        if (this.embraceMgr == null) {
            return false;
        }
        if (this.registrationMomentId == null) {
            EmbraceLogger.logError("Registration wasn't started.");
            return false;
        }
        if (msg != null) {
            this.registrationProps.put("message", msg);
        }
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? "A failure occurred during registration." : "A failure occurred during registration: " + msg;
        this.sendMomentEndEvent(this.registrationMomentName, this.registrationMomentId);
        this.sendLogError(errorLogMsg, true, this.registrationProps);
        this.registrationMomentId = null;
        return true;
    }
}

