/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.RequiresApi;
import io.embrace.android.embracesdk.BatteryBroadcastReceiver;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.FilterableUtils;
import io.embrace.android.embracesdk.FixedSizeDeque;
import io.embrace.android.embracesdk.IInterval;
import io.embrace.android.embracesdk.IntervalMeasurement;
import io.embrace.android.embracesdk.PowerSaverBroadcastReceiver;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SystemEvent;
import io.embrace.android.embracesdk.TimestampUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class PowerManager {
    private static final String BATTERY_LEVEL_KEY = "bt";
    private static final String BATTERY_CHARGING_KEY = "bc";
    private static final int BATTERY_MEASUREMENTS_LOG_MAX = 600;
    private static final Integer BATTERY_MEASUREMENT_INTERVAL_IN_SECONDS = 60;
    private static final long SHUTDOWN_TIMEOUT_MS = 2000L;
    private List<IInterval> chargingIntervals;
    private FixedSizeDeque<SystemEvent> batteryMeasurements;
    private List<IInterval> powerSaveModeIntervals;
    private IntervalMeasurement currentChargingInterval;
    private IntervalMeasurement currentPowerSaveModeInterval;
    private boolean isBatteryCharging;
    private boolean isSdkDisabled;
    private boolean isInPowerSaveMode;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private BatteryBroadcastReceiver batteryBroadcastReceiver;
    private PowerSaverBroadcastReceiver powerSaverBroadcastReceiver;
    private Future batteryInfoFuture;
    private Runnable batteryInfoRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                PowerManager.this.recordBatteryLevel();
            }
            catch (InterruptedException exception) {
                EmbraceLogger.logError("Error while adding battery measurement", exception);
                Thread.currentThread().interrupt();
            }
        }
    };
    private static final PowerManager manager = new PowerManager();

    static PowerManager getManager() {
        return manager;
    }

    private PowerManager() {
        this.chargingIntervals = new ArrayList<IInterval>();
        this.batteryMeasurements = new FixedSizeDeque(600);
        this.powerSaveModeIntervals = new ArrayList<IInterval>();
        this.updateBatteryChargingStatus(this.registerBatteryBroadcastReceiver());
        this.startObservingBatteryLevel();
    }

    private void startObservingBatteryLevel() {
        this.batteryInfoFuture = this.executorService.scheduleAtFixedRate(this.batteryInfoRunnable, 0L, BATTERY_MEASUREMENT_INTERVAL_IN_SECONDS.intValue(), TimeUnit.SECONDS);
    }

    boolean shouldRecordPowerSaveModeIntervals() {
        return false;
    }

    @RequiresApi(api=21)
    private boolean getIsInPowerSaveMode() {
        return ((android.os.PowerManager)Embrace.getContext().getSystemService("power")).isPowerSaveMode();
    }

    private Intent registerBatteryBroadcastReceiver() {
        this.batteryBroadcastReceiver = new BatteryBroadcastReceiver();
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        return Embrace.getContext().registerReceiver((BroadcastReceiver)this.batteryBroadcastReceiver, ifilter);
    }

    private Intent registerPowerSaveModeBroadcastReceiver() {
        this.powerSaverBroadcastReceiver = new PowerSaverBroadcastReceiver();
        IntentFilter ifilter = new IntentFilter("android.os.action.POWER_SAVE_MODE_CHANGED");
        return Embrace.getContext().registerReceiver((BroadcastReceiver)this.powerSaverBroadcastReceiver, ifilter);
    }

    private void unregisterBroadcastReceiver() {
        if (this.batteryBroadcastReceiver != null) {
            Embrace.getContext().unregisterReceiver((BroadcastReceiver)this.batteryBroadcastReceiver);
            this.batteryBroadcastReceiver = null;
        }
    }

    private void updateBatteryChargingStatus(Intent batteryIntent) {
        int status = batteryIntent.getIntExtra("status", -1);
        boolean bl = this.isBatteryCharging = status == 2 || status == 5;
        if (this.isBatteryCharging) {
            this.addChargingInterval();
        }
    }

    private void addChargingInterval() {
        IntervalMeasurement chargingInterval = new IntervalMeasurement();
        this.chargingIntervals.add(chargingInterval);
        this.currentChargingInterval = chargingInterval;
    }

    float getBatteryLevel() {
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = Embrace.getContext().registerReceiver(null, ifilter);
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        return (float)level / (float)scale;
    }

    List<IntervalMeasurement> getChargingIntervalsBetween(long startTime, long endTime) {
        return FilterableUtils.filter(this.chargingIntervals, startTime, endTime);
    }

    List<IntervalMeasurement> getChargingIntervalsDuringSession(Session session) {
        return this.getChargingIntervalsBetween(session.getStartTime().getTime(), session.getLastKnownTime());
    }

    private List<SystemEvent> getBatteryMeasurementsBetween(long startTime, long endTime) {
        return TimestampUtils.getWithinInterval(new ArrayList<SystemEvent>(this.batteryMeasurements), startTime, endTime);
    }

    List<SystemEvent> getBatteryMeasurementsDuringSession(Session session) {
        return this.getBatteryMeasurementsBetween(session.getStartTime().getTime(), session.getLastKnownTime());
    }

    List<IntervalMeasurement> getPowerSaveModeIntervalsBetween(long startTime, long endTime) {
        return FilterableUtils.filter(this.powerSaveModeIntervals, startTime, endTime);
    }

    List<IntervalMeasurement> getPowerSaveModeIntervalsDuringSession(Session session) {
        return this.getPowerSaveModeIntervalsBetween(session.getStartTime().getTime(), session.getLastKnownTime());
    }

    private synchronized void recordBatteryLevel() throws InterruptedException {
        SystemEvent batteryLog = new SystemEvent(Float.valueOf(this.getBatteryLevel()));
        this.batteryMeasurements.forcePutLast(batteryLog);
    }

    private boolean isBatteryCharging(int batteryStatus) {
        return batteryStatus == 2 || batteryStatus == 5;
    }

    private BatteryChargingStatusUpdate didBatteryChargingStatusChange(int batteryStatus) {
        if (this.isBatteryCharging(batteryStatus)) {
            return !this.isBatteryCharging ? BatteryChargingStatusUpdate.BATTERY_STARTED_CHARGING : BatteryChargingStatusUpdate.NO_CHANGE;
        }
        return this.isBatteryCharging ? BatteryChargingStatusUpdate.BATTERY_STOPPED_CHARGING : BatteryChargingStatusUpdate.NO_CHANGE;
    }

    private PowerSaveModeUpdate didPowerModeStatusChange(boolean newIsInPowerSaveMode) {
        if (this.isInPowerSaveMode && !newIsInPowerSaveMode) {
            return PowerSaveModeUpdate.POWER_SAVE_MODE_DISABLED;
        }
        if (!this.isInPowerSaveMode && newIsInPowerSaveMode) {
            return PowerSaveModeUpdate.POWER_SAVE_MODE_ENABLED;
        }
        return PowerSaveModeUpdate.NO_CHANGE;
    }

    private void onBatteryStateChanged(int batteryStatus) {
        switch (this.didBatteryChargingStatusChange(batteryStatus)) {
            case BATTERY_STARTED_CHARGING: {
                IntervalMeasurement chargingInterval = new IntervalMeasurement();
                this.chargingIntervals.add(chargingInterval);
                this.currentChargingInterval = chargingInterval;
                break;
            }
            case BATTERY_STOPPED_CHARGING: {
                if (this.currentChargingInterval == null) break;
                this.currentChargingInterval.endInterval();
                this.currentChargingInterval = null;
                EmbraceLogger.logDebug("Ending previous charging interval");
                break;
            }
        }
        this.isBatteryCharging = this.isBatteryCharging(batteryStatus);
    }

    void handleBatteryStateChange(final Intent batteryStatus) {
        if (!this.executorService.isShutdown()) {
            this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    PowerManager.this.onBatteryStateChanged(batteryStatus.getIntExtra("status", -1));
                }
            }, 0L, TimeUnit.SECONDS);
        }
    }

    private void onPowerSaveModeChanged(boolean powerSaveModeStatus) {
        switch (this.didPowerModeStatusChange(powerSaveModeStatus)) {
            case POWER_SAVE_MODE_ENABLED: {
                IntervalMeasurement powerSaveModeInterval = new IntervalMeasurement();
                this.powerSaveModeIntervals.add(powerSaveModeInterval);
                this.currentPowerSaveModeInterval = powerSaveModeInterval;
                break;
            }
            case POWER_SAVE_MODE_DISABLED: {
                if (this.currentPowerSaveModeInterval == null) break;
                this.currentPowerSaveModeInterval.endInterval();
                this.currentPowerSaveModeInterval = null;
                EmbraceLogger.logDebug("Ending previous power save mode interval");
                break;
            }
        }
        this.isInPowerSaveMode = powerSaveModeStatus;
    }

    @RequiresApi(api=21)
    void handlePowerSaveStateChange() {
        if (!this.executorService.isShutdown()) {
            this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    PowerManager.this.onPowerSaveModeChanged(PowerManager.this.getIsInPowerSaveMode());
                }
            }, 0L, TimeUnit.SECONDS);
        }
    }

    private SdkStatusUpdate didSdkStatusChanged(boolean sdkStatus) {
        if (this.isSdkDisabled == sdkStatus) {
            return SdkStatusUpdate.NO_CHANGE;
        }
        if (sdkStatus && !this.isSdkDisabled) {
            return SdkStatusUpdate.SDK_ENABLED;
        }
        return SdkStatusUpdate.SDK_DISABLED;
    }

    void onSdkStatusChanged(boolean sdkStatus) {
        switch (this.didSdkStatusChanged(sdkStatus)) {
            case SDK_DISABLED: {
                this.batteryInfoFuture.cancel(true);
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                        EmbraceLogger.logWarning("Executor service was not safely terminated.");
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    EmbraceLogger.logWarning("Error while shutting down executor", e);
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                this.batteryMeasurements.clear();
                this.chargingIntervals.clear();
                this.powerSaveModeIntervals.clear();
                this.unregisterBroadcastReceiver();
                break;
            }
            case SDK_ENABLED: {
                if (this.executorService.isShutdown()) {
                    this.executorService = Executors.newSingleThreadScheduledExecutor();
                }
                this.updateBatteryChargingStatus(this.registerBatteryBroadcastReceiver());
                this.startObservingBatteryLevel();
                break;
            }
        }
        this.isSdkDisabled = sdkStatus;
    }

    JSONObject toJson() {
        JSONObject payload = new JSONObject();
        try {
            payload.put(BATTERY_LEVEL_KEY, (double)this.getBatteryLevel());
            payload.put(BATTERY_CHARGING_KEY, this.isBatteryCharging);
        }
        catch (JSONException e) {
            EmbraceLogger.logError("error creating battery event object", e);
            payload = null;
        }
        return payload;
    }

    private static enum SdkStatusUpdate {
        NO_CHANGE,
        SDK_ENABLED,
        SDK_DISABLED;

    }

    private static enum PowerSaveModeUpdate {
        NO_CHANGE,
        POWER_SAVE_MODE_ENABLED,
        POWER_SAVE_MODE_DISABLED;

    }

    private static enum BatteryChargingStatusUpdate {
        NO_CHANGE,
        BATTERY_STARTED_CHARGING,
        BATTERY_STOPPED_CHARGING;

    }
}

