/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.IInterval;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class IntervalMeasurement
implements IInterval {
    private String value;
    private long startTime = Calendar.getInstance().getTimeInMillis();
    private long endTime = 0L;
    private Map<String, Object> additionalPayloads = new HashMap<String, Object>();

    IntervalMeasurement() {
    }

    IntervalMeasurement(String value) {
        this();
        this.value = value;
    }

    void addPayload(JSONObject payload, String bodyKey) {
        if (payload == null || bodyKey == null) {
            EmbraceLogger.logWarning("can't add additional event payload with a null key or body");
            return;
        }
        this.additionalPayloads.put(bodyKey, payload);
    }

    void endInterval() {
        if (this.endTime == 0L) {
            this.endTime = Calendar.getInstance().getTimeInMillis();
        }
    }

    long getDuration() {
        if (this.endTime == 0L || this.startTime == 0L) {
            return -1L;
        }
        return this.endTime - this.startTime;
    }

    private JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.startTime != 0L) {
                jsonObject.put("st", this.startTime);
            }
            if (this.endTime != 0L) {
                jsonObject.put("en", this.endTime);
            }
            if (this.value != null) {
                jsonObject.put("v", (Object)this.value);
            }
        }
        catch (JSONException e) {
            EmbraceLogger.logWarning("Failed to serialize object to JSON", e);
            return null;
        }
        return jsonObject;
    }

    JSONObject getServerPayload() {
        JSONObject payload = this.toJson();
        try {
            for (String key : this.additionalPayloads.keySet()) {
                payload.put(key, this.additionalPayloads.get(key));
            }
        }
        catch (JSONException e) {
            EmbraceLogger.logWarning("Failed to serialize object to JSON", e);
            return null;
        }
        return payload;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }
}

