/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.EmbraceSharedPreferences;
import io.embrace.android.embracesdk.MemoryManager;
import io.embrace.android.embracesdk.SessionManager;
import java.lang.ref.WeakReference;

public class ApplicationStateManager
implements ComponentCallbacks2,
Application.ActivityLifecycleCallbacks {
    public static final long APP_STATE_BACKGROUND_DELAY_MS = 500L;
    public static final int MAX_STARTUP_DELAY_IN_MILLIS = 2000;
    private volatile WeakReference<Activity> activity = new WeakReference<Object>(null);
    private boolean isColdStart = true;
    private long startTime;
    private static final ApplicationStateManager manager = new ApplicationStateManager();
    private volatile long stateUpdatedTime = 0L;

    static ApplicationStateManager getManager() {
        return manager;
    }

    private ApplicationStateManager() {
    }

    public void onTrimMemory(int trimLevel) {
        if (trimLevel == 10) {
            MemoryManager.getManager().handleMemoryWarning();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(Activity activity) {
        if (this.isInBackground()) {
            try {
                SessionManager.manager.applicationEnteredForeground();
                if (this.isColdStart) {
                    SessionManager.manager.recordColdStart();
                    if (System.currentTimeMillis() - this.startTime <= 2000L) {
                        EmbraceManager.getInstance().startEvent("_startup", null, true, null, this.startTime);
                    }
                }
                this.isColdStart = false;
                if (EmbraceManager.getInstance().shouldFetchConfig(EmbraceSharedPreferences.getInstance())) {
                    EmbraceManager.getInstance().fetchConfig();
                }
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logError("Error while entering foreground", e);
            }
        }
        ApplicationStateManager applicationStateManager = this;
        synchronized (applicationStateManager) {
            this.activity = new WeakReference<Activity>(activity);
            this.stateUpdatedTime = SystemClock.uptimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable(Activity activity) {
        if (activity == this.activity.get()) {
            ApplicationStateManager applicationStateManager = this;
            synchronized (applicationStateManager) {
                this.activity = new WeakReference<Object>(null);
                this.stateUpdatedTime = SystemClock.uptimeMillis();
            }
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ApplicationStateManager.this.isInBackground()) {
                        SessionManager.manager.applicationEnteredBackground();
                    }
                }
            }, 500L);
        }
    }

    public synchronized boolean isInBackground() {
        return this.activity.get() == null && SystemClock.uptimeMillis() - this.stateUpdatedTime >= 500L;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        EmbraceManager.getInstance().setForegroundActivity(activity);
    }

    public void onActivityPaused(Activity activity) {
        EmbraceManager.getInstance().setForegroundActivity(null);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

