/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.health;

import android.os.Looper;
import android.util.Log;
import io.embrace.android.embracesdk.AnrInterval;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.FilterableUtils;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.health.HealthCheckHandlerThread;
import java.util.List;

public class HealthMonitor {
    static final int RUN_HEALTH_CHECK = 1;
    static final int SEND_HEARTBEAT = 2;
    static final int RESPOND_HEARTBEAT = 3;
    static final int EMBRACE_ANR_CHECK_INTERVAL_IN_MILLISECONDS = 200;
    static final int EMBRACE_ANR_THRESHOLD_IN_MILLISECONDS = 1000;
    private static final String TAG = "HealthMonitor";
    final Looper looper;
    final HealthCheckHandlerThread healthCheckHandlerThread;
    boolean isRunning = false;

    public HealthMonitor(Looper looper) {
        if (looper == null) {
            EmbraceLogger.logError("looper is null");
        }
        this.looper = looper;
        this.healthCheckHandlerThread = new HealthCheckHandlerThread("HealthCheckHandlerThread", looper);
    }

    public synchronized void start() {
        if (!this.isRunning) {
            this.healthCheckHandlerThread.start();
            this.isRunning = true;
            Log.i((String)TAG, (String)"Started health monitor");
        } else {
            EmbraceLogger.logError("Failed starting HealthMonitor already running");
        }
    }

    public synchronized void stop() {
        if (this.isRunning) {
            try {
                this.healthCheckHandlerThread.quit();
                this.healthCheckHandlerThread.join(0L);
            }
            catch (InterruptedException e) {
                EmbraceLogger.logError("Failed stopping HealthMonitor", e);
                Thread.currentThread().interrupt();
            }
            this.isRunning = false;
            Log.i((String)TAG, (String)"Stopped health monitor");
        } else {
            EmbraceLogger.logError("Failed stopping HealthMonitor, it isn't running");
        }
    }

    public List<AnrInterval> getAnrIntervalsBetween(long startTime, long endTime) {
        if (!this.isRunning) {
            throw new IllegalStateException("HealthMonitor has not been initialized");
        }
        return FilterableUtils.filter(this.healthCheckHandlerThread.getAnrIntervals(), startTime, endTime);
    }

    public List<AnrInterval> getAnrIntervalsForSession(Session session) {
        return this.getAnrIntervalsBetween(session.getStartTime().getTime(), session.getLastKnownTime());
    }

    public synchronized void clearAnrIntervals() {
        if (!this.isRunning) {
            throw new IllegalStateException("HealthMonitor has not been initialized");
        }
        this.healthCheckHandlerThread.clearAnrIntervals();
    }
}

