/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import io.embrace.android.embracesdk.EmbraceApiRequest;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

class EmbraceAsyncTask
extends AsyncTask<Void, Void, Integer> {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "EmbraceAsyncTask #" + this.mCount.getAndIncrement());
        }
    };
    private static final BlockingQueue<Runnable> POOL_WORK_QUEUE = new LinkedBlockingQueue<Runnable>(128);
    private static final RejectedExecutionHandler REJECTED_EXECUTION_HANDLER = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            EmbraceLogger.logError("EmbraceAsyncTask " + task.toString() + " rejected from " + executor.toString());
        }
    };
    public static final Executor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, POOL_WORK_QUEUE, THREAD_FACTORY, REJECTED_EXECUTION_HANDLER);
    private final EmbraceApiRequest request;
    private final HttpURLConnection connection;
    private final EmbraceApiCallback callback;

    public EmbraceAsyncTask(HttpURLConnection connection, EmbraceApiRequest request, EmbraceApiCallback callback) {
        this.connection = connection;
        this.request = request;
        this.callback = callback;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (this.request.getCallbackHandler() == null) {
            this.request.setCallbackHandler(new Handler(Looper.getMainLooper()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer doInBackground(Void ... voids) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream os = null;
        BufferedReader in = null;
        try {
            String inputLine;
            if (this.request.getPayload() != null) {
                boolean isImage;
                boolean bl = isImage = this.request.getHeaders() != null && this.request.getHeaders().containsKey("internal_content_type") && this.request.getHeaders().get("internal_content_type").equals("application/octet-stream");
                if (!isImage) {
                    os = new GZIPOutputStream(baos);
                    os.write(this.request.getPayload());
                    ((GZIPOutputStream)os).finish();
                    this.connection.getOutputStream().write(baos.toByteArray());
                } else {
                    this.connection.getOutputStream().write(this.request.getPayload());
                }
            }
            this.connection.connect();
            in = this.connection.getResponseCode() == 200 ? new BufferedReader(new InputStreamReader(this.connection.getInputStream())) : new BufferedReader(new InputStreamReader(this.connection.getErrorStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            if (this.connection.getResponseCode() == 200) {
                this.callback.onSuccess(response.toString());
            } else {
                this.callback.onError(response.toString(), this.connection.getResponseCode());
            }
        }
        catch (Exception e) {
            this.callback.onException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        EmbraceLogger.logWarning("Error while closing output stream", e);
                    }
                }
            }
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        return null;
    }
}

