/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.Device;
import io.embrace.android.embracesdk.EmbraceException;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.ITimestamp;
import io.embrace.android.embracesdk.User;
import io.embrace.android.embracesdk.constants.EmbraceApiConstants;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DebugMessage
implements ITimestamp,
Serializable {
    private long timestamp;
    private String message;
    private Type type;
    private Stack<EmbraceException> exceptionStack;
    private Map<String, Object> additionalInfo;
    private Map<String, JSONObject> additionalPayloads = new HashMap<String, JSONObject>();

    DebugMessage(String jsonStr) {
        String key;
        Iterator iter;
        JSONObject json;
        try {
            json = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            EmbraceLogger.logWarning("Failed to initialize DebugMessage from JSON string.");
            json = new JSONObject();
        }
        JSONObject infoJsonObject = json.optJSONObject("db");
        this.timestamp = infoJsonObject.optLong("ts", System.currentTimeMillis());
        this.message = infoJsonObject.optString("m");
        this.type = this.getDebugMessageTypeForString(infoJsonObject.optString("sv"));
        this.exceptionStack = new Stack();
        JSONArray array = infoJsonObject.optJSONArray("ex");
        for (int i = 0; i < array.length(); ++i) {
            this.exceptionStack.add(new EmbraceException(array.optString(i)));
        }
        this.additionalInfo = new HashMap<String, Object>();
        JSONObject additionalInfoJson = infoJsonObject.optJSONObject("v");
        if (additionalInfoJson != null) {
            iter = additionalInfoJson.keys();
            while (iter.hasNext()) {
                key = (String)iter.next();
                this.additionalInfo.put(key, additionalInfoJson.opt(key));
            }
        }
        this.additionalPayloads = new HashMap<String, JSONObject>();
        iter = json.keys();
        while (iter.hasNext()) {
            key = (String)iter.next();
            JSONObject additionalPayload = json.optJSONObject(key);
            if (additionalPayload == null || key.equals("db")) continue;
            this.additionalPayloads.put(key, additionalPayload);
        }
    }

    DebugMessage(Type type, String message, Stack<EmbraceException> exceptionStack, Map<String, Object> additionalInfo) {
        this.timestamp = System.currentTimeMillis();
        this.message = message;
        this.type = type;
        this.exceptionStack = exceptionStack;
        this.additionalInfo = additionalInfo;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    synchronized void addPayload(JSONObject payload, String bodyKey) {
        if (payload == null || bodyKey == null) {
            EmbraceLogger.logWarning("can't add additional debug payload with a null key or body");
            return;
        }
        this.additionalPayloads.put(bodyKey, payload);
    }

    JSONObject getServerPayload() {
        JSONObject serverPayload = new JSONObject();
        this.addPayload(User.getInstance().toJsonObject(), "u");
        this.addPayload(Device.getInstance().getDeviceInfoJsonObject(), "d");
        this.addPayload(Device.getInstance().getAppInfoJsonObject(), "a");
        try {
            JSONObject messagePayload = new JSONObject();
            messagePayload.put("m", (Object)this.message);
            messagePayload.put("ts", this.timestamp);
            messagePayload.put("sv", (Object)this.getStringForDebugMessageType(this.type));
            JSONArray array = new JSONArray();
            if (this.exceptionStack != null) {
                Iterator embExceptionIterator = this.exceptionStack.iterator();
                while (embExceptionIterator.hasNext()) {
                    array.put((Object)((EmbraceException)embExceptionIterator.next()).toJson());
                }
            }
            messagePayload.put("ex", (Object)array);
            if (this.additionalInfo != null) {
                messagePayload.put("v", (Object)new JSONObject(this.additionalInfo));
            }
            serverPayload.put("db", (Object)messagePayload);
            serverPayload.put("v", (Object)EmbraceApiConstants.MESSAGE_FORMAT_VERSION);
            for (String key : this.additionalPayloads.keySet()) {
                serverPayload.put(key, (Object)this.additionalPayloads.get(key));
            }
        }
        catch (JSONException e) {
            serverPayload = null;
        }
        return serverPayload;
    }

    private String getStringForDebugMessageType(Type messageType) {
        switch (messageType) {
            case DEBUG: {
                return "debug";
            }
            case WARNING: {
                return "warning";
            }
            case INFO: {
                return "info";
            }
            case ERROR: {
                return "error";
            }
        }
        return null;
    }

    private Type getDebugMessageTypeForString(String messageType) {
        switch (messageType) {
            case "debug": {
                return Type.DEBUG;
            }
            case "warning": {
                return Type.WARNING;
            }
            case "info": {
                return Type.INFO;
            }
            case "error": {
                return Type.ERROR;
            }
        }
        return null;
    }

    static enum Type {
        DEBUG,
        ERROR,
        WARNING,
        INFO;

    }
}

