/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import io.embrace.android.embracesdk.Embrace;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;

public final class BuildInfo {
    static final String UNKNOWN_VALUE = "UNKNOWN";
    static final String FILE_BUILD_INFO = "build-info.json";
    static final String BUILD_INFO_APP_ID = "app-id";
    static final String BUILD_INFO_BUILD_ID = "build-id";
    final String appId;
    final String buildId;

    BuildInfo(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context is null.");
        }
        JSONObject buildInfo = this.getBuildInfoJson(context);
        this.appId = buildInfo.optString(BUILD_INFO_APP_ID, "");
        this.buildId = buildInfo.optString(BUILD_INFO_BUILD_ID, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSONObject loadBuildInfo(InputStream in) throws IOException, JSONException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            JSONObject jSONObject = new JSONObject(out.toString("UTF-8"));
            return jSONObject;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject getBuildInfoJson(Context context) {
        JSONObject buildInfo;
        InputStream in = null;
        try {
            Application application = (Application)context.getApplicationContext();
            in = new BufferedInputStream(application.getAssets().open(FILE_BUILD_INFO));
            buildInfo = BuildInfo.loadBuildInfo(in);
        }
        catch (IOException | JSONException e) {
            buildInfo = new JSONObject();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    in = null;
                }
            }
        }
        return buildInfo;
    }

    private PackageInfo getHostAppPackageInfo() {
        try {
            return Embrace.getContext().getPackageManager().getPackageInfo(Embrace.getContext().getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public boolean isDebug() {
        return (Embrace.getContext().getApplicationInfo().flags & 2) != 0;
    }

    public String getAppEnvironment() {
        return this.isDebug() ? "dev" : "prod";
    }

    public String getAppVersionCode() {
        PackageInfo packageInfo = this.getHostAppPackageInfo();
        return packageInfo != null ? Integer.toString(packageInfo.versionCode) : UNKNOWN_VALUE;
    }

    public String getAppVersionName() {
        PackageInfo packageInfo = this.getHostAppPackageInfo();
        return packageInfo != null ? String.valueOf(packageInfo.versionName) : UNKNOWN_VALUE;
    }

    public String getAppPackageName() {
        PackageInfo packageInfo = this.getHostAppPackageInfo();
        return packageInfo != null ? String.valueOf(packageInfo.packageName) : UNKNOWN_VALUE;
    }
}

