/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.AsyncTask;
import android.os.Debug;
import io.embrace.android.embracesdk.DebugMessage;
import io.embrace.android.embracesdk.Device;
import io.embrace.android.embracesdk.EmbraceApiRequest;
import io.embrace.android.embracesdk.EmbraceAsyncTask;
import io.embrace.android.embracesdk.EmbraceEndpoint;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.EmbraceSharedPreferences;
import io.embrace.android.embracesdk.FileUtils;
import io.embrace.android.embracesdk.FixedSizeDeque;
import io.embrace.android.embracesdk.Screenshot;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.User;
import io.embrace.android.embracesdk.cache.file.CollectionFileCacheReader;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import io.embrace.android.embracesdk.helpers.FileCache;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

class EmbraceServer {
    private static final int FAILED_SESSIONS_LOG_MAX = 10;
    private static final int FAILED_EVENTS_LOG_MAX = 10;
    private static final int FAILED_SESSION_STARTS_LOG_MAX = 10;
    private static final int FAILED_SCREENSHOTS_LOG_MAX = 10;
    private static final int FAILED_DEBUG_MESSAGES_LOG_MAX = 10;
    private static final String BASE_URL_FORMAT = "%s://%s.%s";
    private static final String URL_FORMAT = "%s/v%s/%s";
    private static final String API_VERSION = "1";
    private static final String CONFIG_API_VERSION = "2";
    private static final String API_SCHEME = "https";
    private static final String API_HOST = "emb-api.com";
    private static final String CONFIG_URL_FORMAT = "%s?appId=%s&osVersion=%s&appVersion=%s&deviceId=%s";
    private static final String SCREENSHOT_URL_FORMAT = "%s/%s/%s/%s.jpg";
    private static final String SCREENSHOT_MOMENTS_PATH = "moments";
    private static final String SCREENSHOT_LOGS_PATH = "logs";
    private static final String STORY_ID_HEADER_FORMAT = "%s:%s";
    private static final String DATA_API_SUBDOMAIN = "data";
    private static final String DEV_MODE_DATA_API_SUBDOMAIN = "data-dev";
    private static final String CONFIG_API_SUBDOMAIN = "config";
    private static final String IMAGES_API_SUBDOMAIN = "images";
    private static final String EVENTS_API_PATH = "log/events";
    private static final String USERS_API_PATH = "log/users";
    private static final String SESSIONS_API_PATH = "log/sessions";
    private static final String LOGS_API_PATH = "log/logging";
    private static final String CONFIG_API_PATH = "config";
    private static final String IMAGES_API_PATH = "screenshot";
    private static final String DEBUG_MESSAGES_API_PATH = "debugMessages";
    private static final EmbraceServer singleton = new EmbraceServer();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final FixedSizeDeque<JSONObject> failedSessionStarts = new FixedSizeDeque(10);
    private final FixedSizeDeque<Session> failedSessions = new FixedSizeDeque(10);
    private final FixedSizeDeque<EmbraceEvent> failedEvents = new FixedSizeDeque(10);
    private final FixedSizeDeque<Screenshot> failedScreenshots = new FixedSizeDeque(10);
    private final FixedSizeDeque<DebugMessage> failedDebugMessages = new FixedSizeDeque(10);
    private boolean attemptingRetries = false;
    private final Runnable retryFailedRequestsRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                EmbraceServer.this.retryFailedRequests();
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logDebug("Error while retrying sending of failed requests", e);
            }
        }
    };

    private EmbraceServer() {
        this.restoreCachedFailures();
    }

    static EmbraceServer getInstance() {
        return singleton;
    }

    static Executor getExecutor() {
        return AsyncTask.THREAD_POOL_EXECUTOR;
    }

    void fetchConfigurationCompletion(EmbraceApiCallback callback) throws EmbraceSdkException {
        EmbraceApiRequest request = this.remoteConfigRequest();
        if (request != null) {
            EmbraceAsyncTask asyncTask;
            try {
                asyncTask = new EmbraceAsyncTask(request.createRemoteConfigConnection(), request, callback);
            }
            catch (IOException e) {
                throw new EmbraceSdkException("couldn't fetch config", e);
            }
            asyncTask.executeOnExecutor(EmbraceServer.getExecutor(), new Void[0]);
        } else {
            EmbraceLogger.logError("Could not create request for remote config fetch");
        }
    }

    void sendUserMessageCompletion(final IUserCompletionMessageCallback callback) throws EmbraceSdkException {
        EmbraceLogger.logDebug("sending user information");
        String urlString = this.urlStringForRequestToEndpoint(EmbraceEndpoint.USERS);
        if (urlString == null) {
            EmbraceLogger.logError("null url for request to user endpoint, aborting");
            return;
        }
        Map<String, Object> userInfo = User.getInstance().mapRepresentation();
        EmbraceLogger.logDebug(String.format("user message payload: %s", userInfo.toString()));
        JSONObject payload = User.getInstance().toJsonObject();
        if (payload == null) {
            EmbraceLogger.logError("error encoding json for user message:");
            return;
        }
        try {
            EmbraceApiRequest request = new EmbraceApiRequest(new URL(urlString), null, payload.toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) {
                    EmbraceSharedPreferences.getInstance().setUserMessageNeedsRetry(false);
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(String error, int statusCode) {
                    EmbraceSharedPreferences.getInstance().setUserMessageNeedsRetry(true);
                    if (callback != null) {
                        callback.onError();
                    }
                }

                @Override
                public void onException(Exception e) {
                    EmbraceSharedPreferences.getInstance().setUserMessageNeedsRetry(true);
                    if (callback != null) {
                        callback.onError();
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbraceServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbraceLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendStartOfSession(final JSONObject payload, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString = this.urlStringForRequestToEndpoint(EmbraceEndpoint.SESSIONS);
        if (urlString == null) {
            EmbraceLogger.logError("null url for request to session endpoint, aborting");
            return;
        }
        if (payload == null) {
            EmbraceLogger.logError("error encoding json for session message");
            return;
        }
        try {
            EmbraceApiRequest request = new EmbraceApiRequest(new URL(urlString), null, payload.toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbraceServer.this.attemptingRetries) {
                        EmbraceServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedSessionStart(payload);
                    }
                    if (callback != null) {
                        callback.onError(error, statusCode);
                    }
                }

                @Override
                public void onException(Exception e) {
                    EmbraceServer.this.addFailedSessionStart(payload);
                    if (callback != null) {
                        callback.onException(e);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbraceServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbraceLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendSession(final Session session, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString = this.urlStringForRequestToEndpoint(EmbraceEndpoint.SESSIONS);
        if (urlString == null) {
            EmbraceLogger.logError("null url for request to session endpoint, aborting");
            return;
        }
        if (session == null || session.serverPayload() == null) {
            EmbraceLogger.logError("error encoding json for session message");
            return;
        }
        try {
            EmbraceApiRequest request = new EmbraceApiRequest(new URL(urlString), null, session.serverPayload().toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbraceServer.this.attemptingRetries) {
                        EmbraceServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedSession(session);
                    }
                    if (callback != null) {
                        callback.onError(error, statusCode);
                    }
                }

                @Override
                public void onException(Exception e) {
                    EmbraceServer.this.addFailedSession(session);
                    if (callback != null) {
                        callback.onException(e);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbraceServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbraceLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendEvent(final EmbraceEvent event, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString;
        switch (event.getType()) {
            case INFO_LOG: 
            case ERROR_LOG: 
            case WARNING_LOG: {
                urlString = this.urlStringForRequestToEndpoint(EmbraceEndpoint.LOGS);
                break;
            }
            default: {
                urlString = this.urlStringForRequestToEndpoint(EmbraceEndpoint.EVENTS);
            }
        }
        if (urlString == null) {
            EmbraceLogger.logError("null url for request to session endpoint, aborting");
            return;
        }
        if (event.serverPayload() == null) {
            EmbraceLogger.logError("error encoding json for event message");
            return;
        }
        String storyIdentifier = String.format(STORY_ID_HEADER_FORMAT, event.getTypeAbbreviation(), event.getStoryId());
        try {
            EmbraceApiRequest request = new EmbraceApiRequest(new URL(urlString), this.getHeadersForEventsRequest(storyIdentifier, event.getType()), event.serverPayload().toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (event.getType() == EmbraceEvent.Type.END && !EmbraceServer.this.attemptingRetries) {
                        EmbraceServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedEvent(event);
                    }
                    if (callback != null) {
                        callback.onError(error, statusCode);
                    }
                }

                @Override
                public void onException(Exception e) {
                    EmbraceServer.this.addFailedEvent(event);
                    if (callback != null) {
                        callback.onException(e);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbraceServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbraceLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendDebugMessage(final DebugMessage embDebugMessage, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString = this.urlStringForRequestToEndpoint(EmbraceEndpoint.DEBUG_MESSAGES);
        if (urlString == null) {
            EmbraceLogger.logError("null url for request to debug messages endpoint, aborting");
            return;
        }
        if (embDebugMessage == null || embDebugMessage.getServerPayload() == null) {
            EmbraceLogger.logError("error encoding json for debug message");
            return;
        }
        try {
            EmbraceApiRequest request = new EmbraceApiRequest(new URL(urlString), null, embDebugMessage.getServerPayload().toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbraceServer.this.attemptingRetries) {
                        EmbraceServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedDebugMessages(embDebugMessage);
                    }
                    if (callback != null) {
                        callback.onError(error, statusCode);
                    }
                }

                @Override
                public void onException(Exception e) {
                    EmbraceServer.this.addFailedDebugMessages(embDebugMessage);
                    if (callback != null) {
                        callback.onException(e);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbraceServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbraceLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    private String urlStringForRequestToEndpoint(EmbraceEndpoint endpoint) {
        switch (endpoint) {
            case CONFIG: {
                String baseUrlString = String.format(BASE_URL_FORMAT, API_SCHEME, "config", API_HOST);
                return String.format(URL_FORMAT, baseUrlString, CONFIG_API_VERSION, "config");
            }
            case EVENTS: {
                String baseUrlString = String.format(BASE_URL_FORMAT, API_SCHEME, this.getEmbDataApiSubdomain(), API_HOST);
                return String.format(URL_FORMAT, baseUrlString, API_VERSION, EVENTS_API_PATH);
            }
            case USERS: {
                String baseUrlString = String.format(BASE_URL_FORMAT, API_SCHEME, this.getEmbDataApiSubdomain(), API_HOST);
                return String.format(URL_FORMAT, baseUrlString, API_VERSION, USERS_API_PATH);
            }
            case SESSIONS: {
                String baseUrlString = String.format(BASE_URL_FORMAT, API_SCHEME, this.getEmbDataApiSubdomain(), API_HOST);
                return String.format(URL_FORMAT, baseUrlString, API_VERSION, SESSIONS_API_PATH);
            }
            case IMAGES: {
                String baseUrlString = String.format(BASE_URL_FORMAT, API_SCHEME, IMAGES_API_SUBDOMAIN, API_HOST);
                return String.format(URL_FORMAT, baseUrlString, API_VERSION, IMAGES_API_PATH);
            }
            case LOGS: {
                String baseUrlString = String.format(BASE_URL_FORMAT, API_SCHEME, this.getEmbDataApiSubdomain(), API_HOST);
                return String.format(URL_FORMAT, baseUrlString, API_VERSION, LOGS_API_PATH);
            }
            case DEBUG_MESSAGES: {
                String baseUrlString = String.format(BASE_URL_FORMAT, API_SCHEME, this.getEmbDataApiSubdomain(), API_HOST);
                return String.format(URL_FORMAT, baseUrlString, API_VERSION, DEBUG_MESSAGES_API_PATH);
            }
        }
        return null;
    }

    private EmbraceApiRequest remoteConfigRequest() throws EmbraceSdkException {
        URL configUrl;
        String baseConfigUrl = this.urlStringForRequestToEndpoint(EmbraceEndpoint.CONFIG);
        if (baseConfigUrl == null) {
            EmbraceLogger.logError("null url for config endpoint, aborting");
            return null;
        }
        String configUrlString = String.format(CONFIG_URL_FORMAT, baseConfigUrl, EmbraceManager.getInstance().getBuildInfo().getAppId(), Device.getInstance().getOperatingSystemVersionForRequest(), Device.getInstance().getVersionCodeForRequest(), EmbraceSharedPreferences.getInstance().getDeviceId());
        try {
            configUrl = new URL(configUrlString);
        }
        catch (MalformedURLException e) {
            throw new EmbraceSdkException("wrong configUrlString: " + configUrlString, e);
        }
        return new EmbraceApiRequest(configUrl);
    }

    void sendScreenshot(final Screenshot screenshot, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String fullUrlString;
        String baseUrlString = this.urlStringForRequestToEndpoint(EmbraceEndpoint.IMAGES);
        if (baseUrlString == null) {
            EmbraceLogger.logError("null url for request to images endpoint, aborting");
            return;
        }
        if (screenshot.getStoryId() != null) {
            fullUrlString = String.format(SCREENSHOT_URL_FORMAT, baseUrlString, EmbraceManager.getInstance().getBuildInfo().getAppId(), SCREENSHOT_MOMENTS_PATH, screenshot.getStoryId());
        } else if (screenshot.getLogId() != null) {
            fullUrlString = String.format(SCREENSHOT_URL_FORMAT, baseUrlString, EmbraceManager.getInstance().getBuildInfo().getAppId(), SCREENSHOT_LOGS_PATH, screenshot.getLogId());
        } else {
            EmbraceLogger.logError("null story id and log id for request to images endpoint, aborting");
            return;
        }
        if (screenshot.getData() == null) {
            EmbraceLogger.logError("null image data request to images endpoint, aborting");
            return;
        }
        try {
            EmbraceApiRequest request = new EmbraceApiRequest(new URL(fullUrlString), this.getHeadersForScreenshotRequest(screenshot), screenshot.getData());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbraceServer.this.attemptingRetries) {
                        EmbraceServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedScreenshots(screenshot);
                    }
                    if (callback != null) {
                        callback.onError(error, statusCode);
                    }
                }

                @Override
                public void onException(Exception e) {
                    EmbraceServer.this.addFailedScreenshots(screenshot);
                    if (callback != null) {
                        callback.onException(e);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbraceServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbraceLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    private synchronized void addFailedEvent(EmbraceEvent event) {
        try {
            this.failedEvents.forcePutLast(event);
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed event", exception);
        }
        this.cacheFailedEvents();
    }

    private synchronized void addFailedSession(Session session) {
        try {
            this.failedSessions.forcePutLast(session);
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed session", exception);
        }
        this.cacheFailedSessions();
    }

    private synchronized void addFailedSessionStart(JSONObject payload) {
        try {
            this.failedSessionStarts.forcePutLast(payload);
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed session start", exception);
        }
        this.cacheFailedSessionStarts();
    }

    synchronized void addFailedSessions(Collection<Session> sessions) {
        if (sessions == null || sessions.size() == 0) {
            EmbraceLogger.logWarning("no additional failed sessions to add");
            return;
        }
        try {
            this.failedSessions.forcePutAll(sessions);
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed sessions found in cache", exception);
        }
        this.cacheFailedSessions();
    }

    private synchronized void addFailedScreenshots(Screenshot screenshot) {
        try {
            this.failedScreenshots.forcePutLast(screenshot);
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed screenshot", exception);
        }
        this.cacheFailedScreenshots();
    }

    private synchronized void addFailedDebugMessages(DebugMessage embDebugMessage) {
        try {
            this.failedDebugMessages.forcePutLast(embDebugMessage);
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed debug message", exception);
        }
        this.cacheFailedDebugMessages();
    }

    private void restoreCachedFailures() {
        try {
            Collection<EmbraceEvent> failedEvents = this.getCachedFailedEvents();
            if (failedEvents != null) {
                this.failedEvents.forcePutAll(failedEvents);
            } else {
                FileUtils.removeFileAtPath(FileCache.FAILED_EVENTS);
            }
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed events found in cache", exception);
        }
        try {
            Collection<Session> failedSessions = this.getCachedFailedSessions();
            if (failedSessions != null) {
                this.failedSessions.forcePutAll(failedSessions);
            } else {
                FileUtils.removeFileAtPath(FileCache.FAILED_SESSIONS);
            }
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed sessions found in cache", exception);
        }
        try {
            Collection<JSONObject> failedSessionStarts = this.getCachedFailedSessionStarts();
            if (failedSessionStarts != null) {
                this.failedSessionStarts.forcePutAll(failedSessionStarts);
            } else {
                FileUtils.removeFileAtPath(FileCache.SESSION_START_MESSAGES);
            }
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed session starts found in cache", exception);
        }
        try {
            Collection<Screenshot> failedScreenshots = this.getCachedFailedScreenshots();
            if (failedScreenshots != null) {
                this.failedScreenshots.forcePutAll(failedScreenshots);
            } else {
                FileUtils.removeFileAtPath(FileCache.FAILED_SCREENSHOTS);
            }
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed screenshots found in cache", exception);
        }
        try {
            Collection<DebugMessage> failedDebugMessages = this.getCachedFailedDebugMessages();
            if (failedDebugMessages != null) {
                this.failedDebugMessages.forcePutAll(failedDebugMessages);
            } else {
                FileUtils.removeFileAtPath(FileCache.FAILED_DEBUG_MESSAGES);
            }
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Error while adding failed debug messages found in cache", exception);
        }
    }

    private void cacheFailedSessionStarts() {
        try {
            ArrayList<String> failedSessionStarts = new ArrayList<String>();
            for (JSONObject failedSessionStart : this.failedSessionStarts) {
                failedSessionStarts.add(failedSessionStart.toString());
            }
            FileUtils.saveCollectionToFile(failedSessionStarts, FileCache.SESSION_START_MESSAGES);
            EmbraceLogger.logDebug(String.format("wrote %s failed session starts to cache", failedSessionStarts.size()));
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logWarning("error while saving failed session starts", e);
        }
    }

    private void cacheFailedSessions() {
        try {
            ArrayList<String> failedSessions = new ArrayList<String>();
            for (Session session : this.failedSessions) {
                failedSessions.add(session.toJson());
            }
            FileUtils.saveCollectionToFile(failedSessions, FileCache.FAILED_SESSIONS);
            EmbraceLogger.logDebug(String.format("wrote %s failed sessions to cache", failedSessions.size()));
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logWarning("error while saving failed sessions", e);
        }
    }

    private void cacheFailedEvents() {
        try {
            ArrayList<String> failedEvents = new ArrayList<String>();
            for (EmbraceEvent event : this.failedEvents) {
                failedEvents.add(event.serverPayload().toString());
            }
            FileUtils.saveCollectionToFile(failedEvents, FileCache.FAILED_EVENTS);
            EmbraceLogger.logDebug(String.format("wrote %s failed events to cache", this.failedEvents.size()));
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logWarning("error while saving failed events", e);
        }
    }

    private void cacheFailedScreenshots() {
        try {
            FileUtils.saveCollectionToFile(this.failedScreenshots, FileCache.FAILED_SCREENSHOTS);
            EmbraceLogger.logDebug(String.format("wrote %s failed screenshots to cache", this.failedScreenshots.size()));
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logWarning("error while saving failed screenshots", e);
        }
    }

    private void cacheFailedDebugMessages() {
        try {
            ArrayList<String> failedDebugMessages = new ArrayList<String>();
            for (DebugMessage embDebugMessage : this.failedDebugMessages) {
                failedDebugMessages.add(embDebugMessage.getServerPayload().toString());
            }
            FileUtils.saveCollectionToFile(failedDebugMessages, FileCache.FAILED_DEBUG_MESSAGES);
            EmbraceLogger.logDebug(String.format("wrote %s failed debug messages to cache", this.failedDebugMessages.size()));
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logWarning("error while saving failed debug messages", e);
        }
    }

    private Collection<JSONObject> getCachedFailedSessionStarts() {
        return new CollectionFileCacheReader<String, JSONObject>(){

            @Override
            protected JSONObject parseElement(String element) throws Exception {
                return new JSONObject(element);
            }
        }.parse(FileCache.SESSION_START_MESSAGES);
    }

    private Collection<Session> getCachedFailedSessions() {
        return new CollectionFileCacheReader<String, Session>(){

            @Override
            public Session parseElement(String element) {
                return new Session(element);
            }
        }.parse(FileCache.FAILED_SESSIONS);
    }

    private Collection<EmbraceEvent> getCachedFailedEvents() {
        return new CollectionFileCacheReader<String, EmbraceEvent>(){

            @Override
            protected EmbraceEvent parseElement(String element) {
                return new EmbraceEvent(element);
            }
        }.parse(FileCache.FAILED_EVENTS);
    }

    private Collection<Screenshot> getCachedFailedScreenshots() {
        return new CollectionFileCacheReader<Screenshot, Screenshot>(){

            @Override
            protected Screenshot parseElement(Screenshot screenshot) {
                return screenshot;
            }
        }.parse(FileCache.FAILED_SCREENSHOTS);
    }

    private Collection<DebugMessage> getCachedFailedDebugMessages() {
        return new CollectionFileCacheReader<String, DebugMessage>(){

            @Override
            protected DebugMessage parseElement(String element) {
                return new DebugMessage(element);
            }
        }.parse(FileCache.FAILED_DEBUG_MESSAGES);
    }

    private synchronized EmbraceEvent popFailedEvent() {
        if (this.failedEvents.size() < 1) {
            return null;
        }
        return (EmbraceEvent)this.failedEvents.removeFirst();
    }

    private synchronized Session popFailedSession() {
        if (this.failedSessions.size() < 1) {
            return null;
        }
        return (Session)this.failedSessions.removeFirst();
    }

    private synchronized JSONObject popFailedSessionStart() {
        if (this.failedSessionStarts.size() < 1) {
            return null;
        }
        return (JSONObject)this.failedSessionStarts.removeFirst();
    }

    private synchronized Screenshot popFailedScreenshot() {
        if (this.failedScreenshots.size() < 1) {
            return null;
        }
        return (Screenshot)this.failedScreenshots.removeFirst();
    }

    private synchronized DebugMessage popFailedDebugMessage() {
        if (this.failedDebugMessages.size() < 1) {
            return null;
        }
        return (DebugMessage)this.failedDebugMessages.removeFirst();
    }

    private synchronized void retryFailedRequests() throws EmbraceSdkException {
        this.attemptingRetries = true;
        final EmbraceEvent retryEvent = this.popFailedEvent();
        if (retryEvent != null) {
            EmbraceLogger.logDebug(String.format("going to retry previously failed event %s", retryEvent.getStoryId()));
            this.sendEvent(retryEvent, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbraceLogger.logDebug("event retry succeeded, will keep retrying failed messages");
                    EmbraceServer.this.cacheFailedEvents();
                    EmbraceServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    EmbraceLogger.logDebug("event retry failed, stopping retries for now");
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedEvent(retryEvent);
                    }
                    EmbraceServer.this.attemptingRetries = false;
                }

                @Override
                public void onException(Exception e) {
                    EmbraceLogger.logDebug("event retry failed, stopping retries for now");
                    EmbraceServer.this.addFailedEvent(retryEvent);
                    EmbraceServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final JSONObject retrySessionStart = this.popFailedSessionStart();
        if (retrySessionStart != null) {
            EmbraceLogger.logDebug(String.format("going to retry previously failed session start %s", retrySessionStart));
            this.sendStartOfSession(retrySessionStart, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbraceLogger.logDebug("event retry succeeded, will keep retrying failed messages");
                    EmbraceServer.this.cacheFailedSessionStarts();
                    EmbraceServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    EmbraceLogger.logDebug("session start retry failed, stopping retries for now");
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedSessionStart(retrySessionStart);
                    }
                    EmbraceServer.this.attemptingRetries = false;
                }

                @Override
                public void onException(Exception e) {
                    EmbraceLogger.logDebug("session start retry failed, stopping retries for now");
                    EmbraceServer.this.addFailedSessionStart(retrySessionStart);
                    EmbraceServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final Session retrySession = this.popFailedSession();
        if (retrySession != null) {
            EmbraceLogger.logDebug(String.format("going to retry previously failed session %s", retrySession.getSessionId()));
            this.sendSession(retrySession, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbraceLogger.logDebug("session retry succeeded, will keep retrying failed messages");
                    EmbraceServer.this.cacheFailedSessions();
                    EmbraceServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    EmbraceLogger.logDebug("session retry failed, stopping retries for now");
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedSession(retrySession);
                    }
                    EmbraceServer.this.attemptingRetries = false;
                }

                @Override
                public void onException(Exception e) {
                    EmbraceLogger.logDebug("session retry failed, stopping retries for now");
                    EmbraceServer.this.addFailedSession(retrySession);
                    EmbraceServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final Screenshot retryScreenshot = this.popFailedScreenshot();
        if (retryScreenshot != null) {
            EmbraceLogger.logDebug(String.format("going to retry previously failed screenshot %s", retryScreenshot.getStoryId()));
            this.sendScreenshot(retryScreenshot, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbraceLogger.logDebug("screenshot retry succeeded, will keep retrying failed messages");
                    EmbraceServer.this.cacheFailedScreenshots();
                    EmbraceServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    EmbraceLogger.logDebug("screenshot retry failed, stopping retries for now");
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedScreenshots(retryScreenshot);
                    }
                    EmbraceServer.this.attemptingRetries = false;
                }

                @Override
                public void onException(Exception e) {
                    EmbraceLogger.logDebug("screenshot retry failed, stopping retries for now");
                    EmbraceServer.this.addFailedScreenshots(retryScreenshot);
                    EmbraceServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final DebugMessage retryEmbDebugMessage = this.popFailedDebugMessage();
        if (retryEmbDebugMessage != null) {
            EmbraceLogger.logDebug("going to retry previously failed debug message");
            this.sendDebugMessage(retryEmbDebugMessage, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbraceLogger.logDebug("debug message retry succeeded, will keep retrying failed messages");
                    EmbraceServer.this.cacheFailedDebugMessages();
                    EmbraceServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error, int statusCode) throws Exception {
                    EmbraceLogger.logDebug("debug message retry failed, stopping retries for now");
                    if (statusCode != 413) {
                        EmbraceServer.this.addFailedDebugMessages(retryEmbDebugMessage);
                    }
                    EmbraceServer.this.attemptingRetries = false;
                }

                @Override
                public void onException(Exception e) {
                    EmbraceLogger.logDebug("debug message retry failed, stopping retries for now");
                    EmbraceServer.this.addFailedDebugMessages(retryEmbDebugMessage);
                    EmbraceServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        if (EmbraceSharedPreferences.getInstance().userMessageNeedsRetry()) {
            EmbraceLogger.logDebug("going to retry previously failed user update");
            EmbraceSharedPreferences.getInstance().setUserMessageNeedsRetry(false);
            this.sendUserMessageCompletion(new IUserCompletionMessageCallback(){

                @Override
                public void onSuccess() {
                    EmbraceLogger.logDebug("user retry succeeded, will keep retrying failed messages");
                    EmbraceServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError() {
                    EmbraceLogger.logDebug("user message retry failed, stopping retries for now");
                    EmbraceSharedPreferences.getInstance().setUserMessageNeedsRetry(true);
                    EmbraceServer.this.attemptingRetries = false;
                }
            });
        } else {
            EmbraceLogger.logDebug("no retries left");
            this.attemptingRetries = false;
        }
    }

    private void scheduleSendingOfFailedRequests() {
        this.executorService.schedule(this.retryFailedRequestsRunnable, 500L, TimeUnit.MILLISECONDS);
    }

    void handleNetworkReachable() {
        if (!this.attemptingRetries) {
            try {
                this.retryFailedRequests();
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logDebug("Error while retrying sending of failed requests", e);
            }
        }
    }

    private Map<String, String> getHeadersForEventsRequest(String storyIdentifier, EmbraceEvent.Type eventType) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (eventType == EmbraceEvent.Type.INFO_LOG || eventType == EmbraceEvent.Type.ERROR_LOG || eventType == EmbraceEvent.Type.WARNING_LOG) {
            map.put("log_id_header", storyIdentifier);
        } else {
            map.put("story_id_header", storyIdentifier);
        }
        return map;
    }

    private Map<String, String> getHeadersForScreenshotRequest(Screenshot screenshot) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (screenshot.getLogId() != null) {
            map.put("log_id_header", screenshot.getLogId());
        } else if (screenshot.getStoryId() != null) {
            map.put("story_id_header", screenshot.getStoryId());
        }
        map.put("internal_content_type", "application/octet-stream");
        return map;
    }

    private String getEmbDataApiSubdomain() {
        return EmbraceManager.getInstance().getBuildInfo().isDebug() && (Debug.isDebuggerConnected() || Debug.waitingForDebugger()) ? DEV_MODE_DATA_API_SUBDOMAIN : DATA_API_SUBDOMAIN;
    }

    private static interface IUserCompletionMessageCallback {
        public void onSuccess();

        public void onError();
    }
}

