/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Application;
import android.content.Context;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;

public final class BuildInfo {
    static final String FILE_BUILD_INFO = "build-info.json";
    static final String BUILD_INFO_APP_ID = "app-id";
    static final String BUILD_INFO_BUILD_ID = "build-id";
    static final String BUILD_INFO_PROJECT_PACKAGE = "project-package";
    static final String BUILD_INFO_BUILD_CONFIG = "build-config";
    final String appId;
    final String buildId;
    final String packageName;
    final BuildConfig buildConfig;

    BuildInfo(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context is null.");
        }
        JSONObject buildInfo = this.getBuildInfoJson(context);
        this.appId = buildInfo.optString(BUILD_INFO_APP_ID, "");
        this.buildId = buildInfo.optString(BUILD_INFO_BUILD_ID, "");
        this.packageName = buildInfo.optString(BUILD_INFO_PROJECT_PACKAGE, "");
        this.buildConfig = buildInfo.has(BUILD_INFO_BUILD_CONFIG) ? new BuildConfig(buildInfo.optJSONObject(BUILD_INFO_BUILD_CONFIG)) : new BuildConfig(new JSONObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSONObject loadBuildInfo(InputStream in) throws IOException, JSONException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            JSONObject jSONObject = new JSONObject(out.toString("UTF-8"));
            return jSONObject;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject getBuildInfoJson(Context context) {
        JSONObject buildInfo;
        InputStream in = null;
        try {
            Application application = (Application)context.getApplicationContext();
            in = new BufferedInputStream(application.getAssets().open(FILE_BUILD_INFO));
            buildInfo = BuildInfo.loadBuildInfo(in);
        }
        catch (IOException | JSONException e) {
            buildInfo = new JSONObject();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    in = null;
                }
            }
        }
        return buildInfo;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public BuildConfig getBuildConfig() {
        return this.buildConfig;
    }

    public static final class BuildConfig {
        static final String BUILD_CONFIG_DEBUG = "debug";
        static final String BUILD_CONFIG_APPLICATION_ID = "application-id";
        static final String BUILD_CONFIG_BUILD_TYPE = "build-type";
        static final String BUILD_CONFIG_FLAVOR = "flavor";
        static final String BUILD_CONFIG_VERSION_CODE = "version-code";
        static final String BUILD_CONFIG_VERSION_NAME = "version-name";
        final boolean isDebug;
        final String applicationId;
        final String buildType;
        final String flavor;
        final int versionCode;
        final String versionName;

        private BuildConfig(JSONObject buildConfig) {
            this.isDebug = buildConfig.optBoolean(BUILD_CONFIG_DEBUG, false);
            this.applicationId = buildConfig.optString(BUILD_CONFIG_APPLICATION_ID, "");
            this.buildType = buildConfig.optString(BUILD_CONFIG_BUILD_TYPE, "");
            this.flavor = buildConfig.optString(BUILD_CONFIG_FLAVOR, "");
            this.versionCode = buildConfig.optInt(BUILD_CONFIG_VERSION_CODE, -1);
            this.versionName = buildConfig.optString(BUILD_CONFIG_VERSION_NAME, "");
        }

        public boolean isDebug() {
            return this.isDebug;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public String getBuildType() {
            return this.buildType;
        }

        public String getFlavor() {
            return this.flavor;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public String getVersionName() {
            return this.versionName;
        }
    }
}

