/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.os.SystemClock;
import android.util.Pair;
import android.view.GestureDetector;
import android.view.MotionEvent;
import io.embrace.android.embracesdk.Breadcrumb;
import io.embrace.android.embracesdk.BreadcrumbManager;
import io.embrace.android.embracesdk.swazzle.SwazzleContext;
import java.lang.ref.WeakReference;
import java.util.Calendar;

public class GestureListener
extends GestureDetector.SimpleOnGestureListener {
    private final WeakReference<Activity> activity;

    public GestureListener(Activity activity) {
        this.activity = new WeakReference<Activity>(activity);
    }

    public boolean onDown(MotionEvent e) {
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent event) {
        Activity activity;
        if (SwazzleContext.containsKey("breadcrumb_manager") && (activity = (Activity)this.activity.get()) != null) {
            ((BreadcrumbManager)SwazzleContext.get("breadcrumb_manager")).log((Pair<Float, Float>)new Pair((Object)Float.valueOf(event.getX()), (Object)Float.valueOf(event.getY())), activity.getLocalClassName(), GestureListener.getMotionEventUnixTimestamp(event), Breadcrumb.BreadcrumbType.TAP);
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent event) {
        Activity activity;
        if (SwazzleContext.containsKey("breadcrumb_manager") && (activity = (Activity)this.activity.get()) != null) {
            ((BreadcrumbManager)SwazzleContext.get("breadcrumb_manager")).log((Pair<Float, Float>)new Pair((Object)Float.valueOf(event.getX()), (Object)Float.valueOf(event.getY())), activity.getLocalClassName(), GestureListener.getMotionEventUnixTimestamp(event), Breadcrumb.BreadcrumbType.DOUBLE_TAP);
        }
        return false;
    }

    public void onLongPress(MotionEvent event) {
        Activity activity;
        if (SwazzleContext.containsKey("breadcrumb_manager") && (activity = (Activity)this.activity.get()) != null) {
            ((BreadcrumbManager)SwazzleContext.get("breadcrumb_manager")).log((Pair<Float, Float>)new Pair((Object)Float.valueOf(event.getX()), (Object)Float.valueOf(event.getY())), activity.getLocalClassName(), GestureListener.getMotionEventUnixTimestamp(event), Breadcrumb.BreadcrumbType.LONG_PRESS);
        }
    }

    static long getMotionEventUnixTimestamp(MotionEvent event) {
        return Calendar.getInstance().getTimeInMillis() - (SystemClock.uptimeMillis() - event.getDownTime());
    }
}

