/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class Properties {
    static final int MAX_PROPERTY_SIZE = 10;

    Properties() {
    }

    static Map<String, Object> normalizeProperties(Map<String, Object> properties) {
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        int propertyCount = 0;
        Iterator<Map.Entry<String, Object>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            String key = entry.getKey();
            if (key == null) {
                EmbraceLogger.logWarning("Property with not be added due to null key.");
                continue;
            }
            if (propertyCount >= 10) {
                EmbraceLogger.logWarning("The maximum number of properties has been set. Ignoring property with key: " + key);
                iter.remove();
                continue;
            }
            Object value = properties.get(key);
            properties.put(key, value != null ? value.toString() : "null");
            ++propertyCount;
        }
        return properties;
    }
}

