/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.IInterval;
import org.json.JSONException;
import org.json.JSONObject;

public class AnrInterval
implements IInterval {
    final long startTime;
    final long endTime;
    final Type type;

    public AnrInterval(Type type, long startTime, long endTime) {
        if (type == null) {
            throw new IllegalArgumentException("AnrInterval type is null.");
        }
        if (startTime < 0L) {
            throw new IllegalArgumentException("Start time cannot be negative.");
        }
        if (endTime < 0L) {
            throw new IllegalArgumentException("End time cannot be negative.");
        }
        this.type = type;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    Type getType() {
        return this.type;
    }

    private JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.startTime != 0L) {
                jsonObject.put("st", this.startTime);
            }
            if (this.endTime != 0L) {
                jsonObject.put("en", this.endTime);
            }
            jsonObject.put("v", (Object)this.type.name().toLowerCase());
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    JSONObject getServerPayload() {
        JSONObject payload = new JSONObject();
        try {
            if (this.startTime != 0L) {
                payload.put("st", this.startTime);
            }
            if (this.endTime != 0L) {
                payload.put("en", this.endTime);
            }
            payload.put("v", (Object)this.type.name().toLowerCase());
        }
        catch (JSONException e) {
            payload = null;
        }
        return payload;
    }

    public static enum Type {
        UI,
        BROADCAST;

    }
}

