/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.CustomFlow;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Properties;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.util.HashMap;
import java.util.Map;

public final class PurchaseFlow
extends CustomFlow {
    static final String MOMENT_ADD_TO_CART = "_add-to-cart";
    static final String MOMENT_PURCHASE = "_purchase";
    static final String PROP_AMOUNT = "amount";
    static final String PROP_ITEM_ID = "item-id";
    static final String PROP_NUM_ITEMS = "num-items";
    static final String PROP_ORDER_ID = "order-id";
    static final String PROP_PAYMENT_TYPE = "payment-type";
    static final String PROP_PRICE = "price";
    static final String PROP_QUANTITY = "quantity";
    final Map<String, Map<String, Object>> addToCartPropsMap = new HashMap<String, Map<String, Object>>();
    Map<String, Object> purchaseProps = new HashMap<String, Object>();
    String purchaseMomentId;

    public synchronized String addToCartStart(String itemId, Number quantity, Number price, Map<String, Object> properties) {
        if (this.embraceMgr == null) {
            return null;
        }
        String momentId = Uuid.getEmbUuid();
        properties = Properties.normalizeProperties(properties);
        if (itemId != null) {
            properties.put(PROP_ITEM_ID, itemId);
        }
        if (quantity != null) {
            properties.put(PROP_QUANTITY, quantity.toString());
        }
        if (price != null) {
            properties.put(PROP_PRICE, price.toString());
        }
        this.sendMomentStartEvent(MOMENT_ADD_TO_CART, momentId, true, properties);
        this.addToCartPropsMap.put(momentId, properties);
        return momentId;
    }

    public synchronized boolean addToCartComplete(String momentId) {
        if (this.embraceMgr == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)momentId) || !this.addToCartPropsMap.containsKey(momentId)) {
            EmbraceLogger.logError("Purchase flow does not recognize add-to-cart moment identifer.");
            return false;
        }
        this.sendMomentEndEvent(MOMENT_ADD_TO_CART, momentId);
        this.addToCartPropsMap.remove(momentId);
        return true;
    }

    public synchronized boolean addToCartFail(String momentId, String msg) {
        if (this.embraceMgr == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)momentId) || !this.addToCartPropsMap.containsKey(momentId)) {
            EmbraceLogger.logError("Purchase flow does not recognize add-to-cart moment identifier.");
            return false;
        }
        Map<String, Object> properties = this.addToCartPropsMap.get(momentId);
        if (msg != null) {
            properties.put("message", msg);
        }
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? "A failure occurred while adding an item to the cart." : "A failure occurred while adding an item to the cart: " + msg;
        this.sendLogError(errorLogMsg, true, properties);
        this.sendMomentEndEvent(MOMENT_ADD_TO_CART, momentId);
        this.addToCartPropsMap.remove(momentId);
        return true;
    }

    public synchronized boolean purchaseStart(String orderId, Number numItems, Number amount, String paymentType, Map<String, Object> properties) {
        if (this.embraceMgr == null) {
            return false;
        }
        properties = Properties.normalizeProperties(properties);
        if (orderId != null) {
            properties.put(PROP_ORDER_ID, orderId);
        }
        if (numItems != null) {
            properties.put(PROP_NUM_ITEMS, numItems.toString());
        }
        if (amount != null) {
            properties.put(PROP_AMOUNT, amount.toString());
        }
        if (paymentType != null) {
            properties.put(PROP_PAYMENT_TYPE, paymentType);
        }
        this.purchaseMomentId = Uuid.getEmbUuid();
        this.purchaseProps = properties;
        this.sendMomentStartEvent(MOMENT_PURCHASE, this.purchaseMomentId, false, properties);
        return true;
    }

    public synchronized boolean purchaseComplete() {
        if (this.embraceMgr == null) {
            return false;
        }
        this.sendLogInfo("Purchase was completed.", this.purchaseProps);
        this.sendMomentEndEvent(MOMENT_PURCHASE, this.purchaseMomentId);
        Embrace.getInstance().setUserAsPayer();
        return true;
    }

    public synchronized boolean purchaseFail(String msg) {
        if (this.embraceMgr == null) {
            return false;
        }
        if (msg != null) {
            this.purchaseProps.put("message", msg);
        }
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? "A failure occurred during purchase." : "A failure occurred during purchase: " + msg;
        this.sendLogError(errorLogMsg, true, this.purchaseProps);
        this.sendMomentEndEvent(MOMENT_PURCHASE, this.purchaseMomentId);
        return true;
    }
}

