/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.ITimestamp;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

class SystemEvent
implements ITimestamp {
    private static final String SYSTEM_EVENT_TIMESTAMP_KEY = "ts";
    private static final String SYSTEM_EVENT_VALUE_KEY = "v";
    private Float value;
    private long timestamp;

    SystemEvent() {
        this(null);
    }

    SystemEvent(Float value) {
        this.value = value;
        this.timestamp = Calendar.getInstance().getTimeInMillis();
    }

    JSONObject toJson() {
        JSONObject payload = new JSONObject();
        try {
            payload.put(SYSTEM_EVENT_TIMESTAMP_KEY, this.timestamp);
            if (this.value != null) {
                payload.put(SYSTEM_EVENT_VALUE_KEY, (Object)this.value);
            }
        }
        catch (JSONException e) {
            EmbraceLogger.logError("error creating system event object", e);
            payload = null;
        }
        return payload;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }
}

