/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.Properties;
import io.embrace.android.embracesdk.SessionManager;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.util.HashMap;
import java.util.Map;

abstract class CustomFlow {
    protected static final String PROP_MOMENT_ID = "moment-id";
    protected static final String PROP_MOMENT_NAME = "moment-name";
    protected static final String PROP_MESSAGE = "message";
    protected final Embrace embrace = Embrace.getInstance();
    protected final EmbraceManager embraceMgr = EmbraceManager.getInstance();
    protected final Map<String, Map<String, Moment>> customMoments = new HashMap<String, Map<String, Moment>>();

    CustomFlow() {
    }

    public synchronized String momentStart(String momentName, boolean doesAllowScreenshot, Map<String, Object> properties) {
        if (!this.embrace.isStarted()) {
            EmbraceLogger.logError("Embrace SDK has not been started.");
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)momentName)) {
            this.sendLogError("Moment momentName is null or blank.", false, null);
            return null;
        }
        if (!this.customMoments.containsKey(momentName)) {
            this.customMoments.put(momentName, new HashMap());
        }
        String momentId = Uuid.getEmbUuid();
        Map<String, Moment> moments = this.customMoments.get(momentName);
        this.sendMomentStartEvent(momentName, momentId, doesAllowScreenshot, Properties.normalizeProperties(properties));
        moments.put(momentId, new Moment(momentName, momentId, doesAllowScreenshot, properties));
        return momentId;
    }

    public synchronized boolean momentComplete(String momentName) {
        return this.momentComplete(momentName, null);
    }

    public synchronized boolean momentComplete(String momentName, String momentId) {
        if (!this.embrace.isStarted()) {
            EmbraceLogger.logError("Embrace SDK has not been started.");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)momentName)) {
            this.sendLogError("Moment name is null or blank.", false, null);
            return false;
        }
        Map<String, Moment> moments = this.customMoments.get(momentName);
        if (moments == null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(PROP_MOMENT_NAME, momentName);
            this.sendLogError(String.format("Cannot fail %s because moment name is not recognized.", momentName), false, properties);
            return false;
        }
        if (momentId == null) {
            for (Map.Entry<String, Moment> entry : moments.entrySet()) {
                this.sendMomentEndEvent(momentName, entry.getKey());
            }
            moments.clear();
        } else {
            Moment moment = moments.get(momentId);
            if (moment == null) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put(PROP_MOMENT_NAME, momentName);
                properties.put(PROP_MOMENT_ID, momentId);
                this.sendLogError(String.format("Cannot fail %s because moment identifier is not recognized.", momentName), false, properties);
                return false;
            }
            this.sendMomentEndEvent(momentName, momentId);
            moments.remove(momentId);
        }
        if (moments.isEmpty()) {
            this.customMoments.remove(momentName);
        }
        return true;
    }

    public synchronized boolean momentFail(String momentName, String msg) {
        return this.momentFail(momentName, null, msg);
    }

    public synchronized boolean momentFail(String momentName, String momentId, String msg) {
        Map<String, Moment> moments;
        if (!this.embrace.isStarted()) {
            EmbraceLogger.logError("Embrace SDK has not been started.");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)momentName)) {
            this.sendLogError("Moment name is null or blank.", false, null);
            return false;
        }
        String errorLogMsg = String.format("A failure occurred during the %s moment", momentName);
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = String.format("A failure occurred during %s", momentName);
        }
        if ((moments = this.customMoments.get(momentName)) == null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(PROP_MOMENT_NAME, momentName);
            this.sendLogError(String.format("Cannot fail %s because moment name is not recognized.", momentName), false, properties);
            return false;
        }
        if (momentId == null) {
            for (Map.Entry<String, Moment> entry : moments.entrySet()) {
                Moment moment = entry.getValue();
                if (msg != null) {
                    moment.properties.put(PROP_MESSAGE, msg);
                }
                this.sendMomentEndEvent(momentName, entry.getKey());
                this.sendLogError(errorLogMsg, moment.doesAllowScreenshot, moment.properties);
            }
            moments.clear();
        } else {
            Moment moment = moments.get(momentId);
            if (moment == null) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put(PROP_MOMENT_NAME, momentName);
                properties.put(PROP_MOMENT_ID, momentId);
                this.sendLogError(String.format("Cannot fail %s because moment identifier is not recognized.", momentName), false, properties);
                return false;
            }
            if (msg != null) {
                moment.properties.put(PROP_MESSAGE, msg);
            }
            this.sendMomentEndEvent(momentName, momentId);
            this.sendLogError(errorLogMsg, moment.doesAllowScreenshot, moment.properties);
            moments.remove(momentId);
        }
        if (moments.isEmpty()) {
            this.customMoments.remove(momentName);
        }
        return true;
    }

    protected synchronized void sendMomentStartEvent(String momentName, String momentId, boolean doesAllowScreenshot, Map<String, Object> properties) {
        if (!this.embrace.isStarted()) {
            EmbraceLogger.logError("Embrace SDK has not been started.");
            return;
        }
        try {
            this.embraceMgr.startEvent(momentName, momentId, doesAllowScreenshot, properties);
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logError(String.format("An error occurred trying to start moment: %s - %s", momentName, momentId), e);
        }
    }

    protected synchronized void sendMomentEndEvent(String momentName, String momentId) {
        if (!this.embrace.isStarted()) {
            EmbraceLogger.logError("Embrace SDK has not been started.");
            return;
        }
        try {
            this.embraceMgr.endEvent(momentName, momentId);
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logError(String.format("An error occurred trying to end moment: %s - %s", momentName, momentId), e);
        }
    }

    protected synchronized void sendLogInfo(String msg, Map<String, Object> properties) {
        if (!this.embrace.isStarted()) {
            EmbraceLogger.logError("Embrace SDK has not been started.");
            return;
        }
        try {
            this.embraceMgr.logMessage(msg, EmbraceEvent.Type.INFO_LOG, false, properties, SessionManager.manager.getStackTraceForCurrentThread());
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logError(String.format("An error occurred sending log info message: %s", msg), e);
        }
    }

    protected synchronized void sendLogError(String msg, boolean doesAllowScreenshot, Map<String, Object> properties) {
        if (!this.embrace.isStarted()) {
            EmbraceLogger.logError("Embrace SDK has not been started.");
            return;
        }
        try {
            this.embraceMgr.logMessage(msg, EmbraceEvent.Type.ERROR_LOG, doesAllowScreenshot, properties, SessionManager.manager.getStackTraceForCurrentThread());
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logError(String.format("An error occurred sending log error message: %s", msg), e);
        }
    }

    private static class Moment {
        final String name;
        final String id;
        final boolean doesAllowScreenshot;
        final Map<String, Object> properties;

        Moment(String name, String id, boolean doesAllowScreenshot, Map<String, Object> properties) {
            this.name = name;
            this.id = id;
            this.doesAllowScreenshot = doesAllowScreenshot;
            this.properties = properties;
        }
    }
}

