/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.ApplicationStateManager;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.PowerManager;
import io.embrace.android.embracesdk.constants.EmbraceApiConstants;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Session {
    private static final String KEY_CACHED_APP_DATA = "cached_app_data";
    private static final String KEY_CACHED_DEVICE_DATA = "cached_device_data";
    private static final String KEY_CACHED_PERFORMANCE_DATA = "cached_performance_data";
    private static final String KEY_CACHED_BREADCRUMB_DATA = "cached_breadcrumb_data";
    private static final String KEY_CACHED_USER_DATA = "cached_user_data";
    private static final String KEY_ADDITIONAL_PAYLOADS = "additional_payloads";
    private static final String EMB_SESSION_TYPE_START = "st";
    private static final String EMB_SESSION_TYPE_END = "en";
    private String sessionId;
    private Date startTime;
    private Date endTime;
    private Integer number;
    private boolean receivedTermination;
    private boolean coldStart;
    private JSONObject cachedAppData;
    private JSONObject cachedDeviceData;
    private JSONObject cachedPerformanceData;
    private JSONObject cachedBreadcrumbData;
    private JSONObject cachedUserData;
    private boolean endedCleanly;
    private float startingBatteryLevel;
    private Date lastHeartbeatTime;
    private Date terminationTime;
    private String lastApplicationState;
    private List<String> storyIds;
    private Map<String, JSONObject> additionalPayloads;
    private List<String> infoLogIds;
    private List<String> errorLogIds;
    private List<String> warningLogIds;

    Session(Integer number) {
        this.sessionId = Uuid.getEmbUuid(UUID.randomUUID().toString());
        this.startTime = Calendar.getInstance().getTime();
        this.number = number;
        this.storyIds = new ArrayList<String>();
        this.lastApplicationState = ApplicationStateManager.getManager().isInBackground() ? "inactive" : "active";
        this.startingBatteryLevel = PowerManager.getManager().getBatteryLevel();
        this.additionalPayloads = new HashMap<String, JSONObject>();
        this.infoLogIds = new ArrayList<String>();
        this.errorLogIds = new ArrayList<String>();
        this.warningLogIds = new ArrayList<String>();
    }

    Session(String jsonStr) {
        JSONObject json;
        try {
            json = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            EmbraceLogger.logWarning("Failed to initialize Session from JSON string.");
            json = new JSONObject();
        }
        this.sessionId = json.optString("id", Uuid.getEmbUuid(UUID.randomUUID().toString()));
        this.startTime = new Date(json.optLong(EMB_SESSION_TYPE_START, Calendar.getInstance().getTime().getTime()));
        this.endTime = json.isNull("et") ? null : new Date(json.optLong("et"));
        this.number = json.optInt("sn", 0);
        this.receivedTermination = json.optBoolean("tr", false);
        this.coldStart = json.optBoolean("cs", false);
        this.cachedAppData = json.optJSONObject(KEY_CACHED_APP_DATA);
        this.cachedDeviceData = json.optJSONObject(KEY_CACHED_DEVICE_DATA);
        this.cachedPerformanceData = json.optJSONObject(KEY_CACHED_PERFORMANCE_DATA);
        this.cachedBreadcrumbData = json.optJSONObject(KEY_CACHED_BREADCRUMB_DATA);
        this.cachedUserData = json.optJSONObject(KEY_CACHED_USER_DATA);
        this.endedCleanly = json.optBoolean("ce", false);
        this.startingBatteryLevel = (float)json.optDouble("ba", 0.0);
        this.lastHeartbeatTime = json.isNull("ht") ? null : new Date(json.optLong("ht"));
        this.terminationTime = json.isNull("tt") ? null : new Date(json.optLong("tt"));
        this.lastApplicationState = json.optString("ls", ApplicationStateManager.getManager().isInBackground() ? "inactive" : "active");
        this.storyIds = Session.parseJsonStringArray(json.optJSONArray("ss"));
        this.additionalPayloads = new HashMap<String, JSONObject>();
        JSONObject additionalPayloads = json.optJSONObject(KEY_ADDITIONAL_PAYLOADS);
        Iterator iter = additionalPayloads.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            JSONObject additionalPayload = additionalPayloads.optJSONObject(key);
            if (additionalPayload == null) continue;
            this.additionalPayloads.put(key, additionalPayload);
        }
        this.infoLogIds = Session.parseJsonStringArray(json.optJSONArray("il"));
        this.errorLogIds = Session.parseJsonStringArray(json.optJSONArray("el"));
        this.warningLogIds = Session.parseJsonStringArray(json.optJSONArray("wl"));
    }

    void endSession(boolean cleanly) {
        if (this.endTime == null) {
            this.endTime = Calendar.getInstance().getTime();
            this.endedCleanly = cleanly;
        }
    }

    void recordHeartbeat() {
        this.lastHeartbeatTime = Calendar.getInstance().getTime();
        this.lastApplicationState = ApplicationStateManager.getManager().isInBackground() ? "inactive" : "active";
    }

    synchronized void recordStateChange() {
        this.lastApplicationState = ApplicationStateManager.getManager().isInBackground() ? "inactive" : "active";
    }

    synchronized void addStoryId(String storyId) {
        this.storyIds.add(storyId);
    }

    void addMessageId(String messageId, EmbraceEvent.Type type) {
        switch (type) {
            case INFO_LOG: {
                this.infoLogIds.add(messageId);
                break;
            }
            case ERROR_LOG: {
                this.errorLogIds.add(messageId);
                break;
            }
            case WARNING_LOG: {
                this.warningLogIds.add(messageId);
                break;
            }
            default: {
                EmbraceLogger.logError("Unknown event type while adding message id");
            }
        }
    }

    synchronized void addPayload(JSONObject payload, String bodyKey) {
        if (payload == null || bodyKey == null) {
            EmbraceLogger.logWarning("can't add additional event payload with a null key or body");
            return;
        }
        this.additionalPayloads.put(bodyKey, payload);
    }

    private JSONObject toServerPayloadJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.sessionId != null) {
                jsonObject.put("id", (Object)this.sessionId);
            }
            if (this.startTime != null) {
                jsonObject.put(EMB_SESSION_TYPE_START, this.startTime.getTime());
            }
            if (this.endTime != null) {
                jsonObject.put("et", this.endTime.getTime());
            }
            if (this.number != null) {
                jsonObject.put("sn", (Object)this.number);
            }
            if (this.lastHeartbeatTime != null) {
                jsonObject.put("ht", this.lastHeartbeatTime.getTime());
            }
            if (this.terminationTime != null) {
                jsonObject.put("tt", this.terminationTime.getTime());
            }
            jsonObject.put("ls", (Object)this.lastApplicationState);
            jsonObject.put("ba", (double)this.startingBatteryLevel);
            jsonObject.put("ce", this.endedCleanly);
            jsonObject.put("tr", this.receivedTermination);
            jsonObject.put("cs", this.coldStart);
            jsonObject.put("ss", (Object)this.generateJsonArrayForMessageIds(this.storyIds));
            jsonObject.put("t", (Object)EMB_SESSION_TYPE_END);
            jsonObject.put("il", (Object)this.generateJsonArrayForMessageIds(this.infoLogIds));
            jsonObject.put("el", (Object)this.generateJsonArrayForMessageIds(this.errorLogIds));
            jsonObject.put("wl", (Object)this.generateJsonArrayForMessageIds(this.warningLogIds));
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    String toJson() {
        JSONObject json = this.toServerPayloadJson();
        if (json == null) {
            return "";
        }
        try {
            json.put(KEY_CACHED_APP_DATA, (Object)this.cachedAppData);
            json.put(KEY_CACHED_DEVICE_DATA, (Object)this.cachedDeviceData);
            json.put(KEY_CACHED_PERFORMANCE_DATA, (Object)this.cachedPerformanceData);
            json.put(KEY_CACHED_BREADCRUMB_DATA, (Object)this.cachedBreadcrumbData);
            json.put(KEY_CACHED_USER_DATA, (Object)this.cachedUserData);
            json.put(KEY_ADDITIONAL_PAYLOADS, (Object)new JSONObject(this.additionalPayloads != null ? this.additionalPayloads : new HashMap()));
        }
        catch (JSONException e) {
            EmbraceLogger.logWarning("An exception was thrown while encoding additional values to JSON", e);
            return "";
        }
        return json.toString();
    }

    JSONObject serverPayload() {
        JSONObject payload = new JSONObject();
        try {
            payload.put("v", (Object)EmbraceApiConstants.MESSAGE_FORMAT_VERSION);
            payload.put("s", (Object)this.toServerPayloadJson());
            for (String key : this.additionalPayloads.keySet()) {
                payload.put(key, (Object)this.additionalPayloads.get(key));
            }
        }
        catch (JSONException e) {
            payload = null;
        }
        return payload;
    }

    JSONObject startMessagePayload() {
        JSONObject payload = new JSONObject();
        try {
            if (this.sessionId != null) {
                payload.put("id", (Object)this.sessionId);
            }
            if (this.startTime != null) {
                payload.put(EMB_SESSION_TYPE_START, this.startTime.getTime());
            }
            if (this.number != null) {
                payload.put("sn", (Object)this.number);
            }
            payload.put("cs", this.coldStart);
            payload.put("t", (Object)EMB_SESSION_TYPE_START);
        }
        catch (JSONException e) {
            payload = null;
        }
        return payload;
    }

    boolean getColdStart() {
        return this.coldStart;
    }

    void setColdStart(boolean coldStart) {
        this.coldStart = coldStart;
    }

    String getSessionId() {
        return this.sessionId;
    }

    Date getStartTime() {
        return this.startTime;
    }

    Date getEndTime() {
        return this.endTime;
    }

    void setReceivedTermination(boolean receivedTermination) {
        this.receivedTermination = receivedTermination;
    }

    JSONObject getCachedAppData() {
        return this.cachedAppData != null ? this.cachedAppData : new JSONObject();
    }

    public JSONObject getCachedDeviceData() {
        return this.cachedDeviceData != null ? this.cachedDeviceData : new JSONObject();
    }

    JSONObject getCachedPerformanceData() {
        return this.cachedPerformanceData != null ? this.cachedPerformanceData : new JSONObject();
    }

    JSONObject getCachedBreadcrumbData() {
        return this.cachedBreadcrumbData != null ? this.cachedBreadcrumbData : new JSONObject();
    }

    public JSONObject getCachedUserData() {
        return this.cachedUserData != null ? this.cachedUserData : new JSONObject();
    }

    void setCachedAppData(JSONObject cachedAppData) {
        this.cachedAppData = cachedAppData;
    }

    public void setCachedDeviceData(JSONObject cachedDeviceData) {
        this.cachedDeviceData = cachedDeviceData;
    }

    void setCachedPerformanceData(JSONObject cachedPerformanceData) {
        this.cachedPerformanceData = cachedPerformanceData;
    }

    void setCachedBreadcrumbData(JSONObject cachedBreadcrumbData) {
        this.cachedBreadcrumbData = cachedBreadcrumbData;
    }

    void setCachedUserData(JSONObject cachedUserData) {
        this.cachedUserData = cachedUserData;
    }

    static List<String> parseJsonStringArray(JSONArray array) {
        ArrayList<String> elements = new ArrayList<String>();
        if (array != null) {
            for (int idx = 0; idx < array.length(); ++idx) {
                Object element = array.opt(idx);
                if (element == null || !(element instanceof String)) continue;
                elements.add((String)element);
            }
        }
        return elements;
    }

    JSONArray generateJsonArrayForMessageIds(List<String> messageIds) {
        JSONArray idsJsonArray = new JSONArray();
        for (String messageId : messageIds) {
            idsJsonArray.put((Object)messageId);
        }
        return idsJsonArray;
    }

    long getLastKnownTime() {
        return this.endTime != null ? this.endTime.getTime() : (this.lastHeartbeatTime != null ? this.lastHeartbeatTime.getTime() : this.startTime.getTime());
    }
}

