/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.v4.content.FileProvider;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.helpers.FileCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FileUtils {
    private static final long MAX_FILE_SIZE_IN_BYTES = 0x300000L;
    private static final String HOST_APP_ID = "hostAppId";
    private static final String FILE_PROVIDER = "io.embrace.android.embracesdk.fileprovider";
    private static final String CACHES_DIRECTORY = "caches";
    private static final String CONFIG_CACHE_FILE_PATH = "config";
    private static final String EVENT_CACHE_FILE_PATH = "events";
    private static final String SESSION_CACHE_FILE_PATH = "sessions";
    private static final String NETWORK_TRAFFIC_CACHE_FILE_PATH = "network";
    private static final String CPU_PROFILING_CACHE_FILE_PATH = "cpu";
    private static final String MEMORY_PROFILING_CACHE_FILE_PATH = "memory";
    private static final String ACTIVE_STORIES_CACHE_FILE_PATH = "stories";
    private static final String FAILED_EVENTS_CACHE_FILE_PATH = "failed.events";
    private static final String FAILED_SESSIONS_CACHE_FILE_PATH = "failed.sessions";
    private static final String UNSENT_SESSIONS_CACHE_FILE_PATH = "unsent.sessions";
    private static final String TERMINATION_MESSAGE_CACHE_FILE_PATH = "termination.message";
    private static final String FAILED_SESSION_START_MESSAGES_CACHE_FILE_PATH = "failed.session_start_messages";
    private static final String SESSION_INFO_FILE_NAME = "sessions";
    private static final String FAILED_SCREENSHOTS_CACHE_FILE_PATH = "failed.screenshots";
    private static final String FAILED_DEBUG_MESSAGES_CACHE_FILE_PATH = "failed.debug.messages";

    private FileUtils() {
    }

    static Uri getPathForCache(FileCache fileCache) {
        File file = new File(Embrace.getContext().getFilesDir(), CACHES_DIRECTORY);
        String authority = "io.embrace.android.embracesdk.fileprovider:" + FileUtils.getApplicationId();
        file.mkdir();
        switch (fileCache) {
            case CONFIG: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, CONFIG_CACHE_FILE_PATH));
            }
            case EVENTS: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EVENT_CACHE_FILE_PATH));
            }
            case SESSIONS: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, "sessions"));
            }
            case REQUESTS: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, NETWORK_TRAFFIC_CACHE_FILE_PATH));
            }
            case CPU_SPIKES: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, CPU_PROFILING_CACHE_FILE_PATH));
            }
            case MEMORY: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, MEMORY_PROFILING_CACHE_FILE_PATH));
            }
            case ACTIVE_STORIES: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, ACTIVE_STORIES_CACHE_FILE_PATH));
            }
            case FAILED_EVENTS: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, FAILED_EVENTS_CACHE_FILE_PATH));
            }
            case FAILED_SESSIONS: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, FAILED_SESSIONS_CACHE_FILE_PATH));
            }
            case UNSENT_SESSIONS: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, UNSENT_SESSIONS_CACHE_FILE_PATH));
            }
            case TERMINATION_MESSAGE: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, TERMINATION_MESSAGE_CACHE_FILE_PATH));
            }
            case SESSION_START_MESSAGES: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, FAILED_SESSION_START_MESSAGES_CACHE_FILE_PATH));
            }
            case FAILED_SCREENSHOTS: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, FAILED_SCREENSHOTS_CACHE_FILE_PATH));
            }
            case FAILED_DEBUG_MESSAGES: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, FAILED_DEBUG_MESSAGES_CACHE_FILE_PATH));
            }
        }
        return null;
    }

    static Map<String, Object> readSessionInfoFile() throws EmbraceSdkException {
        Map sessionContents = null;
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.pathForSessionInfoFile().getLastPathSegment());
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(inputStream);
            sessionContents = (Map)objectInputStream.readObject();
        }
        catch (IOException e) {
            EmbraceLogger.logDebug("no file at session info path");
        }
        catch (ClassNotFoundException e) {
            EmbraceLogger.logDebug("session info file incorrect format");
            throw new EmbraceSdkException("session info file incorrect format", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
        }
        return sessionContents;
    }

    static void updateSessionInfoFileContents(Map<String, Object> sessionInfoContents) throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.pathForSessionInfoFile().getLastPathSegment());
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(sessionInfoContents);
        }
        catch (FileNotFoundException e) {
            EmbraceLogger.logError("no file found for session info", e);
            throw new EmbraceSdkException("no file found for session info", e);
        }
        catch (IOException e) {
            EmbraceLogger.logError("error opening input stream", e);
            throw new EmbraceSdkException("error opening input stream", e);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
    }

    static <T extends Serializable> void saveMapToFile(Map<String, T> objectMap, FileCache fileCache) throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.getPathForCache(fileCache).getLastPathSegment());
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(objectMap);
        }
        catch (FileNotFoundException e) {
            EmbraceLogger.logError("no file found for " + fileCache.name(), e);
            throw new EmbraceSdkException("no file found for " + fileCache.name(), e);
        }
        catch (IOException e) {
            EmbraceLogger.logError("error opening input stream", e);
            e.printStackTrace();
            throw new EmbraceSdkException("error opening input stream", e);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
    }

    static <T extends Serializable> Map<String, T> readMapFromFile(FileCache fileCache) throws EmbraceSdkException {
        HashMap map = new HashMap();
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.getPathForCache(fileCache).getLastPathSegment());
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(inputStream);
            map.putAll((Map)objectInputStream.readObject());
        }
        catch (IOException e) {
            EmbraceLogger.logDebug("no file at path " + fileCache.name());
        }
        catch (ClassNotFoundException e) {
            EmbraceLogger.logDebug("file incorrect format");
            throw new EmbraceSdkException("file incorrect format", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
        }
        return map;
    }

    static <T extends Serializable> void saveCollectionToFile(Collection<T> collection, FileCache fileCache) throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.getPathForCache(fileCache).getLastPathSegment());
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(collection);
        }
        catch (FileNotFoundException e) {
            EmbraceLogger.logError("no file found for " + fileCache.name(), e);
            throw new EmbraceSdkException("no file found for " + fileCache.name(), e);
        }
        catch (IOException e) {
            EmbraceLogger.logError("error opening input stream", e);
            throw new EmbraceSdkException("error opening input stream", e);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
    }

    public static <T extends Serializable> Collection<T> readCollectionFromFile(FileCache fileCache) throws EmbraceSdkException {
        ArrayList collection = new ArrayList();
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.getPathForCache(fileCache).getLastPathSegment());
        if (FileUtils.deleteFileIfExceedsSize(file, 0x300000L)) {
            return collection;
        }
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(inputStream);
            collection.addAll((Collection)objectInputStream.readObject());
        }
        catch (IOException e) {
            EmbraceLogger.logDebug("no file at path " + fileCache.name());
        }
        catch (ClassNotFoundException e) {
            EmbraceLogger.logDebug("file incorrect format");
            throw new EmbraceSdkException("file incorrect format", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
        }
        return collection;
    }

    static String readStringFromFile(FileCache fileCache) throws EmbraceSdkException {
        String string = null;
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.getPathForCache(fileCache).getLastPathSegment());
        if (FileUtils.deleteFileIfExceedsSize(file, 0x300000L)) {
            return string;
        }
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(inputStream);
            string = (String)objectInputStream.readObject();
        }
        catch (IOException e) {
            EmbraceLogger.logDebug("no file at path " + fileCache.name());
        }
        catch (ClassNotFoundException e) {
            EmbraceLogger.logDebug("file incorrect format");
            throw new EmbraceSdkException("file incorrect format", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
        }
        return string;
    }

    public static void removeFileAtPath(FileCache fileCache) {
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.getPathForCache(fileCache).getLastPathSegment());
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    private static Uri pathForSessionInfoFile() {
        File file = new File(Embrace.getContext().getFilesDir(), CACHES_DIRECTORY);
        file.mkdir();
        return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)("io.embrace.android.embracesdk.fileprovider:" + FileUtils.getApplicationId()), (File)new File(file, "sessions"));
    }

    private static String getApplicationId() {
        try {
            ApplicationInfo ai = Embrace.getContext().getPackageManager().getApplicationInfo(Embrace.getContext().getPackageName(), 128);
            return ai.metaData.get(HOST_APP_ID).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            EmbraceLogger.logError("Unable to get application id", e);
            return Embrace.getContext().getApplicationContext().getApplicationInfo().packageName;
        }
    }

    private static boolean deleteFileIfExceedsSize(File file, long threshold) {
        if (file != null && file.exists() && file.length() > threshold) {
            file.delete();
            return true;
        }
        return false;
    }
}

