/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.swazzle.callback.android.app;

import android.os.Bundle;
import android.support.v4.view.GestureDetectorCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import io.embrace.android.embracesdk.ApplicationStateManager;
import io.embrace.android.embracesdk.BreadcrumbManager;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.GestureListener;
import io.embrace.android.embracesdk.annotation.StartupActivity;
import io.embrace.android.embracesdk.swazzle.SwazzleContext;
import java.util.Calendar;

public final class Activity {
    private static GestureDetectorCompat gestureDetectorCompat;

    public static void _preDispatchTouchEvent(android.app.Activity thiz, MotionEvent event) {
        if (gestureDetectorCompat != null) {
            gestureDetectorCompat.onTouchEvent(event);
        }
    }

    public static void _preOnCreate(android.app.Activity thiz, Bundle bundle) {
        Activity.enableApplicationStateManager(thiz.getComponentName().getClassName());
    }

    public static void _preOnStart(android.app.Activity thiz) {
        Activity.enableApplicationStateManager(thiz.getComponentName().getClassName());
        if (SwazzleContext.containsKey("breadcrumb_manager")) {
            ((BreadcrumbManager)SwazzleContext.get("breadcrumb_manager")).logView(thiz.getClass().getName(), Calendar.getInstance().getTimeInMillis());
        }
    }

    public static void _preOnPause(android.app.Activity thiz) {
        gestureDetectorCompat = null;
    }

    public static void _preOnResume(android.app.Activity thiz) {
        if (gestureDetectorCompat == null) {
            GestureListener gestureListener = new GestureListener(thiz);
            gestureDetectorCompat = new GestureDetectorCompat(thiz.getApplicationContext(), (GestureDetector.OnGestureListener)gestureListener);
            gestureDetectorCompat.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)gestureListener);
        }
    }

    public static void _postOnResume(android.app.Activity thiz) {
        if (!thiz.getClass().isAnnotationPresent(StartupActivity.class)) {
            Embrace.getInstance().endAppStartup();
        }
    }

    public static void _postOnStop(android.app.Activity thiz) {
        Activity.disableApplicationStateManager(thiz.getComponentName().getClassName());
    }

    public static void _postOnDestroy(android.app.Activity thiz) {
        Activity.disableApplicationStateManager(thiz.getComponentName().getClassName());
    }

    private static void disableApplicationStateManager(String activityName) {
        if (SwazzleContext.containsKey("application_state_manager")) {
            ApplicationStateManager applicationStateManager = (ApplicationStateManager)SwazzleContext.get("application_state_manager");
            applicationStateManager.disable(activityName);
        }
    }

    private static void enableApplicationStateManager(String activityName) {
        if (SwazzleContext.containsKey("application_state_manager")) {
            ApplicationStateManager applicationStateManager = (ApplicationStateManager)SwazzleContext.get("application_state_manager");
            applicationStateManager.enable(activityName);
        }
    }
}

