/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import io.embrace.android.embracesdk.ApplicationStateManager;
import io.embrace.android.embracesdk.Breadcrumb;
import io.embrace.android.embracesdk.BreadcrumbManager;
import io.embrace.android.embracesdk.Device;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.EmbraceServer;
import io.embrace.android.embracesdk.EmbraceSharedPreferences;
import io.embrace.android.embracesdk.FileUtils;
import io.embrace.android.embracesdk.IntervalMeasurement;
import io.embrace.android.embracesdk.MemoryManager;
import io.embrace.android.embracesdk.MemorySample;
import io.embrace.android.embracesdk.NetworkCall;
import io.embrace.android.embracesdk.NetworkManager;
import io.embrace.android.embracesdk.PowerManager;
import io.embrace.android.embracesdk.ProcessManager;
import io.embrace.android.embracesdk.Screenshot;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SystemEvent;
import io.embrace.android.embracesdk.User;
import io.embrace.android.embracesdk.constants.EmbraceApiConstants;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import io.embrace.android.embracesdk.helpers.FileCache;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SessionManager {
    static final SessionManager manager = new SessionManager();
    private static final long SHUTDOWN_TIMEOUT_MS = 2000L;
    private static final String SESSION_INFO_UUID_KEY = "id";
    private static final String SESSION_INFO_NUMBER_KEY = "num";
    private static final String SESSION_TERMINATION_RECEIVED_STRING = "yes";
    private static final int SESSION_HEARTBEAT_INTERVAL_IN_SECONDS = 5;
    private static final int SCREENSHOT_COOLDOWN_INTERVAL_IN_MILLISECONDS = 3000;
    private static final int SCREENSHOT_JPEG_COMPRESSION_VALUE = 70;
    private final Map<String, Session> sessions = new HashMap<String, Session>();
    private final Map<String, Session> unsentSessions = new HashMap<String, Session>();
    private boolean lastSessionReceivedTermination;
    private Session currentSession;
    private Session lastSession;
    private boolean recentScreenshotTaken;
    private boolean isManagerEnabled = false;
    private Future sessionHeartbeatTimer;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private Runnable sendSessionRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                SessionManager.this.sendPreviousSession();
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logError("Error while sending session", e);
            }
        }
    };
    private Runnable processSessionHeartbeatRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                SessionManager.this.processSessionHeartbeat();
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logError("error while processing session heartbeat", e);
            }
        }
    };

    private SessionManager() {
    }

    synchronized void performStartup(boolean inBackground) throws EmbraceSdkException {
        String terminationLog = FileUtils.readStringFromFile(FileCache.TERMINATION_MESSAGE);
        if (SESSION_TERMINATION_RECEIVED_STRING.equals(terminationLog)) {
            this.lastSessionReceivedTermination = true;
        }
        FileUtils.removeFileAtPath(FileCache.TERMINATION_MESSAGE);
        this.checkForUnsentSessions(this.lastSessionReceivedTermination);
        if (!inBackground) {
            this.createSession();
            this.enable();
            this.recordColdStart();
        }
    }

    private void createSession() throws EmbraceSdkException {
        if (this.currentSession != null) {
            this.unsentSessions.put(this.currentSession.getSessionId(), this.currentSession);
            return;
        }
        this.getUnsentSessions();
        Session newSession = new Session(this.numberForNextSession());
        this.recoverPreviousSessionBreadcrumbViewBreadcrumb();
        this.currentSession = newSession;
        this.sessions.put(newSession.getSessionId(), newSession);
        this.unsentSessions.put(newSession.getSessionId(), newSession);
        Future sessionTimer = this.sessionHeartbeatTimer;
        if (sessionTimer != null) {
            sessionTimer.cancel(true);
        }
        if (EmbraceManager.getInstance().isSdkInitialized()) {
            this.sendSessionStart(this.currentSession);
        }
        EmbraceLogger.logDebug(String.format("created new session with id %s", newSession.getSessionId()));
    }

    private void recoverPreviousSessionBreadcrumbViewBreadcrumb() {
        String screen = BreadcrumbManager.getManager().getLastBreadcrumbScreenName();
        if (screen != null) {
            BreadcrumbManager.getManager().forceLogView(screen, System.currentTimeMillis());
        }
    }

    private void endCurrentSession() {
        if (this.currentSession == null) {
            EmbraceLogger.logWarning("can't end current session because current session is null");
            return;
        }
        this.currentSession.endSession(true);
        if (this.sessionHeartbeatTimer != null) {
            this.sessionHeartbeatTimer.cancel(true);
        }
        this.lastSession = this.currentSession;
        try {
            this.saveUnsentSessions();
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logWarning("error while saving unsent sessions", e);
        }
        this.currentSession = null;
        if (this.shouldRecordSessionMessageType()) {
            this.executorService.schedule(this.sendSessionRunnable, 0L, TimeUnit.MILLISECONDS);
        }
    }

    private Integer numberForNextSession() throws EmbraceSdkException {
        Object uuid;
        Map<String, Object> sessionInfo = FileUtils.readSessionInfoFile();
        Integer sessionNumber = 0;
        if (sessionInfo != null) {
            EmbraceLogger.logDebug(String.format("got session info %s", sessionInfo.toString()));
            uuid = sessionInfo.get(SESSION_INFO_UUID_KEY).toString();
            if (((String)uuid).equals(EmbraceSharedPreferences.getInstance().getDeviceId())) {
                sessionNumber = (Integer)sessionInfo.get(SESSION_INFO_NUMBER_KEY);
            }
        } else {
            EmbraceLogger.logDebug("session info was null");
        }
        uuid = sessionNumber;
        Integer n = sessionNumber = Integer.valueOf(sessionNumber + 1);
        HashMap<String, Object> updatedSessionInfo = new HashMap<String, Object>();
        updatedSessionInfo.put(SESSION_INFO_NUMBER_KEY, sessionNumber);
        updatedSessionInfo.put(SESSION_INFO_UUID_KEY, EmbraceSharedPreferences.getInstance().getDeviceId());
        FileUtils.updateSessionInfoFileContents(updatedSessionInfo);
        return sessionNumber;
    }

    private void sendPreviousSession() throws EmbraceSdkException {
        final Session previousSession = this.lastSession;
        if (previousSession == null) {
            EmbraceLogger.logWarning("can't send previous session because it's null");
            return;
        }
        this.lastSession = null;
        previousSession.addPayload(User.getInstance().toJsonObject(), "u");
        previousSession.addPayload(Device.getInstance().getAppInfoJsonObject(), "a");
        previousSession.addPayload(Device.getInstance().getDeviceInfoJsonObject(), "d");
        this.addPerformanceMetaDataToSession(previousSession);
        this.addBreadcrumbsToSession(previousSession);
        EmbraceServer.getInstance().sendSession(previousSession, new EmbraceApiCallback(){

            @Override
            public void onSuccess(String response) throws Exception {
                SessionManager.this.unsentSessions.remove(previousSession.getSessionId());
                SessionManager.this.saveUnsentSessions();
            }

            @Override
            public void onError(String error, int statusCode) throws Exception {
                SessionManager.this.unsentSessions.remove(previousSession.getSessionId());
                SessionManager.this.saveUnsentSessions();
            }

            @Override
            public void onException(Exception e) {
                SessionManager.this.unsentSessions.remove(previousSession.getSessionId());
                try {
                    SessionManager.this.saveUnsentSessions();
                }
                catch (EmbraceSdkException e1) {
                    EmbraceLogger.logError("Error saving unsent sessions %s", e1);
                }
            }
        });
    }

    void scheduleAndSendSessionStart() throws EmbraceSdkException {
        if (this.shouldRecordSessionMessageType()) {
            this.sessionHeartbeatTimer = this.executorService.scheduleAtFixedRate(this.processSessionHeartbeatRunnable, 0L, 5L, TimeUnit.SECONDS);
            if (this.currentSession != null) {
                this.sendSessionStart(this.currentSession);
            }
        }
    }

    private void sendSessionStart(Session session) throws EmbraceSdkException {
        JSONObject payload = new JSONObject();
        try {
            payload.put("s", (Object)session.startMessagePayload());
            payload.put("d", (Object)Device.getInstance().getDeviceInfoJsonObject());
            payload.put("a", (Object)Device.getInstance().getAppInfoJsonObject());
            payload.put("v", (Object)EmbraceApiConstants.MESSAGE_FORMAT_VERSION);
        }
        catch (JSONException e) {
            payload = null;
        }
        EmbraceServer.getInstance().sendStartOfSession(payload, null);
    }

    void sendSessionStartAfterReactivating() {
        if (this.currentSession != null && this.shouldRecordSessionMessageType()) {
            try {
                this.sendSessionStart(this.currentSession);
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logError("Error while sending start of session.", e);
            }
        }
    }

    private void processSessionHeartbeat() throws EmbraceSdkException {
        if (this.currentSession == null) {
            EmbraceLogger.logWarning("tried to process session heartbeat without current session");
            return;
        }
        Session current = this.currentSession;
        current.recordHeartbeat();
        current.setCachedAppData(Device.getInstance().getAppInfoJsonObject());
        current.setCachedPerformanceData(this.getPerformanceDataForSession(current));
        current.setCachedBreadcrumbData(this.getBreadcrumbDataForSession());
        current.setCachedDeviceData(Device.getInstance().getDeviceInfoJsonObject());
        current.setCachedUserData(User.getInstance().toJsonObject());
        this.saveUnsentSessions();
    }

    void recordColdStart() {
        this.currentSession.setColdStart(true);
    }

    void applicationEnteredBackground() {
        this.currentSession.recordStateChange();
        this.endCurrentSession();
        EmbraceManager.getInstance().deactivateDataManagers();
        EmbraceManager.getInstance().setAppUpdated(false);
        EmbraceManager.getInstance().setOsUpdated(false);
    }

    void applicationEnteredForeground() throws EmbraceSdkException {
        this.createSession();
        EmbraceManager.getInstance().activateDataManagers();
    }

    String getCurrentSessionId() {
        if (this.currentSession == null) {
            return null;
        }
        return this.currentSession.getSessionId();
    }

    void recordNewStory(String storyId) {
        if (this.currentSession == null) {
            EmbraceLogger.logWarning("no current session, session manager ignoring new story id");
            return;
        }
        this.currentSession.addStoryId(storyId);
    }

    void recordLog(String messageId, EmbraceEvent.Type type) {
        if (this.currentSession == null) {
            EmbraceLogger.logWarning(String.format("no current session, session manager ignoring new %s log id", EmbraceEvent.stringForEventType(type)));
            return;
        }
        this.currentSession.addMessageId(messageId, type);
    }

    synchronized void enable() {
        if (!this.isManagerEnabled) {
            this.executorService = Executors.newScheduledThreadPool(1);
            this.sessionHeartbeatTimer = this.executorService.scheduleAtFixedRate(this.processSessionHeartbeatRunnable, 0L, 5L, TimeUnit.SECONDS);
            this.isManagerEnabled = true;
        }
    }

    synchronized void disable(boolean isDiabledFromConfig) {
        if (this.isManagerEnabled) {
            try {
                if (this.sessionHeartbeatTimer != null) {
                    this.sessionHeartbeatTimer.cancel(true);
                }
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                    EmbraceLogger.logWarning("Executor service was not safely terminated.");
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                EmbraceLogger.logWarning("Error while shutting down executor", e);
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            if (isDiabledFromConfig && this.currentSession != null) {
                this.unsentSessions.remove(this.currentSession.getSessionId());
                try {
                    this.saveUnsentSessions();
                }
                catch (EmbraceSdkException e) {
                    EmbraceLogger.logWarning("Error while saving unsent sessions", e);
                }
            }
            this.isManagerEnabled = false;
        }
    }

    boolean triggerEventSnapshot(String messageId, EmbScreenshotReason embScreenshotReason) throws EmbraceSdkException {
        if (!EmbraceManager.getInstance().isScreenshotsEnabled() || ApplicationStateManager.getManager().isInBackground() || this.recentScreenshotTaken) {
            EmbraceLogger.logDebug("screenshots disabled or cooling down");
            return false;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SessionManager.this.recentScreenshotTaken = false;
            }
        }, 3000L);
        this.sendScreenshot(messageId, embScreenshotReason, EmbraceManager.getInstance().getForegroundActivity());
        this.recentScreenshotTaken = true;
        return true;
    }

    byte[] processScreenshot(Bitmap screenshot) {
        if (screenshot == null) {
            EmbraceLogger.logWarning("asked to process null screenshot, aborting");
            return null;
        }
        EmbraceLogger.logDebug("processing screenshot");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        screenshot.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)stream);
        screenshot.recycle();
        return stream.toByteArray();
    }

    void sendScreenshot(String messageId, EmbScreenshotReason reason, Activity activity) throws EmbraceSdkException {
        byte[] data = this.processScreenshot(this.takeScreenshot(activity));
        EmbraceServer.getInstance().sendScreenshot(new Screenshot(reason == EmbScreenshotReason.MOMENT_LATE ? messageId : null, reason == EmbScreenshotReason.MOMENT_LATE ? null : messageId, data), null);
    }

    Bitmap takeScreenshot(Activity activity) throws EmbraceSdkException {
        View view;
        if (activity != null && (view = activity.getWindow().getDecorView()) != null) {
            Bitmap screenshot = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(screenshot);
            view.draw(canvas);
            return screenshot;
        }
        return null;
    }

    List<String> getStackTraceForCurrentThread() {
        ArrayList<String> augmentedStackReturnAddresses = new ArrayList<String>();
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            augmentedStackReturnAddresses.add(element.toString());
        }
        return augmentedStackReturnAddresses;
    }

    private void checkForUnsentSessions(boolean terminationMessage) throws EmbraceSdkException {
        this.getUnsentSessions();
        if (this.currentSession != null && this.unsentSessions.containsKey(this.currentSession.getSessionId())) {
            this.unsentSessions.remove(this.currentSession.getSessionId());
        }
        if (!this.unsentSessions.isEmpty() && !this.shouldRecordSessionMessageType()) {
            EmbraceLogger.logDebug(String.format("found %s unsent sessions in cache, sending to server", this.unsentSessions.size()));
            for (Session session : this.unsentSessions.values()) {
                session.setReceivedTermination(terminationMessage);
                session.addPayload(session.getCachedAppData(), "a");
                session.addPayload(session.getCachedUserData(), "u");
                session.addPayload(session.getCachedDeviceData(), "d");
                session.addPayload(session.getCachedPerformanceData(), "p");
                session.addPayload(session.getCachedBreadcrumbData(), "br");
            }
            EmbraceServer.getInstance().addFailedSessions(this.unsentSessions.values());
            this.unsentSessions.clear();
            this.saveUnsentSessions();
        }
    }

    void saveSessionAfterCrash() throws EmbraceSdkException {
        this.currentSession.endSession(false);
        this.unsentSessions.put(this.currentSession.getSessionId(), this.currentSession);
        this.saveUnsentSessions();
    }

    private void addBreadcrumbsToSession(Session session) {
        JSONObject breadcrumbData = this.getBreadcrumbDataForSession();
        session.addPayload(breadcrumbData, "br");
    }

    private void addPerformanceMetaDataToSession(Session session) {
        JSONObject performanceData = this.getPerformanceDataForSession(session);
        session.addPayload(performanceData, "p");
    }

    private JSONObject getBreadcrumbDataForSession() {
        JSONObject jsonObject = new JSONObject();
        List<Breadcrumb> viewBreadcrumbs = BreadcrumbManager.getManager().getRecentViewBreadcrumbs(5);
        JSONArray viewBreadcrumbPayloads = new JSONArray();
        for (Breadcrumb breadcrumb : viewBreadcrumbs) {
            viewBreadcrumbPayloads.put((Object)breadcrumb.toJsonObject());
        }
        List<Breadcrumb> tapBreadcrumbs = BreadcrumbManager.getManager().getRecentTapBreadcrumbs(20);
        JSONArray tapBreadcrumbPayloads = new JSONArray();
        for (Breadcrumb breadcrumb : tapBreadcrumbs) {
            tapBreadcrumbPayloads.put((Object)breadcrumb.toJsonObject());
        }
        List<Breadcrumb> customBreadcrumbs = BreadcrumbManager.getManager().getRecentCustomBreadcrumbs(40);
        JSONArray customBreadcrumbPayloads = new JSONArray();
        for (Breadcrumb breadcrumb : customBreadcrumbs) {
            customBreadcrumbPayloads.put((Object)breadcrumb.toJsonObject());
        }
        try {
            jsonObject.put("vb", (Object)viewBreadcrumbPayloads);
            jsonObject.put("tb", (Object)tapBreadcrumbPayloads);
            jsonObject.put("cb", (Object)customBreadcrumbPayloads);
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    private JSONObject getPerformanceDataForSession(Session session) {
        if (session == null) {
            EmbraceLogger.logWarning("can't compute performance data without session");
            return null;
        }
        JSONObject performance = new JSONObject();
        try {
            performance.put("bt", (double)PowerManager.getManager().getBatteryLevel());
            performance.put("ds", (Object)Device.getInstance().getSystemMemoryAsJson());
            JSONArray cpuPayload = new JSONArray();
            for (IntervalMeasurement interval : ProcessManager.getManager().getCriticalIntervalsDuringSession(session)) {
                cpuPayload.put((Object)interval.getServerPayload());
            }
            performance.put("cp", (Object)cpuPayload);
            List<MemorySample> memorySamples = MemoryManager.getManager().getMemorySamplesDuringSession(session);
            JSONArray memoryPayload = new JSONArray();
            for (MemorySample memorySample : memorySamples) {
                memoryPayload.put((Object)memorySample.toJson());
            }
            performance.put("me", (Object)memoryPayload);
            List<SystemEvent> lowMemoryWarnings = MemoryManager.getManager().getMemoryWarningsDuringSession(session);
            JSONArray lowMemoryPayload = new JSONArray();
            for (SystemEvent systemEvent : lowMemoryWarnings) {
                lowMemoryPayload.put((Object)systemEvent.toJson());
            }
            performance.put("mw", (Object)lowMemoryPayload);
            List<IntervalMeasurement> chargingIntervals = PowerManager.getManager().getChargingIntervalsDuringSession(session);
            JSONArray chargingPayload = new JSONArray();
            for (IntervalMeasurement interval : chargingIntervals) {
                chargingPayload.put((Object)interval.getServerPayload());
            }
            performance.put("bc", (Object)chargingPayload);
            List<IntervalMeasurement> powerSaveModeIntervals = PowerManager.getManager().getPowerSaveModeIntervalsDuringSession(session);
            JSONArray powerSaveModeIntervalsJsonArray = new JSONArray();
            for (IntervalMeasurement embInterval : powerSaveModeIntervals) {
                powerSaveModeIntervalsJsonArray.put((Object)embInterval.getServerPayload());
            }
            performance.put("lp", (Object)powerSaveModeIntervalsJsonArray);
            List<SystemEvent> batteryMeasurements = PowerManager.getManager().getBatteryMeasurementsDuringSession(session);
            JSONArray batteryPayload = new JSONArray();
            for (SystemEvent measurement : batteryMeasurements) {
                batteryPayload.put((Object)measurement.toJson());
            }
            performance.put("bm", (Object)batteryPayload);
            List<IntervalMeasurement> netInterfaceIntervals = NetworkManager.getManager().getReachabilityIntervalsDuringSession(session);
            JSONArray netInterfacePayload = new JSONArray();
            for (IntervalMeasurement interval : netInterfaceIntervals) {
                netInterfacePayload.put((Object)interval.getServerPayload());
            }
            performance.put("ns", (Object)netInterfacePayload);
            List<NetworkCall> networkCalls = NetworkManager.getManager().getRequestsDuringSession(session);
            performance.put("nr", (Object)this.getNetworkRequestsJson(networkCalls));
        }
        catch (JSONException e) {
            performance = null;
        }
        return performance;
    }

    private synchronized void saveUnsentSessions() throws EmbraceSdkException {
        HashMap<String, String> unsentSessions = new HashMap<String, String>();
        for (Map.Entry<String, Session> entry : this.unsentSessions.entrySet()) {
            unsentSessions.put(entry.getKey(), entry.getValue().toJson());
        }
        FileUtils.saveMapToFile(unsentSessions, FileCache.UNSENT_SESSIONS);
    }

    private synchronized void getUnsentSessions() throws EmbraceSdkException {
        Map unsentSessions = FileUtils.readMapFromFile(FileCache.UNSENT_SESSIONS);
        for (Map.Entry entry : unsentSessions.entrySet()) {
            this.unsentSessions.put(entry.getKey(), new Session((String)entry.getValue()));
        }
    }

    private JSONObject getNetworkRequestsJson(List<NetworkCall> networkCalls) {
        JSONObject networkRequest = new JSONObject();
        try {
            networkRequest.put("hr", (Object)this.getNetworkInfoJson(networkCalls));
        }
        catch (JSONException e) {
            networkRequest = new JSONObject();
        }
        return networkRequest;
    }

    private JSONObject getNetworkInfoJson(List<NetworkCall> networkCalls) {
        JSONObject networkInfo = new JSONObject();
        try {
            networkInfo.put("rd", (Object)this.getNetworkRequestTimelineJson(networkCalls));
            networkInfo.put("pr", (Object)this.getProblematicNetworkRequestsJson(networkCalls));
        }
        catch (JSONException e) {
            networkInfo = new JSONObject();
        }
        return networkInfo;
    }

    private JSONObject getNetworkRequestTimelineJson(List<NetworkCall> networkCalls) {
        JSONObject timeline = new JSONObject();
        try {
            for (NetworkCall networkCall : networkCalls) {
                JSONObject methodUrlInfo;
                String method = networkCall.getHttpMethod();
                String url = networkCall.getUrlOriginPath();
                Integer statusCode = networkCall.getStatusCode();
                if (TextUtils.isEmpty((CharSequence)method) || TextUtils.isEmpty((CharSequence)url) || statusCode == null || networkCall.didClientError()) continue;
                String methodUrl = String.format("%s_%s", method, url);
                if (!timeline.has(methodUrl)) {
                    timeline.put(methodUrl, (Object)new JSONObject());
                }
                if (!(methodUrlInfo = timeline.getJSONObject(methodUrl)).has("rq")) {
                    methodUrlInfo.put("rq", (Object)new JSONArray());
                }
                JSONArray methodUrlInfoRequests = methodUrlInfo.getJSONArray("rq");
                JSONObject request = new JSONObject();
                request.put("rc", (Object)networkCall.getStatusCode());
                request.put("st", networkCall.getStartTime());
                request.put("dur", networkCall.getElapsedTime());
                methodUrlInfoRequests.put((Object)request);
                methodUrlInfo.put("rc", methodUrlInfo.optInt("rc", 0) + 1);
            }
        }
        catch (JSONException e) {
            timeline = new JSONObject();
        }
        return timeline;
    }

    private JSONArray getProblematicNetworkRequestsJson(List<NetworkCall> networkCalls) {
        JSONArray problemRequests = new JSONArray();
        int threshold = EmbraceManager.getInstance().getProblematicRequestLatency();
        for (NetworkCall networkCall : networkCalls) {
            if (!networkCall.didClientError() && networkCall.getStatusCode() < 300 && networkCall.getElapsedTime() < (long)threshold) continue;
            problemRequests.put((Object)networkCall.toJson());
        }
        return problemRequests;
    }

    private boolean shouldRecordSessionMessageType() {
        if (!EmbraceManager.getInstance().shouldRecordEvents()) {
            EmbraceLogger.logWarning("Sdk is disabled, ignoring sending of session");
            return false;
        }
        if (!EmbraceManager.getInstance().shouldRecordMessageType(EmbraceManager.MessageType.SESSION)) {
            EmbraceLogger.logWarning("Session messages are disabled, ignoring unsent session sending.");
            return false;
        }
        return true;
    }

    static enum EmbScreenshotReason {
        MOMENT_LATE,
        LOG;

    }
}

