/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.EmbraceSharedPreferences;
import io.embrace.android.embracesdk.MemoryManager;
import io.embrace.android.embracesdk.SessionManager;

public class ApplicationStateManager
implements ComponentCallbacks2,
Application.ActivityLifecycleCallbacks {
    public static final int MAX_STARTUP_DELAY_IN_MILLIS = 2000;
    private String activityName;
    private boolean isColdStart = true;
    private long startTime;
    private static final ApplicationStateManager manager = new ApplicationStateManager();

    static ApplicationStateManager getManager() {
        return manager;
    }

    private ApplicationStateManager() {
    }

    public void onTrimMemory(int trimLevel) {
        if (trimLevel == 10) {
            MemoryManager.getManager().handleMemoryWarning();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
    }

    public void enable(String activityName) {
        if (this.isInBackground()) {
            try {
                SessionManager.manager.applicationEnteredForeground();
                if (this.isColdStart) {
                    SessionManager.manager.recordColdStart();
                    if (System.currentTimeMillis() - this.startTime <= 2000L) {
                        EmbraceManager.getInstance().startEvent("_startup", null, true, null, this.startTime);
                    }
                }
                this.isColdStart = false;
                if (EmbraceManager.getInstance().shouldFetchConfig(EmbraceSharedPreferences.getInstance())) {
                    EmbraceManager.getInstance().fetchConfig();
                }
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logError("Error while entering foreground", e);
            }
        }
        this.activityName = activityName;
    }

    public void disable(String activityName) {
        if (activityName.equals(this.activityName)) {
            SessionManager.manager.applicationEnteredBackground();
            this.activityName = null;
        }
    }

    boolean isInBackground() {
        return this.activityName == null;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        EmbraceManager.getInstance().setForegroundActivity(activity);
    }

    public void onActivityPaused(Activity activity) {
        EmbraceManager.getInstance().setForegroundActivity(null);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

