/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import io.embrace.android.embracesdk.AppBuildConfig;
import io.embrace.android.embracesdk.ApplicationStateManager;
import io.embrace.android.embracesdk.Device;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceException;
import io.embrace.android.embracesdk.EmbraceExceptionHandler;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.EmbraceServer;
import io.embrace.android.embracesdk.EmbraceSharedPreferences;
import io.embrace.android.embracesdk.FileUtils;
import io.embrace.android.embracesdk.IntervalMeasurement;
import io.embrace.android.embracesdk.MemoryManager;
import io.embrace.android.embracesdk.MemorySample;
import io.embrace.android.embracesdk.NetworkCall;
import io.embrace.android.embracesdk.NetworkManager;
import io.embrace.android.embracesdk.PowerManager;
import io.embrace.android.embracesdk.ProcessManager;
import io.embrace.android.embracesdk.SdkConfig;
import io.embrace.android.embracesdk.SessionManager;
import io.embrace.android.embracesdk.SystemEvent;
import io.embrace.android.embracesdk.User;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import io.embrace.android.embracesdk.helpers.FileCache;
import io.embrace.android.embracesdk.helpers.LogLevel;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EmbraceManager {
    private static final String TAG = "[Embrace]";
    private static final String API_KEY_META_DATA = "io.embrace.android.embracesdk.api.key";
    private static final EmbraceManager singleton = new EmbraceManager();
    private String apiKey;
    private Device device;
    static LogLevel logLevel;
    private boolean sdkInitialized;
    private boolean sdkDisabled;
    private boolean sdkInSafeMode;
    private boolean screenshotsEnabled;
    private Set<MessageType> disabledMessageTypes;
    Pattern disabledEventAndLogPattern;
    Pattern disabledUrlPattern;
    Pattern disabledScreenshotPattern;
    private boolean isAppUpdated;
    private boolean isAppUpdatedThisLaunch;
    private boolean isOsUpdated;
    private boolean isOsUpdatedThisLaunch;
    private Map<String, EmbraceEvent> events;
    private Map<String, Serializable> activeStories;
    private Map<String, Future> eventLateTimers;
    private Map<String, Long> eventLateThresholds;
    private Set<String> disallowScreenshotStoryIds;
    private Set<Throwable> pendingThrowables;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private WeakReference<Activity> foregroundActivity;
    final AppBuildConfig buildConfig;

    private EmbraceManager() {
        Embrace.getInstance();
        this.buildConfig = new AppBuildConfig(Embrace.getContext());
        this.device = Device.getInstance();
        this.sdkDisabled = EmbraceSharedPreferences.getInstance().sdkDisabledFromSavedConfig();
        this.sdkInSafeMode = EmbraceSharedPreferences.getInstance().sdkStartupFailedLastSession();
        this.screenshotsEnabled = true;
        logLevel = this.buildConfig.isDebug() ? LogLevel.DEBUG : LogLevel.INFO;
        this.events = new HashMap<String, EmbraceEvent>();
        this.activeStories = new HashMap<String, Serializable>();
        this.disallowScreenshotStoryIds = new HashSet<String>();
        this.eventLateThresholds = new HashMap<String, Long>();
        this.eventLateTimers = new HashMap<String, Future>();
        this.pendingThrowables = new HashSet<Throwable>();
        this.disabledMessageTypes = new HashSet<MessageType>();
    }

    static EmbraceManager getInstance() {
        return singleton;
    }

    synchronized boolean setupApiKey() {
        this.apiKey = this.getApiKeyFromManifest();
        if (TextUtils.isEmpty((CharSequence)this.apiKey)) {
            return false;
        }
        Log.d((String)TAG, (String)String.format("Embrace SDK started successfully with key %s", this.apiKey));
        return true;
    }

    private String getApiKeyFromManifest() {
        try {
            ApplicationInfo ai = Embrace.getContext().getPackageManager().getApplicationInfo(Embrace.getContext().getPackageName(), 128);
            Object apiKeyMetadata = ai.metaData.get(API_KEY_META_DATA);
            return apiKeyMetadata != null ? apiKeyMetadata.toString() : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            EmbraceLogger.logError("Unable to get api key", e);
            return null;
        }
    }

    String getApiKey() {
        return this.apiKey;
    }

    void performStartup() throws EmbraceSdkException {
        boolean inBackground = ApplicationStateManager.getManager().isInBackground();
        EmbraceSharedPreferences.getInstance().recordStartupBegun();
        this.restoreConfig();
        if (this.sdkDisabled || this.sdkInSafeMode) {
            EmbraceLogger.logWarning("sdk disabled or in safe mode");
            this.fetchConfig();
            return;
        }
        this.fetchConfig();
        EmbraceLogger.logInfo("sdk enabled, starting");
        EmbraceSharedPreferences sharedPreferences = EmbraceSharedPreferences.getInstance();
        this.isAppUpdatedThisLaunch = this.isAppUpdated = sharedPreferences.isAppUpdated();
        this.isOsUpdatedThisLaunch = this.isOsUpdated = sharedPreferences.osUpdated();
        SessionManager.manager.performStartup(inBackground);
        sharedPreferences.updateAppInfo();
        sharedPreferences.updateDeviceInfo();
        sharedPreferences.recordStartupCompleted();
        EmbraceExceptionHandler.enable();
        this.sdkInitialized = true;
    }

    boolean shouldFetchConfig(EmbraceSharedPreferences embraceSharedPreferences) {
        return System.currentTimeMillis() - embraceSharedPreferences.getConfigFetchTimestamp() >= 3600000L;
    }

    synchronized void logMessage(String message, EmbraceEvent.Type type, boolean takeScreenshot, Map<String, Object> properties, List<String> stackTraces) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbraceLogger.logWarning(String.format("sdk is disabled, ignoring message %s", message));
        } else if (!this.shouldRecordMessageType(MessageType.LOG)) {
            EmbraceLogger.logWarning(String.format("log type is disabled, ignoring message %s", message));
        } else if (!this.shouldRecordEventWithName(message)) {
            EmbraceLogger.logWarning(String.format("log message is disabled, ignoring log message %s", message));
        } else {
            EmbraceEvent logEvent = null;
            switch (type) {
                case INFO_LOG: 
                case ERROR_LOG: 
                case WARNING_LOG: {
                    logEvent = new EmbraceEvent(type, message, properties);
                    break;
                }
                default: {
                    EmbraceLogger.logWarning("received log message of unknown type, ignoring");
                }
            }
            if (logEvent == null) {
                return;
            }
            boolean screenshotTaken = false;
            if (takeScreenshot && this.shouldTakeScreenshotForEvent(logEvent.getName())) {
                screenshotTaken = SessionManager.manager.triggerEventSnapshot(logEvent.getStoryId(), SessionManager.EmbScreenshotReason.LOG);
            }
            logEvent.setScreenshotTaken(screenshotTaken);
            logEvent.setSessionId(SessionManager.manager.getCurrentSessionId());
            this.addStackTrace(stackTraces, logEvent);
            this.addMetadataPayloadsToEvent(logEvent, null);
            EmbraceServer.getInstance().sendEvent(logEvent, null);
            SessionManager.manager.recordLog(logEvent.getStoryId(), type);
        }
    }

    synchronized void setUserIdentifier(String identifier) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbraceLogger.logWarning("sdk is disabled, ignoring user identifier update");
        } else if (!this.shouldRecordMessageType(MessageType.USER)) {
            EmbraceLogger.logWarning("user updates are disabled, ignoring user identifier update");
        } else {
            User.getInstance().updateInternalIdentifier(identifier, EmbraceSharedPreferences.getInstance());
        }
    }

    synchronized void setUserEmailAddress(String emailAddress) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbraceLogger.logWarning("sdk is disabled, ignoring user email address update");
        } else if (!this.shouldRecordMessageType(MessageType.USER)) {
            EmbraceLogger.logWarning("user updates are disabled, ignoring email address update");
        } else {
            User.getInstance().updateEmailAddress(emailAddress, EmbraceSharedPreferences.getInstance());
        }
    }

    synchronized void setUserIsPayer(boolean payer) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbraceLogger.logWarning("sdk is disabled, ignoring user payer update");
        } else if (!this.shouldRecordMessageType(MessageType.USER)) {
            EmbraceLogger.logWarning("user updates are disabled, ignoring user payer update");
        } else {
            User.getInstance().updatePayingUser(payer, EmbraceSharedPreferences.getInstance());
        }
    }

    synchronized void setUserPersona(String persona) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbraceLogger.logWarning("sdk is disabled, ignoring user persona update");
        } else if (!this.shouldRecordMessageType(MessageType.USER)) {
            EmbraceLogger.logWarning("user updates are disabled, ignoring user persona update");
        } else {
            User.getInstance().setPersona(persona, EmbraceSharedPreferences.getInstance());
        }
    }

    synchronized void removeUserPersona(String persona) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbraceLogger.logWarning("sdk is disabled, ignoring user persona update");
        } else if (!this.shouldRecordMessageType(MessageType.USER)) {
            EmbraceLogger.logWarning("user updates are disabled, ignoring user persona update");
        } else {
            User.getInstance().removePersona(persona, EmbraceSharedPreferences.getInstance());
        }
    }

    synchronized void setUsername(String username) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbraceLogger.logWarning("sdk is disabled, ignoring username update");
        } else if (!this.shouldRecordMessageType(MessageType.USER)) {
            EmbraceLogger.logWarning("user updates are disabled, ignoring username update");
        } else if (username != null && username.length() > 64) {
            EmbraceLogger.logWarning(String.format(Locale.getDefault(), "username %s is longer than maximum allowed length of %d; it will be truncated", username, 64));
            String truncatedUsername = username.substring(64);
            User.getInstance().updateUsername(truncatedUsername, EmbraceSharedPreferences.getInstance());
        } else {
            User.getInstance().updateUsername(username, EmbraceSharedPreferences.getInstance());
        }
    }

    boolean isAppUpdated() {
        return this.isAppUpdated;
    }

    void setAppUpdated(boolean isAppUpdated) {
        this.isAppUpdated = isAppUpdated;
    }

    boolean isAppUpdatedThisLaunch() {
        return this.isAppUpdatedThisLaunch;
    }

    boolean isOsUpdated() {
        return this.isOsUpdated;
    }

    void setOsUpdated(boolean isOsUpdated) {
        this.isOsUpdated = isOsUpdated;
    }

    boolean isOsUpdatedThisLaunch() {
        return this.isOsUpdatedThisLaunch;
    }

    String getEmbraceVersionString() {
        return "2.2.2";
    }

    boolean shouldRecordEvents() {
        return !this.sdkDisabled && !this.sdkInSafeMode && this.sdkInitialized;
    }

    boolean isSdkInitialized() {
        return this.sdkInitialized;
    }

    private boolean shouldTakeScreenshotForStory(String storyId) {
        return !this.disallowScreenshotStoryIds.contains(storyId);
    }

    boolean shouldRecordMessageType(MessageType type) {
        return !this.disabledMessageTypes.contains((Object)type);
    }

    boolean shouldRecordEventWithName(String eventName) {
        return this.disabledEventAndLogPattern == null || !this.disabledEventAndLogPattern.matcher(eventName).matches();
    }

    boolean shouldRecordNetworkRequest(String url) {
        return this.disabledUrlPattern == null || !this.disabledUrlPattern.matcher(url).matches();
    }

    boolean shouldTakeScreenshotForEvent(String eventName) {
        return this.disabledScreenshotPattern == null || !this.disabledScreenshotPattern.matcher(eventName).matches();
    }

    private boolean shouldComputeCpuData() {
        return Build.VERSION.SDK_INT < 26;
    }

    private synchronized void updateConfig(SdkConfig sdkConfig, boolean fromServer) throws EmbraceSdkException {
        EmbraceSharedPreferences embraceSharedPreferences;
        if (fromServer) {
            EmbraceSharedPreferences.getInstance().updateSdkConfigFetchedTimestamp(System.currentTimeMillis());
        }
        embraceSharedPreferences.setSdkDisabled(!sdkConfig.isEnabled(embraceSharedPreferences = EmbraceSharedPreferences.getInstance()));
        this.eventLateThresholds = sdkConfig.getEventLimits();
        this.screenshotsEnabled = sdkConfig.isScreenshotsEnabled();
        Set<String> configMessageTypes = sdkConfig.getDisabledMessageTypes();
        if (!configMessageTypes.isEmpty()) {
            for (MessageType messageType : MessageType.values()) {
                if (!configMessageTypes.contains(messageType.name().toLowerCase())) continue;
                this.disabledMessageTypes.add(messageType);
            }
        }
        this.disabledEventAndLogPattern = Pattern.compile(TextUtils.join((CharSequence)"|", sdkConfig.getDisabledEventAndLogPatterns()), 2);
        this.disabledUrlPattern = Pattern.compile(TextUtils.join((CharSequence)"|", sdkConfig.getDisabledUrlPatterns()), 2);
        this.disabledScreenshotPattern = Pattern.compile(TextUtils.join((CharSequence)"|", sdkConfig.getDisabledScreenshotPatterns()), 2);
        if (fromServer) {
            User.getInstance().updateServerPersonas(sdkConfig.getAppPersonas(), EmbraceSharedPreferences.getInstance());
        }
        if ((this.sdkDisabled || this.sdkInSafeMode) && sdkConfig.isEnabled(embraceSharedPreferences)) {
            this.reactivateSdk();
        } else if (!(this.sdkDisabled || this.sdkInSafeMode || sdkConfig.isEnabled(embraceSharedPreferences))) {
            this.disableSdk();
        }
        if (fromServer) {
            this.cacheConfig(sdkConfig);
        }
    }

    void fetchConfig() throws EmbraceSdkException {
        EmbraceServer.getInstance().fetchConfigurationCompletion(new EmbraceApiCallback(){

            @Override
            public void onSuccess(String response) throws EmbraceSdkException {
                EmbraceSharedPreferences.getInstance().recordStartupCompleted();
                try {
                    EmbraceManager.this.updateConfig(new SdkConfig(new JSONObject(response)), true);
                }
                catch (JSONException e) {
                    String msg = "Failed to create the config object: %s";
                    EmbraceSharedPreferences.getInstance().updateSdkConfigFetchedTimestamp(-1L);
                    EmbraceLogger.logError(msg, e);
                    throw new EmbraceSdkException(msg, e);
                }
                catch (Exception e) {
                    String msg = "An exception was thrown while attempting to update the SDK config: %s";
                    EmbraceLogger.logError(msg, e);
                    EmbraceSharedPreferences.getInstance().updateSdkConfigFetchedTimestamp(-1L);
                    throw new EmbraceSdkException(msg, e);
                }
            }

            @Override
            public void onError(String error, int statusCode) {
                EmbraceSharedPreferences.getInstance().updateSdkConfigFetchedTimestamp(-1L);
                EmbraceLogger.logError(String.format("error fetching config: %s", error));
            }

            @Override
            public void onException(Exception e) {
                EmbraceSharedPreferences.getInstance().updateSdkConfigFetchedTimestamp(-1L);
                EmbraceLogger.logError(String.format("error fetching config: %s", e.getLocalizedMessage()));
            }
        });
    }

    private synchronized void restoreConfig() throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.getPathForCache(FileCache.CONFIG).getLastPathSegment());
        int length = (int)file.length();
        byte[] bytes = new byte[length];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            in.read(bytes);
            JSONObject configJson = new JSONObject(new String(bytes));
            if (configJson != null) {
                this.updateConfig(new SdkConfig(configJson), false);
            }
        }
        catch (IOException e) {
            EmbraceLogger.logInfo("no cached config data found in cache");
        }
        catch (JSONException e) {
            EmbraceLogger.logError("error creating config object", e);
            throw new EmbraceSdkException("error creating config object", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
    }

    private synchronized void cacheConfig(SdkConfig config) throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), FileUtils.getPathForCache(FileCache.CONFIG).getLastPathSegment());
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(config.encodeObjectForSaving().getBytes("UTF-8"));
        }
        catch (FileNotFoundException e) {
            EmbraceLogger.logError("error openning file", e);
            throw new EmbraceSdkException("error openning file", e);
        }
        catch (IOException e) {
            EmbraceLogger.logError("error saving output stream", e);
            throw new EmbraceSdkException("error saving output stream", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    EmbraceLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
    }

    void disableSdk() {
        EmbraceLogger.logWarning("disabling sdk");
        this.sdkDisabled = true;
        this.sdkInSafeMode = true;
        this.deactivateDataManagers();
    }

    void reactivateSdk() {
        EmbraceLogger.logInfo("reactivating sdk");
        this.sdkDisabled = false;
        this.sdkInSafeMode = false;
        this.sdkInitialized = true;
        SessionManager.manager.sendSessionStartAfterReactivating();
        this.activateDataManagers();
    }

    void activateDataManagers() {
        boolean sdkDisabledFromSavedConfig = EmbraceSharedPreferences.getInstance().sdkDisabledFromSavedConfig();
        if (!sdkDisabledFromSavedConfig) {
            SessionManager.manager.enable();
            PowerManager.getManager().onSdkStatusChanged(true);
            MemoryManager.getManager().onManagerStatusChanged(true);
            if (this.shouldComputeCpuData()) {
                ProcessManager.getManager().onManagerStatusChanged(true);
            }
            NetworkManager.getManager().enable();
        } else {
            EmbraceLogger.logWarning("Sdk disabled in config, won't reactivate.");
        }
    }

    void deactivateDataManagers() {
        SessionManager.manager.disable(EmbraceSharedPreferences.getInstance().sdkDisabledFromSavedConfig());
        PowerManager.getManager().onSdkStatusChanged(false);
        MemoryManager.getManager().onManagerStatusChanged(false);
        if (this.shouldComputeCpuData()) {
            ProcessManager.getManager().onManagerStatusChanged(false);
        }
        NetworkManager.getManager().disable();
    }

    synchronized void startEvent(String name, String identifier, boolean takeScreenshot, Map<String, Object> properties) throws EmbraceSdkException {
        this.startEvent(name, identifier, takeScreenshot, properties, null);
    }

    synchronized void startEvent(String name, String identifier, boolean takeScreenshot, Map<String, Object> properties, Long startTime) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbraceLogger.logInfo(String.format("sdk is disabled, ignoring start event %s", name));
        } else if (!this.shouldRecordMessageType(MessageType.EVENT)) {
            EmbraceLogger.logWarning(String.format("event type is disabled, ignoring start event %s", name));
        } else if (!this.shouldRecordEventWithName(name)) {
            EmbraceLogger.logWarning(String.format("event is disabled, ignoring start event %s", name));
        } else if (EmbraceEvent.validateEventName(name, identifier)) {
            if (this.shouldComputeCpuData()) {
                ProcessManager.getManager().onManagerStatusChanged(true);
            }
            final String eventId = this.getInternalEventKey(name, identifier);
            EmbraceEvent startEvent = new EmbraceEvent(EmbraceEvent.Type.START, name, properties);
            startEvent.setSessionId(SessionManager.manager.getCurrentSessionId());
            if (startTime != null) {
                startEvent.updateWithStartTime(startTime);
            }
            this.events.put(eventId, startEvent);
            this.activeStories.put(startEvent.getStoryId(), (Serializable)((Object)eventId));
            if (!takeScreenshot) {
                this.disallowScreenshotStoryIds.add(startEvent.getStoryId());
            }
            this.updateUnfinishedStoriesLog();
            Long lateThresholdInMilliseconds = this.getLateThresholdForEventWithName(name);
            startEvent.setLateThreshold(lateThresholdInMilliseconds - (startTime != null ? System.currentTimeMillis() - startTime : 0L));
            ScheduledFuture<?> lateTimer = this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        EmbraceManager.this.sendLateEventForIdentifier(eventId);
                    }
                    catch (EmbraceSdkException e) {
                        EmbraceLogger.logError(String.format("Error sending late event with identifier %s with error", eventId), e);
                    }
                }
            }, (long)lateThresholdInMilliseconds, TimeUnit.MILLISECONDS);
            this.addObjectWithKey(lateTimer, eventId, MapResource.LATE_TIMERS);
            this.addMetadataPayloadsToEvent(startEvent, null);
            EmbraceServer.getInstance().sendEvent(startEvent, null);
            SessionManager.manager.recordNewStory(startEvent.getStoryId());
        }
    }

    synchronized void endEvent(String name, String identifier) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbraceLogger.logInfo(String.format("sdk is disabled, ignoring end event %s", name));
        } else if (!this.shouldRecordMessageType(MessageType.EVENT)) {
            EmbraceLogger.logWarning(String.format("event type is disabled, ignoring end event %s", name));
        } else if (!this.shouldRecordEventWithName(name)) {
            EmbraceLogger.logWarning(String.format("event is disabled, ignoring end event %s", name));
        } else if (EmbraceEvent.validateEventName(name, identifier)) {
            String eventId = this.getInternalEventKey(name, identifier);
            EmbraceEvent startEvent = this.events.get(eventId);
            if (startEvent == null) {
                EmbraceLogger.logError(String.format("no start event found for end event with name: %s identifier: %s", name, identifier));
                return;
            }
            EmbraceEvent endEvent = new EmbraceEvent(EmbraceEvent.Type.END, name, startEvent.getStoryId());
            endEvent.setSessionId(SessionManager.manager.getCurrentSessionId());
            endEvent.updateWithStartTime(startEvent.getTimestamp());
            this.addMetadataPayloadsToEvent(endEvent, startEvent);
            EmbraceServer.getInstance().sendEvent(endEvent, null);
            this.events.remove(eventId);
            this.activeStories.remove(startEvent.getStoryId());
            this.disallowScreenshotStoryIds.remove(startEvent.getStoryId());
            this.updateUnfinishedStoriesLog();
            this.removeTimer(eventId);
            if (this.activeStories.size() == 0) {
                ProcessManager.getManager().onManagerStatusChanged(false);
            }
        }
    }

    synchronized void logNetworkCall(String url, String httpMethod, Integer statusCode, long startTime, long endTime, Long bytesSent, Long bytesReceived) throws InterruptedException {
        if (this.shouldRecordNetworkRequest(url)) {
            NetworkManager.getManager().logNetworkCall(url, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived);
        } else {
            EmbraceLogger.logWarning(String.format("recording of network call for url %s is disabled", url));
        }
    }

    synchronized void logNetworkError(String url, String httpMethod, long startTime, long endTime, String errorType, String errorMessage) throws InterruptedException {
        if (this.shouldRecordNetworkRequest(url)) {
            NetworkManager.getManager().logNetworkError(url, httpMethod, startTime, endTime, errorType, errorMessage);
        } else {
            EmbraceLogger.logWarning(String.format("recording of network call for url %s is disabled", url));
        }
    }

    private synchronized void updateUnfinishedStoriesLog() throws EmbraceSdkException {
        FileUtils.saveMapToFile(this.activeStories, FileCache.ACTIVE_STORIES);
    }

    private void addMetadataPayloadsToEvent(EmbraceEvent event, EmbraceEvent startEvent) {
        switch (event.getType()) {
            case INFO_LOG: 
            case ERROR_LOG: 
            case WARNING_LOG: 
            case START: {
                event.addPayload(Device.getInstance().getDeviceInfoJsonObject(), "d");
                event.addPayload(Device.getInstance().getTelephonyInfo(), "tl");
                event.addPayload(Device.getInstance().getAppInfoJsonObject(), "a");
                break;
            }
            case LATE: 
            case END: 
            case INTERRUPT: {
                this.addPerformanceMetadataToEvent(event, startEvent);
                break;
            }
            case CRASH: {
                event.addPayload(Device.getInstance().getDeviceInfoJsonObject(), "d");
                event.addPayload(Device.getInstance().getAppInfoJsonObject(), "a");
                break;
            }
        }
        event.addPayload(User.getInstance().toJsonObject(), "u");
    }

    private void addPerformanceMetadataToEvent(EmbraceEvent event, EmbraceEvent startEvent) {
        if (startEvent == null || startEvent.getTimestamp() == null) {
            EmbraceLogger.logError("can't calculate performance data without start event");
            return;
        }
        JSONObject performance = new JSONObject();
        try {
            performance.put("bt", (double)PowerManager.getManager().getBatteryLevel());
            performance.put("ds", (Object)Device.getInstance().getSystemMemoryAsJson());
            JSONArray memorySamplesJsonArray = new JSONArray();
            for (MemorySample memorySample : MemoryManager.getManager().getMemorySamplesWithinInterval(startEvent.getTimestamp(), event.getTimestamp())) {
                memorySamplesJsonArray.put((Object)memorySample.toJson());
            }
            performance.put("me", (Object)memorySamplesJsonArray);
            List<SystemEvent> lowMemoryWarnings = MemoryManager.getManager().getMemoryWarningsWithinInterval(startEvent.getTimestamp(), event.getTimestamp());
            JSONArray lowMemoryPayload = new JSONArray();
            for (SystemEvent systemEvent : lowMemoryWarnings) {
                lowMemoryPayload.put((Object)systemEvent.toJson());
            }
            performance.put("mw", (Object)lowMemoryPayload);
            JSONArray chargingIntervalsJsonArray = new JSONArray();
            for (IntervalMeasurement intervalMeasurement : PowerManager.getManager().getChargingIntervalsBetween(startEvent.getTimestamp(), event.getTimestamp())) {
                chargingIntervalsJsonArray.put((Object)intervalMeasurement.getServerPayload());
            }
            performance.put("bc", (Object)chargingIntervalsJsonArray);
            JSONArray jSONArray = new JSONArray();
            for (IntervalMeasurement intervalMeasurement : PowerManager.getManager().getPowerSaveModeIntervalsBetween(startEvent.getTimestamp(), event.getTimestamp())) {
                jSONArray.put((Object)intervalMeasurement.getServerPayload());
            }
            performance.put("lp", (Object)jSONArray);
            JSONArray jSONArray2 = new JSONArray();
            for (IntervalMeasurement embInterval : ProcessManager.getManager().getCriticalIntervalsBetweenWithDuration(startEvent.getTimestamp(), event.getTimestamp())) {
                jSONArray2.put((Object)embInterval.getServerPayload());
            }
            performance.put("cp", (Object)jSONArray2);
            List<IntervalMeasurement> list = NetworkManager.getManager().getReachabilityIntervalsBetween(startEvent.getTimestamp(), event.getTimestamp());
            JSONArray netInterfacePayload = new JSONArray();
            for (IntervalMeasurement interval : list) {
                netInterfacePayload.put((Object)interval.getServerPayload());
            }
            performance.put("ns", (Object)netInterfacePayload);
            List<NetworkCall> networkCalls = NetworkManager.getManager().getRequestsBetween(startEvent.getTimestamp(), event.getTimestamp());
            JSONArray netRequestsPayload = new JSONArray();
            for (NetworkCall networkCall : networkCalls) {
                netRequestsPayload.put((Object)networkCall.toJson());
            }
            performance.put("nr", (Object)netRequestsPayload);
        }
        catch (JSONException e) {
            performance = null;
        }
        event.addPayload(performance, "p");
    }

    private void addStackTrace(List<String> stackTraces, EmbraceEvent event) {
        JSONObject jsonObject = new JSONObject();
        JSONArray stackTracesJsonArray = new JSONArray();
        for (String stackTrace : stackTraces) {
            stackTracesJsonArray.put((Object)stackTrace);
        }
        try {
            jsonObject.put("tt", (Object)stackTracesJsonArray);
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        event.addPayload(jsonObject, "sk");
    }

    private String getInternalEventKey(String eventName, String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return eventName;
        }
        return String.format("%s%s%s", eventName, "#", identifier);
    }

    String getEventNameFromInternalKey(String eventId) {
        String[] splittedArray = eventId.split("#");
        return splittedArray[0];
    }

    private Long getLateThresholdForEventWithName(String eventName) {
        if (this.eventLateThresholds == null || eventName == null) {
            return 5000L;
        }
        Long threshold = this.eventLateThresholds.get(eventName);
        if (threshold != null) {
            return threshold;
        }
        Long defaultThreshold = this.eventLateThresholds.get("_default");
        if (defaultThreshold != null) {
            return defaultThreshold;
        }
        return 5000L;
    }

    private void sendLateEventForIdentifier(String identifier) throws EmbraceSdkException {
        if (identifier == null) {
            EmbraceLogger.logError("can't fire late message for event with null identifier");
        } else if (!this.shouldRecordEvents()) {
            EmbraceLogger.logInfo(String.format("sdk is disabled, ignoring late event %s", identifier));
            this.removeTimer(identifier);
        } else if (!this.shouldRecordMessageType(MessageType.EVENT)) {
            EmbraceLogger.logWarning(String.format("event type is disabled, ignoring late event %s", identifier));
            this.removeTimer(identifier);
        } else {
            EmbraceEvent event = this.events.get(identifier);
            if (event == null) {
                EmbraceLogger.logError(String.format("can't fire late message for event %s: start event not found", identifier));
            } else if (!this.shouldRecordEventWithName(event.getName())) {
                EmbraceLogger.logWarning(String.format("event is disabled, ignoring late event %s", event.getName()));
                this.removeTimer(identifier);
            } else if (event.isLate()) {
                this.removeTimer(identifier);
            } else {
                EmbraceLogger.logInfo(String.format("event %s is late, sending late message", identifier));
                EmbraceEvent lateEvent = new EmbraceEvent(EmbraceEvent.Type.LATE, this.getEventNameFromInternalKey(identifier), event.getStoryId());
                lateEvent.setSessionId(SessionManager.manager.getCurrentSessionId());
                lateEvent.updateWithStartTime(event.getTimestamp());
                this.addMetadataPayloadsToEvent(lateEvent, event);
                boolean screenshotTaken = false;
                if (this.shouldTakeScreenshotForStory(event.getStoryId()) && this.shouldTakeScreenshotForEvent(event.getName())) {
                    screenshotTaken = SessionManager.manager.triggerEventSnapshot(lateEvent.getStoryId(), SessionManager.EmbScreenshotReason.MOMENT_LATE);
                    this.removeObjectWithKey(event.getStoryId(), MapResource.SCREENSHOTS);
                }
                lateEvent.setScreenshotTaken(screenshotTaken);
                EmbraceServer.getInstance().sendEvent(lateEvent, null);
                event.setLate(true);
                this.removeTimer(identifier);
            }
        }
    }

    private synchronized void removeObjectWithKey(String key, MapResource resource) {
        if (key == null) {
            EmbraceLogger.logError("can't remove object with null key from shared dictinary");
            return;
        }
        switch (resource) {
            case EVENTS: {
                this.events.remove(key);
                break;
            }
            case ACTIVE_STORIES: {
                this.activeStories.remove(key);
                break;
            }
            case LATE_TIMERS: {
                this.eventLateTimers.remove(key);
                break;
            }
            case SCREENSHOTS: {
                this.disallowScreenshotStoryIds.remove(key);
                break;
            }
        }
    }

    private synchronized void addObjectWithKey(Object value, String key, MapResource resource) {
        if (key == null) {
            EmbraceLogger.logError("can't remove object with null key from shared dictinary");
            return;
        }
        switch (resource) {
            case EVENTS: {
                this.events.put(key, (EmbraceEvent)value);
                break;
            }
            case ACTIVE_STORIES: {
                this.activeStories.put(key, (Serializable)((Object)((String)value)));
                break;
            }
            case LATE_TIMERS: {
                this.eventLateTimers.put(key, (Future)value);
                break;
            }
            case SCREENSHOTS: {
                this.disallowScreenshotStoryIds.add((String)value);
                break;
            }
        }
    }

    private void removeTimer(String identifier) {
        Future lateTimer = this.eventLateTimers.get(identifier);
        if (lateTimer != null) {
            lateTimer.cancel(true);
            this.removeObjectWithKey(identifier, MapResource.LATE_TIMERS);
        }
    }

    int getProblematicRequestLatency() {
        return 500;
    }

    synchronized void processAndSendCrash(Throwable throwable) throws EmbraceSdkException {
        if (!this.pendingThrowables.contains(throwable)) {
            this.pendingThrowables.add(throwable);
            SessionManager.manager.saveSessionAfterCrash();
            this.sendCrashReportWithData(throwable);
        }
    }

    void sendCrashReportWithData(Throwable throwable) throws EmbraceSdkException {
        EmbraceEvent crashEvent = new EmbraceEvent(EmbraceEvent.Type.CRASH, "_crash_report");
        crashEvent.setSessionId(SessionManager.manager.getCurrentSessionId());
        crashEvent.setStoryId(TextUtils.join((CharSequence)",", this.activeStories.keySet()));
        JSONObject crashPayload = this.getCrashEventPayload(throwable);
        if (crashPayload != null) {
            crashEvent.addPayload(crashPayload, "cr");
        }
        this.addMetadataPayloadsToEvent(crashEvent, null);
        EmbraceServer.getInstance().sendEvent(crashEvent, null);
    }

    Stack<EmbraceException> getCrashPayload(Throwable throwable) {
        Stack<EmbraceException> embraceExceptions = new Stack<EmbraceException>();
        while (throwable != null && !throwable.equals(throwable.getCause())) {
            EmbraceException embraceException = new EmbraceException();
            ArrayList<String> stackTraceList = new ArrayList<String>();
            embraceException.setExceptionName(throwable.getClass().getName().trim());
            embraceException.setExceptionMessage(throwable.getMessage() != null ? throwable.getMessage().trim() : "");
            for (StackTraceElement stackTrace : throwable.getStackTrace()) {
                stackTraceList.add(stackTrace.toString().trim());
            }
            embraceException.setExceptionStackTrace(stackTraceList);
            embraceExceptions.push(embraceException);
            throwable = throwable.getCause();
        }
        return embraceExceptions;
    }

    JSONObject getCrashEventPayload(Throwable throwable) {
        JSONArray array = new JSONArray();
        Stack<EmbraceException> embraceExceptions = this.getCrashPayload(throwable);
        while (!embraceExceptions.empty()) {
            array.put((Object)embraceExceptions.pop().toJson());
        }
        JSONObject crashPayload = new JSONObject();
        try {
            crashPayload.put("id", (Object)Uuid.getEmbUuid(UUID.randomUUID().toString()));
            crashPayload.put("ex", (Object)array);
        }
        catch (JSONException e) {
            crashPayload = null;
        }
        return crashPayload;
    }

    boolean isScreenshotsEnabled() {
        return this.screenshotsEnabled;
    }

    void setForegroundActivity(Activity activity) {
        if (activity != null) {
            if (this.foregroundActivity == null || !activity.equals(this.foregroundActivity.get())) {
                this.foregroundActivity = new WeakReference<Activity>(activity);
            }
        } else {
            this.foregroundActivity = null;
        }
    }

    Activity getForegroundActivity() {
        return this.foregroundActivity != null ? (Activity)this.foregroundActivity.get() : null;
    }

    static enum MessageType {
        EVENT,
        LOG,
        SESSION,
        USER;

    }

    private static enum MapResource {
        EVENTS,
        ACTIVE_STORIES,
        LATE_TIMERS,
        SCREENSHOTS;

    }
}

