/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.CustomFlow;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Properties;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.util.Map;

public final class SubscriptionPurchaseFlow
extends CustomFlow {
    static final String MOMENT_SUBSCRIPTION_PURCHASE = "_subscription-purchase";
    static final String PROP_AMOUNT = "amount";
    static final String PROP_ORDER_ID = "order-id";
    static final String PROP_PAYMENT_TYPE = "payment-type";
    static final String PROP_SUBSCRIPTION_TYPE = "subscription-type";
    Map<String, Object> purchaseProps;
    String purchaseMomentId;

    public synchronized boolean subscriptionPurchaseStart(String orderId, String subscriptionType, Number amount, String paymentType, Map<String, Object> properties) {
        if (this.embraceMgr == null) {
            return false;
        }
        properties = Properties.normalizeProperties(properties);
        if (orderId != null) {
            properties.put(PROP_ORDER_ID, orderId);
        }
        if (subscriptionType != null) {
            properties.put(PROP_SUBSCRIPTION_TYPE, subscriptionType);
        }
        if (amount != null) {
            properties.put(PROP_AMOUNT, amount);
        }
        if (paymentType != null) {
            properties.put(PROP_PAYMENT_TYPE, paymentType);
        }
        this.purchaseProps = properties;
        this.purchaseMomentId = Uuid.getEmbUuid();
        this.sendMomentStartEvent(MOMENT_SUBSCRIPTION_PURCHASE, this.purchaseMomentId, false, properties);
        return true;
    }

    public synchronized boolean subscriptionPurchaseComplete() {
        if (this.embraceMgr == null) {
            return false;
        }
        if (this.purchaseMomentId == null) {
            EmbraceLogger.logError("Subscription purchase moment identifier is null or blank.");
            return false;
        }
        this.sendMomentEndEvent(MOMENT_SUBSCRIPTION_PURCHASE, this.purchaseMomentId);
        this.sendLogInfo("Subscription purchase was completed.", this.purchaseProps);
        Embrace.getInstance().setUserAsPayer();
        this.purchaseMomentId = null;
        return true;
    }

    public synchronized boolean subscriptionPurchaseFail(String msg) {
        if (this.embraceMgr == null) {
            return false;
        }
        if (msg != null) {
            this.purchaseProps.put("message", msg);
        } else if (this.purchaseMomentId == null) {
            EmbraceLogger.logError("Subscription purchase moment identifier is null or blank.");
            return false;
        }
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? "A failure occurred during subscription purchase." : "A failure occurred during subscription purchase: " + msg;
        this.sendMomentEndEvent(MOMENT_SUBSCRIPTION_PURCHASE, this.purchaseMomentId);
        this.sendLogError(errorLogMsg, true, this.purchaseProps);
        this.purchaseMomentId = null;
        return true;
    }
}

