/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network;

import android.os.Build;
import io.embrace.android.embracesdk.network.http.EmbraceHttpUrlStreamHandler;
import io.embrace.android.embracesdk.network.http.EmbraceHttpsUrlStreamHandler;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;

public final class EmbraceUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    static final String PROTOCOL_HTTP = "http";
    static final String PROTOCOL_HTTPS = "https";
    static final String CLASS_HTTP_LIBCORE_STREAM_HANDLER = "libcore.net.http.HttpHandler";
    static final String CLASS_HTTP_OKHTTP_STREAM_HANDLER = "com.android.okhttp.HttpHandler";
    static final String CLASS_HTTPS_LIBCORE_STREAM_HANDLER = "libcore.net.http.HttpsHandler";
    static final String CLASS_HTTPS_OKHTTP_STREAM_HANDLER = "com.android.okhttp.HttpsHandler";
    static final Map<String, URLStreamHandler> handlers = new HashMap<String, URLStreamHandler>();

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        return protocol != null ? handlers.get(protocol) : null;
    }

    static URLStreamHandler newUrlStreamHandler(String className) {
        try {
            return (URLStreamHandler)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        if (Build.VERSION.SDK_INT < 19) {
            handlers.put(PROTOCOL_HTTP, new EmbraceHttpUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTP_LIBCORE_STREAM_HANDLER)));
            handlers.put(PROTOCOL_HTTPS, new EmbraceHttpsUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTPS_LIBCORE_STREAM_HANDLER)));
        } else {
            handlers.put(PROTOCOL_HTTP, new EmbraceHttpUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTP_OKHTTP_STREAM_HANDLER)));
            handlers.put(PROTOCOL_HTTPS, new EmbraceHttpsUrlStreamHandler(EmbraceUrlStreamHandlerFactory.newUrlStreamHandler(CLASS_HTTPS_OKHTTP_STREAM_HANDLER)));
        }
    }
}

