/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.CustomFlow;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.Properties;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.util.Map;

public final class SubscriptionPurchaseFlow
extends CustomFlow {
    static final String MOMENT_SUBSCRIPTION_PURCHASE = "_subscription-purchase";
    static final String PROP_AMOUNT = "amount";
    static final String PROP_MESSAGE = "message";
    static final String PROP_ORDER_ID = "order-id";
    static final String PROP_PAYMENT_TYPE = "payment-type";
    static final String PROP_SUBSCRIPTION_TYPE = "subscription-type";
    Status status = Status.OPEN;
    Map<String, Object> purchaseProps;
    String purchaseMomentId;

    public synchronized boolean subscriptionPurchaseStart(String orderId, String subscriptionType, Number amount, String paymentType, Map<String, Object> properties) {
        if (this.status != Status.OPEN) {
            this.logError("Subscription purchase flow is not in a state where the subscription purchase can be started.", false, null);
            return false;
        }
        properties = Properties.normalizeProperties(properties);
        if (orderId != null) {
            properties.put(PROP_ORDER_ID, orderId);
        }
        if (subscriptionType != null) {
            properties.put(PROP_SUBSCRIPTION_TYPE, subscriptionType);
        }
        if (amount != null) {
            properties.put(PROP_AMOUNT, amount);
        }
        if (paymentType != null) {
            properties.put(PROP_PAYMENT_TYPE, paymentType);
        }
        this.purchaseProps = properties;
        this.purchaseMomentId = Uuid.getEmbUuid();
        this.momentStart(MOMENT_SUBSCRIPTION_PURCHASE, this.purchaseMomentId, false, properties);
        this.status = Status.PURCHASING;
        return true;
    }

    public synchronized boolean subscriptionPurchaseComplete() {
        if (this.status != Status.PURCHASING) {
            this.logError("Subscription purchase flow is not in a state where the purchase moment can be completed.", false, this.purchaseProps);
            return false;
        }
        this.logInfo("Subscription purchase was completed.", this.purchaseProps);
        this.momentEnd(MOMENT_SUBSCRIPTION_PURCHASE, this.purchaseMomentId);
        Embrace.getInstance().setUserAsPayer();
        this.status = Status.CLOSED;
        return true;
    }

    public synchronized boolean subscriptionPurchaseFail(String msg) {
        if (this.status != Status.PURCHASING) {
            this.logError("Subscription purchase flow is not in a state where the purchase moment can be failed.", false, this.purchaseProps);
            return false;
        }
        if (msg != null) {
            this.purchaseProps.put(PROP_MESSAGE, msg);
        }
        this.logError("A failure occurred during subscription purchase.", true, this.purchaseProps);
        this.momentEnd(MOMENT_SUBSCRIPTION_PURCHASE, this.purchaseMomentId);
        this.status = Status.CLOSED;
        return true;
    }

    static enum Status {
        OPEN,
        PURCHASING,
        CLOSED;

    }
}

