/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.CustomFlow;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.Properties;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.util.Map;

public final class RegistrationFlow
extends CustomFlow {
    public static final long FLAG_SET_USER_PAYER = 1L;
    static final String MOMENT_INTERNAL_REGISTRATION = "_internal-registration";
    static final String MOMENT_EXTERNAL_REGISTRATION = "_external-registration";
    static final String PROP_EMAIL = "email";
    static final String PROP_MESSAGE = "message";
    static final String PROP_REGISTRATION_SOURCE = "registration-source";
    static final String PROP_USERNAME = "username";
    static final String PROP_USER_ID = "user-id";
    Status status = Status.OPEN;
    Map<String, Object> registrationProps;
    String registrationMomentName;
    String registrationMomentId;

    public synchronized boolean registrationStart(String userId, String username, String email, Map<String, Object> properties) {
        if (this.status != Status.OPEN) {
            this.logError("Registration flow is not in a state where the registration moment can be started.", false, null);
            return false;
        }
        properties = Properties.normalizeProperties(properties);
        if (userId != null) {
            properties.put(PROP_USER_ID, userId);
        }
        if (username != null) {
            properties.put(PROP_USERNAME, username);
        }
        if (email != null) {
            properties.put(PROP_EMAIL, email);
        }
        return this.sendRegistrationStartMoment(MOMENT_INTERNAL_REGISTRATION, properties);
    }

    public synchronized boolean registrationStart(String registrationSource, Map<String, Object> properties) {
        if (this.status != Status.OPEN) {
            this.logError("Registration flow is not in a state where the registration moment can be started.", false, null);
            return false;
        }
        properties = Properties.normalizeProperties(properties);
        if (registrationSource != null) {
            properties.put(PROP_REGISTRATION_SOURCE, registrationSource);
        }
        return this.sendRegistrationStartMoment(MOMENT_EXTERNAL_REGISTRATION, properties);
    }

    boolean sendRegistrationStartMoment(String momentName, Map<String, Object> properties) {
        this.registrationMomentName = momentName;
        this.registrationProps = properties;
        this.registrationMomentId = Uuid.getEmbUuid();
        this.momentStart(momentName, this.registrationMomentId, false, properties);
        this.status = Status.REGISTERING;
        return true;
    }

    public synchronized boolean registrationComplete() {
        return this.registrationComplete(null);
    }

    public synchronized boolean registrationComplete(Boolean isPayer) {
        if (this.status != Status.REGISTERING) {
            this.logError("Registration flow is not in a state where the registration moment can be completed.", false, this.registrationProps);
            return false;
        }
        this.logInfo("Registration was completed.", this.registrationProps);
        this.momentEnd(this.registrationMomentName, this.registrationMomentId);
        Embrace embrace = Embrace.getInstance();
        try {
            this.embraceMgr.endEvent(this.registrationMomentName, this.registrationMomentId);
            if (isPayer != null) {
                if (isPayer.booleanValue()) {
                    embrace.setUserAsPayer();
                } else {
                    embrace.clearUserAsPayer();
                }
            }
            String email = (String)this.registrationProps.get(PROP_EMAIL);
            String username = (String)this.registrationProps.get(PROP_USERNAME);
            String userId = (String)this.registrationProps.get(PROP_USER_ID);
            if (!TextUtils.isEmpty((CharSequence)email)) {
                embrace.setUserEmail(email);
            }
            if (!TextUtils.isEmpty((CharSequence)username)) {
                embrace.setUsername(username);
            }
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                embrace.setUserIdentifier(userId);
            }
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logError("An error occurred while reporting registration completed.", e);
        }
        this.status = Status.CLOSED;
        return true;
    }

    public synchronized boolean registrationFail(String msg) {
        if (this.status != Status.REGISTERING) {
            this.logError("Registration flow is not in a state where the registration moment can be failed.", false, this.registrationProps);
            return false;
        }
        if (msg != null) {
            this.registrationProps.put(PROP_MESSAGE, msg);
        }
        this.logError("A failure occurred during registration.", true, this.registrationProps);
        this.momentEnd(this.registrationMomentName, this.registrationMomentId);
        this.status = Status.CLOSED;
        return true;
    }

    static enum Status {
        OPEN,
        REGISTERING,
        CLOSED;

    }
}

